/*
 * Decompiled with CFR 0.152.
 */
package tigase.disco;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.disco.ServiceIdentity;
import tigase.xml.Element;

public class ServiceEntity {
    private static Logger log = Logger.getLogger(ServiceEntity.class.getName());
    private String jid = null;
    private String node = null;
    private String name = null;
    private Set<String> features = null;
    private List<ServiceIdentity> identities = null;
    private Set<ServiceEntity> items = null;
    private boolean adminOnly = false;

    public ServiceEntity(String jid, String node, String name) {
        this.jid = jid;
        this.node = node;
        this.name = name;
    }

    public ServiceEntity(String jid, String node, String name, boolean adminOnly) {
        this.jid = jid;
        this.node = node;
        this.name = name;
        this.adminOnly = adminOnly;
    }

    public void setAdminOnly(boolean adminOnly) {
        this.adminOnly = adminOnly;
    }

    public boolean isAdminOnly() {
        return this.adminOnly;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServiceEntity) {
            ServiceEntity se = (ServiceEntity)obj;
            return se != null && this.jid.equals(se.jid) && (this.node == se.node || (this.node != null ? this.node.equals(se.node) : se.node.equals(this.node)));
        }
        return false;
    }

    public int hashCode() {
        return (this.jid != null ? this.jid.hashCode() : 0) + (this.node != null ? this.node.hashCode() : 0);
    }

    public void addFeatures(String ... features) {
        if (this.features == null) {
            this.features = new LinkedHashSet<String>();
        }
        Collections.addAll(this.features, features);
    }

    public void setFeatures(String ... features) {
        this.features = null;
        this.addFeatures(features);
    }

    public void addIdentities(ServiceIdentity ... identities) {
        if (this.identities == null) {
            this.identities = new ArrayList<ServiceIdentity>();
        }
        Collections.addAll(this.identities, identities);
    }

    public void addItems(ServiceEntity ... items) {
        if (this.items == null) {
            this.items = new LinkedHashSet<ServiceEntity>();
        }
        for (ServiceEntity item : items) {
            if (this.items.contains(item)) {
                this.items.remove(item);
            }
            this.items.add(item);
        }
    }

    public void removeItems(ServiceEntity ... items) {
        if (this.items == null) {
            return;
        }
        for (ServiceEntity item : items) {
            this.items.remove(item);
        }
    }

    public String getJID() {
        return this.jid;
    }

    public String getNode() {
        return this.node;
    }

    public String getName() {
        return this.name;
    }

    public Element getDiscoInfo(String node) {
        return this.getDiscoInfo(node, true);
    }

    public Element getDiscoInfo(String node, boolean admin) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Node: " + node);
        }
        Element query = null;
        if (node == null) {
            if (this.adminOnly && !admin) {
                return null;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("It's me: " + this.toString());
            }
            query = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#info"});
            if (this.identities != null) {
                for (ServiceIdentity ident : this.identities) {
                    query.addChild(ident.getElement());
                }
            }
            if (this.features != null) {
                for (String feature : this.features) {
                    query.addChild(new Element("feature", new String[]{"var"}, new String[]{feature}));
                }
            }
        } else {
            ServiceEntity entity = this.findNode(node);
            if (entity != null && entity.adminOnly && !admin) {
                entity = null;
            }
            if (entity != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Found child node: " + entity.toString());
                }
                query = entity.getDiscoInfo(null);
                query.setAttribute("node", node);
            }
        }
        return query;
    }

    public Element[] getDiscoFeatures(String node) {
        ArrayList<Element> elFeatures = new ArrayList<Element>();
        if (this.features != null) {
            for (String feature : this.features) {
                elFeatures.add(new Element("feature", new String[]{"var"}, new String[]{feature}));
            }
        }
        return elFeatures.size() > 0 ? elFeatures.toArray(new Element[elFeatures.size()]) : null;
    }

    public Element getDiscoItem(String node, String jid) {
        Element item = new Element("item");
        if (jid != null) {
            item.setAttribute("jid", jid);
        } else if (this.jid != null) {
            item.setAttribute("jid", this.jid);
        }
        if (node != null) {
            item.setAttribute("node", node + (this.node != null ? "/" + this.node : ""));
        } else if (this.node != null) {
            item.setAttribute("node", this.node);
        }
        if (this.name != null) {
            item.setAttribute("name", this.name);
        }
        return item;
    }

    public List<Element> getItems(String node, String jid) {
        return this.getItems(node, jid, true);
    }

    public List<Element> getItems(String node, String jid, boolean admin) {
        ArrayList<Element> result = null;
        if (this.items != null) {
            result = new ArrayList<Element>();
            for (ServiceEntity item : this.items) {
                if (item.adminOnly && !admin) continue;
                result.add(item.getDiscoItem(node, jid));
            }
        }
        return result;
    }

    public List<Element> getDiscoItems(String node, String jid) {
        return this.getDiscoItems(node, jid, true);
    }

    public List<Element> getDiscoItems(String node, String jid, boolean admin) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("node: " + node + ", jid: " + jid);
        }
        List<Element> result = null;
        if (node == null) {
            result = this.getItems(null, jid, admin);
        } else {
            ServiceEntity entity = this.findNode(node);
            if (entity != null && entity.adminOnly && !admin) {
                entity = null;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Found disco entity: " + (entity != null ? entity.toString() : null));
            }
            if (entity != null) {
                result = entity.getItems(node, jid, admin);
            }
        }
        return result;
    }

    public ServiceEntity findNode(String node) {
        String top;
        ServiceEntity current;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Looking for a node: " + node);
        }
        if (this.node != null && this.node.equals(node)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Found myself: " + this.toString());
            }
            return this;
        }
        if (this.items == null) {
            return null;
        }
        for (ServiceEntity item : this.items) {
            String n = item.getNode();
            if (n == null || !node.equals(n)) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Found child item: " + item.toString());
            }
            return item;
        }
        int idx = node.indexOf(47);
        if (idx >= 0 && (current = this.findNode(top = node.substring(0, idx))) != null) {
            String rest = node.substring(idx + 1);
            return current.findNode(rest);
        }
        return null;
    }

    public String toString() {
        return this.getDiscoItem(null, null).toString();
    }

    public void setDescription(String description) {
        this.name = description;
    }
}

