/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import tigase.db.AuthRepository;
import tigase.db.AuthRepositoryPool;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataRepositoryPool;
import tigase.db.UserRepository;
import tigase.db.UserRepositoryPool;

public abstract class RepositoryFactory {
    public static final int DATA_REPO_POOL_SIZE_PROP_VAL = 10;
    public static final String DATA_REPO_CLASS_PROP_KEY = "data-repo";
    public static final String DATA_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.DataRepositoryImpl";
    public static final String DATA_REPO_POOL_CLASS_PROP_KEY = "data-repo-pool";
    public static final String DATA_REPO_POOL_CLASS_PROP_VAL = "tigase.db.DataRepositoryPool";
    public static final String DATA_REPO_POOL_SIZE = "--data-repo-pool-size";
    public static final String DATA_REPO_POOL_SIZE_PROP_KEY = "data-repo-pool-size";
    public static final int AUTH_REPO_POOL_SIZE_PROP_VAL = 10;
    public static final String AUTH_REPO_CLASS_PROP_KEY = "auth-repo-class";
    public static final String AUTH_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.TigaseCustomAuth";
    public static final String AUTH_REPO_POOL_CLASS = "--auth-repo-pool";
    public static final String AUTH_REPO_POOL_CLASS_PROP_KEY = "auth-repo-pool";
    public static final String AUTH_REPO_POOL_CLASS_PROP_DEF = "tigase.db.AuthRepositoryPool";
    public static final String AUTH_REPO_POOL_CLASS_PROP_VAL = null;
    public static final String AUTH_REPO_POOL_SIZE_PROP_KEY = "auth-repo-pool-size";
    public static final String AUTH_REPO_POOL_SIZE = "--auth-repo-pool-size";
    public static final String AUTH_DOMAIN_POOL_CLASS = "--auth-domain-repo-pool";
    public static final String AUTH_DOMAIN_POOL_CLASS_PROP_KEY = "auth-domain-repo-pool";
    public static final String AUTH_DOMAIN_POOL_CLASS_PROP_VAL = "tigase.db.AuthRepositoryMDImpl";
    public static final String AUTH_REPO_DOMAINS_PROP_KEY = "auth-repo-domains";
    public static final String AUTH_REPO_PARAMS_NODE = "auth-repo-params";
    public static final String AUTH_REPO_URL_PROP_KEY = "auth-repo-url";
    public static final String SHARED_AUTH_REPO_PARAMS_PROP_KEY = "shared-auth-repo-params";
    public static final String SHARED_AUTH_REPO_PROP_KEY = "shared-auth-repo";
    public static final String TIGASE_AUTH_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.TigaseAuth";
    public static final String TIGASE_AUTH_REPO_URL_PROP_VAL = "jdbc:mysql://localhost/tigasedb?user=tigase_user&password=mypass";
    public static final String TIGASE_CUSTOM_AUTH_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.TigaseCustomAuth";
    public static final String GEN_AUTH_DB = "--auth-db";
    public static final String GEN_AUTH_DB_URI = "--auth-db-uri";
    public static final int USER_REPO_POOL_SIZE_PROP_VAL = 10;
    public static final String GEN_USER_DB = "--user-db";
    public static final String GEN_USER_DB_URI = "--user-db-uri";
    public static final String GEN_USER_DB_URI_PROP_KEY = "user-db-uri";
    public static final String SHARED_USER_REPO_PARAMS_PROP_KEY = "shared-user-repo-params";
    public static final String SHARED_USER_REPO_PROP_KEY = "shared-user-repo";
    public static final String USER_DOMAIN_POOL_CLASS = "--user-domain-repo-pool";
    public static final String USER_DOMAIN_POOL_CLASS_PROP_KEY = "user-domain-repo-pool";
    public static final String USER_DOMAIN_POOL_CLASS_PROP_VAL = "tigase.db.UserRepositoryMDImpl";
    public static final String USER_REPO_CLASS_PROP_KEY = "user-repo-class";
    public static final String USER_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.JDBCRepository";
    public static final String USER_REPO_DOMAINS_PROP_KEY = "user-repo-domains";
    public static final String USER_REPO_PARAMS_NODE = "user-repo-params";
    public static final String USER_REPO_POOL_CLASS = "--user-repo-pool";
    public static final String USER_REPO_POOL_CLASS_PROP_DEF = "tigase.db.UserRepositoryPool";
    public static final String USER_REPO_POOL_CLASS_PROP_KEY = "user-repo-pool";
    public static final String USER_REPO_POOL_CLASS_PROP_VAL = null;
    public static final String USER_REPO_POOL_SIZE = "--user-repo-pool-size";
    public static final String USER_REPO_POOL_SIZE_PROP_KEY = "user-repo-pool-size";
    public static final String USER_REPO_URL_PROP_KEY = "user-repo-url";
    public static final String DERBY_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.JDBCRepository";
    public static final String DERBY_REPO_URL_PROP_VAL = "jdbc:derby:tigase-derbydb;create=true";
    public static final String DRUPALWP_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.DrupalWPAuth";
    public static final String DRUPAL_REPO_URL_PROP_VAL = "jdbc:mysql://localhost/drupal?user=root&password=mypass";
    public static final String DUMMY_REPO_CLASS_PROP_VAL = "tigase.db.DummyRepository";
    public static final String LIBRESOURCE_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.LibreSourceAuth";
    public static final String LIBRESOURCE_REPO_URL_PROP_VAL = "jdbc:postgresql://localhost/libresource?user=demo";
    public static final String MYSQL_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.JDBCRepository";
    public static final String MYSQL_REPO_URL_PROP_VAL = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
    public static final String PGSQL_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.JDBCRepository";
    public static final String PGSQL_REPO_URL_PROP_VAL = "jdbc:postgresql://localhost/tigase?user=tigase";
    public static final String XML_REPO_CLASS_PROP_VAL = "tigase.db.xml.XMLRepository";
    public static final String XML_REPO_URL_PROP_VAL = "user-repository.xml";
    private static ConcurrentMap<String, UserRepository> user_repos = new ConcurrentHashMap<String, UserRepository>(5);
    private static ConcurrentMap<String, AuthRepository> auth_repos = new ConcurrentHashMap<String, AuthRepository>(5);
    private static ConcurrentMap<String, DataRepository> data_repos = new ConcurrentHashMap<String, DataRepository>(10);

    public static AuthRepository getAuthRepository(String class_name, String resource, Map<String, String> params) throws ClassNotFoundException, InstantiationException, IllegalAccessException, DBInitException {
        AuthRepository repo;
        String cls = class_name;
        if (cls == null) {
            cls = System.getProperty(AUTH_REPO_CLASS_PROP_KEY, "tigase.db.jdbc.TigaseCustomAuth");
        }
        if (params == null) {
            params = new LinkedHashMap<String, String>(10);
        }
        if ((repo = (AuthRepository)auth_repos.get((cls = RepositoryFactory.getRepoClass(cls)) + resource)) == null) {
            String repo_pool_cls = System.getProperty(AUTH_REPO_POOL_CLASS_PROP_KEY, AUTH_REPO_POOL_CLASS_PROP_VAL);
            int repo_pool_size = params.get(AUTH_REPO_POOL_SIZE_PROP_KEY) != null ? Integer.parseInt(params.get(AUTH_REPO_POOL_SIZE_PROP_KEY)) : Integer.getInteger(AUTH_REPO_POOL_SIZE_PROP_KEY, 10);
            params.put(DATA_REPO_POOL_SIZE_PROP_KEY, String.valueOf(repo_pool_size));
            if (repo_pool_cls != null) {
                AuthRepositoryPool repo_pool = (AuthRepositoryPool)Class.forName(repo_pool_cls).newInstance();
                repo_pool.initRepository(resource, params);
                for (int i = 0; i < repo_pool_size; ++i) {
                    repo = (AuthRepository)Class.forName(cls).newInstance();
                    repo.initRepository(resource, params);
                    repo_pool.addRepo(repo);
                }
                repo = repo_pool;
            } else {
                repo = (AuthRepository)Class.forName(cls).newInstance();
                repo.initRepository(resource, params);
            }
            auth_repos.put(cls + resource, repo);
        }
        return repo;
    }

    public static DataRepository getDataRepository(String class_name, String resource, Map<String, String> params) throws ClassNotFoundException, InstantiationException, IllegalAccessException, DBInitException, SQLException {
        DataRepository repo;
        String cls = class_name;
        if (cls == null) {
            cls = System.getProperty(DATA_REPO_CLASS_PROP_KEY, DATA_REPO_CLASS_PROP_VAL);
        }
        if (params == null) {
            params = new LinkedHashMap<String, String>(10);
        }
        if ((repo = (DataRepository)data_repos.get(cls + resource)) == null) {
            int repo_pool_size = params.get(DATA_REPO_POOL_SIZE_PROP_KEY) != null ? Integer.parseInt(params.get(DATA_REPO_POOL_SIZE_PROP_KEY)) : Integer.getInteger(DATA_REPO_POOL_SIZE_PROP_KEY, 10);
            DataRepositoryPool repo_pool = (DataRepositoryPool)Class.forName(System.getProperty(DATA_REPO_POOL_CLASS_PROP_KEY, DATA_REPO_POOL_CLASS_PROP_VAL)).newInstance();
            repo_pool.initRepository(resource, params);
            for (int i = 0; i < repo_pool_size; ++i) {
                repo = (DataRepository)Class.forName(cls).newInstance();
                repo.initRepository(resource, params);
                repo_pool.addRepo(repo);
            }
            repo = repo_pool;
            data_repos.put(cls + resource, repo);
        }
        return repo;
    }

    public static String getRepoClass(String repo_name) {
        String result = repo_name;
        if (repo_name.equals("mysql")) {
            result = "tigase.db.jdbc.JDBCRepository";
        }
        if (repo_name.equals("pgsql")) {
            result = "tigase.db.jdbc.JDBCRepository";
        }
        if (repo_name.equals("derby")) {
            result = "tigase.db.jdbc.JDBCRepository";
        }
        if (repo_name.equals("tigase-custom-auth") || repo_name.equals("tigase-custom") || repo_name.equals("custom-auth")) {
            result = "tigase.db.jdbc.TigaseCustomAuth";
        }
        if (repo_name.equals("tigase-auth")) {
            result = TIGASE_AUTH_REPO_CLASS_PROP_VAL;
        }
        if (repo_name.equals("drupal") || repo_name.equals("wp")) {
            result = DRUPALWP_REPO_CLASS_PROP_VAL;
        }
        if (repo_name.equals("libresource")) {
            result = LIBRESOURCE_REPO_CLASS_PROP_VAL;
        }
        return result;
    }

    public static UserRepository getUserRepository(String class_name, String resource, Map<String, String> params) throws ClassNotFoundException, InstantiationException, IllegalAccessException, DBInitException {
        UserRepository repo;
        String cls = class_name;
        if (cls == null) {
            cls = System.getProperty(USER_REPO_CLASS_PROP_KEY, "tigase.db.jdbc.JDBCRepository");
        }
        if (params == null) {
            params = new LinkedHashMap<String, String>(10);
        }
        if ((repo = (UserRepository)user_repos.get((cls = RepositoryFactory.getRepoClass(cls)) + resource)) == null) {
            String repo_pool_cls = System.getProperty(USER_REPO_POOL_CLASS_PROP_KEY, USER_REPO_POOL_CLASS_PROP_VAL);
            int repo_pool_size = params.get(USER_REPO_POOL_SIZE_PROP_KEY) != null ? Integer.parseInt(params.get(USER_REPO_POOL_SIZE_PROP_KEY)) : Integer.getInteger(USER_REPO_POOL_SIZE_PROP_KEY, 10);
            params.put(DATA_REPO_POOL_SIZE_PROP_KEY, String.valueOf(repo_pool_size));
            if (repo_pool_cls != null) {
                UserRepositoryPool repo_pool = (UserRepositoryPool)Class.forName(repo_pool_cls).newInstance();
                repo_pool.initRepository(resource, params);
                for (int i = 0; i < repo_pool_size; ++i) {
                    repo = (UserRepository)Class.forName(cls).newInstance();
                    repo.initRepository(resource, params);
                    repo_pool.addRepo(repo);
                }
                repo = repo_pool;
            } else {
                repo = (UserRepository)Class.forName(cls).newInstance();
                repo.initRepository(resource, params);
            }
            user_repos.put(cls + resource, repo);
        }
        return repo;
    }
}

