/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class SessionBind
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final String SESSION_KEY = "Session-Set";
    private static final String XMLNS = "urn:ietf:params:xml:ns:xmpp-session";
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.SessionBind");
    private static final String ID = "urn:ietf:params:xml:ns:xmpp-session";
    private static final String[] ELEMENTS = new String[]{"session"};
    private static final String[] XMLNSS = new String[]{"urn:ietf:params:xml:ns:xmpp-session"};
    private static final Element[] FEATURES = new Element[]{new Element("session", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-session"})};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:ietf:params:xml:ns:xmpp-session"})};
    private static int resGenerator = 0;

    @Override
    public String id() {
        return "urn:ietf:params:xml:ns:xmpp-session";
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        if (!session.isAuthorized()) {
            results.offer(session.getAuthState().getResponseMessage(packet, "Session is not yet authorized.", false));
            return;
        }
        StanzaType type = packet.getType();
        switch (type) {
            case set: {
                session.putSessionData(SESSION_KEY, "true");
                results.offer(packet.okResult((String)null, 0));
                break;
            }
            default: {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Session type is incorrect", false));
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session != null && session.getSessionData(SESSION_KEY) == null && session.isAuthorized()) {
            return FEATURES;
        }
        return null;
    }
}

