/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.stats.StatisticsList;
import tigase.sys.TigaseRuntime;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.DynamicRoster;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterElementIfc;
import tigase.xmpp.impl.roster.RosterFactory;

public class Presence
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPStopListenerIfc {
    public static final String DIRECT_PRESENCE = "direct-presences";
    public static final String PRESENCE_ELEMENT_NAME = "presence";
    public static final String SKIP_OFFLINE_PROP_KEY = "skip-offline";
    public static final String OFFLINE_ROSTER_LAST_SEEN_PROP_KEY = "offline-roster-last-seen";
    public static final String PRESENCE_GLOBAL_FORWARD = "presence-global-forward";
    protected static final String XMLNS = "jabber:client";
    public static final String USERS_STATUS_CHANGES = "Users status changes";
    private static final Logger log = Logger.getLogger(Presence.class.getName());
    private static final String[] XMLNSS = new String[]{"jabber:client"};
    private static final String[] ELEMENTS = new String[]{"presence"};
    private static final String ID = "presence";
    private static final long MAX_DIRECT_PRESENCES_NO = 1000L;
    private static long requiredNo = 0L;
    private static long requiredYes = 0L;
    private static TigaseRuntime runtime = TigaseRuntime.getTigaseRuntime();
    public static final String OFFLINE_RES_SENT = "offline-res-sent";
    public static final String OFFLINE_BUD_SENT = "offline-bud-sent";
    private static boolean skipOffline = false;
    private static int HIGH_PRIORITY_PRESENCES_NO = 10;
    protected RosterAbstract roster_util = this.getRosterUtil();
    private long usersStatusChanges = 0L;
    private String[] offlineRosterLastSeen = null;
    private JID presenceGLobalForward = null;

    public static void addDirectPresenceJID(JID jid, XMPPResourceConnection session) {
        LinkedHashSet<JID> direct_presences = (LinkedHashSet<JID>)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences == null) {
            direct_presences = new LinkedHashSet<JID>(10);
            session.putSessionData(DIRECT_PRESENCE, direct_presences);
        }
        if ((long)direct_presences.size() < 1000L) {
            direct_presences.add(jid);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Added direct presence jid: {0}", jid);
        }
    }

    public static void broadcastOffline(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract roster_util) throws NotAuthorizedException, TigaseDBException {
        if (session.getSessionData(OFFLINE_BUD_SENT) != null) {
            return;
        }
        session.putSessionData(OFFLINE_BUD_SENT, OFFLINE_BUD_SENT);
        Element pres = session.getPresence();
        if (pres != null) {
            Presence.sendPresenceBroadcast(StanzaType.unavailable, session, RosterAbstract.FROM_SUBSCRIBED, results, pres, settings, roster_util);
        } else {
            Presence.broadcastDirectPresences(StanzaType.unavailable, session, results, pres);
        }
    }

    public static void removeDirectPresenceJID(JID jid, XMPPResourceConnection session) {
        Set direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences != null) {
            direct_presences.remove(jid);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Added direct presence jid: {0}", jid);
        }
    }

    public static void sendPresence(StanzaType t, BareJID from, BareJID to, Queue<Packet> results, Element pres) {
        Presence.sendPresence(t, JID.jidInstance((BareJID)from), JID.jidInstance((BareJID)to), results, pres);
    }

    public static Packet sendPresence(StanzaType t, JID from, JID to, Queue<Packet> results, Element pres) {
        Element presence = null;
        Packet result = null;
        if (pres == null) {
            presence = new Element("presence");
            if (t != null) {
                presence.setAttribute("type", t.toString());
            } else {
                presence.setAttribute("type", StanzaType.unavailable.toString());
            }
            presence.setAttribute("from", from.toString());
            presence.setXMLNS(XMLNS);
        } else {
            presence = pres.clone();
        }
        presence.setAttribute("to", to.toString());
        try {
            result = Packet.packetInstance(presence);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Sending presence info: {0}", result);
            }
            results.offer(result);
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.FINE, "Packet stringprep addressing problem, skipping presence send: {0}", presence);
        }
        return result;
    }

    public static void sendPresenceBroadcast(StanzaType t, XMPPResourceConnection session, EnumSet<RosterAbstract.SubscriptionType> subscrs, Queue<Packet> results, Element pres, Map<String, Object> settings, RosterAbstract roster_util) throws NotAuthorizedException, TigaseDBException {
        Presence.broadcastDirectPresences(t, session, results, pres);
        RosterAbstract roster = roster_util;
        if (roster == null) {
            roster = RosterFactory.getRosterImplementation(true);
        }
        Object[] buddies = roster.getBuddies(session, subscrs);
        if ((buddies = DynamicRoster.addBuddies(session, settings, (JID[])buddies)) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Buddies found: " + Arrays.toString(buddies));
            }
            Priority pack_priority = Priority.PRESENCE;
            int pres_cnt = 0;
            for (Object buddy : buddies) {
                if (Presence.requiresPresenceSending(roster, (JID)buddy, session)) {
                    Packet pack = Presence.sendPresence(t, session.getJID(), (JID)buddy, results, pres);
                    if (pres_cnt == HIGH_PRIORITY_PRESENCES_NO) {
                        ++pres_cnt;
                        pack_priority = Priority.LOWEST;
                    }
                    if (pack == null) continue;
                    pack.setPriority(pack_priority);
                    roster.setPresenceSent(session, (JID)buddy, true);
                    continue;
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "Not sending presence to buddy: " + buddy);
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "No buddies found!!!!");
        }
    }

    public static void updatePresenceChange(Packet presence, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        boolean initial_p = presence.getAttribute("type") == null || "available".equals(presence.getAttribute("type")) || "unavailable".equals(presence.getAttribute("type"));
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            if (conn.getPresence() == null && initial_p) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("Skipping update presence change for a resource which hasn't sent initial presence yet, or is remote connection: " + conn);
                continue;
            }
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Update presence change to: " + conn);
                }
                Packet pres_update = presence.copyElementOnly();
                pres_update.initVars(presence.getStanzaFrom(), conn.getJID().copyWithoutResource());
                pres_update.setPacketTo(conn.getConnectionId());
                results.offer(pres_update);
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.id(), USERS_STATUS_CHANGES, this.usersStatusChanges, Level.INFO);
    }

    public static void updateUserResources(Element presence, XMPPResourceConnection session, Queue<Packet> results, boolean initial) throws NotAuthorizedException {
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Update presence change to: {0}", conn.getJID());
                }
                if (conn.isResourceSet()) {
                    Element pres_update = presence.clone();
                    Packet pack_update = Packet.packetInstance(pres_update, session.getJID(), conn.getJID().copyWithoutResource());
                    pack_update.setPacketTo(conn.getConnectionId());
                    results.offer(pack_update);
                    Element presence_el = conn.getPresence();
                    if (presence_el == null || !initial || conn == session) continue;
                    pres_update = presence_el.clone();
                    pack_update = Packet.packetInstance(pres_update, conn.getJID(), session.getJID().copyWithoutResource());
                    pack_update.setPacketTo(session.getConnectionId());
                    results.offer(pack_update);
                    continue;
                }
                if (!log.isLoggable(Level.FINER)) continue;
                log.finer("Skipping presence update to: " + conn.getJID());
            }
            catch (Exception e) {}
        }
    }

    protected static void broadcastDirectPresences(StanzaType t, XMPPResourceConnection session, Queue<Packet> results, Element pres) throws NotAuthorizedException, TigaseDBException {
        Set direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences != null && t != null && t == StanzaType.unavailable) {
            for (JID buddy : direct_presences) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Updating direct presence for: {0}", buddy);
                }
                Packet pack = Presence.sendPresence(t, session.getJID(), buddy, results, pres);
                pack.setPriority(Priority.LOW);
            }
        }
    }

    protected static void forwardPresence(Queue<Packet> results, Packet packet, JID from) {
        Element result = packet.getElement().clone();
        result.setAttribute("from", from.toString());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "\n\nFORWARD presence: {0}", result.toString());
        }
        results.offer(Packet.packetInstance(result, from, packet.getStanzaTo()));
    }

    protected static void updateOfflineChange(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        if (session.getSessionData(OFFLINE_RES_SENT) != null) {
            return;
        }
        session.putSessionData(OFFLINE_RES_SENT, OFFLINE_RES_SENT);
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Update presence change to: {0}", conn.getJID());
                }
                if (conn != session && conn.isResourceSet() && !conn.getResource().equals(session.getResource())) {
                    Element pres_update = new Element("presence");
                    pres_update.setAttribute("type", StanzaType.unavailable.toString());
                    pres_update.setXMLNS(XMLNS);
                    Packet pack_update = Packet.packetInstance(pres_update, session.getJID(), conn.getJID().copyWithoutResource());
                    pack_update.setPacketTo(conn.getConnectionId());
                    results.offer(pack_update);
                    continue;
                }
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, "Skipping presence update to: {0}", conn.getJID());
            }
            catch (Exception e) {}
        }
    }

    private static boolean requiresPresenceSending(RosterAbstract roster, JID buddy, XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        boolean result = true;
        if (skipOffline && !roster.isOnline(session, buddy)) {
            result = false;
        }
        return result;
    }

    public void broadcastProbe(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException {
        JID[] buddies_from;
        JID[] buddies_to;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Broadcasting probes for: {0}", session);
        }
        Element presInit = session.getPresence();
        Element presProbe = new Element("presence");
        presProbe.setXMLNS(XMLNS);
        presProbe.setAttribute("type", StanzaType.probe.toString());
        presProbe.setAttribute("from", session.getBareJID().toString());
        JID[] buddies = this.roster_util.getBuddies(session, RosterAbstract.SUB_BOTH);
        buddies = DynamicRoster.addBuddies(session, settings, buddies);
        if (buddies != null) {
            for (JID buddy : buddies) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Sending probe to: {0}", buddy);
                }
                Presence.sendPresence(null, null, buddy, results, presProbe);
                if (!Presence.requiresPresenceSending(this.roster_util, buddy, session)) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Sending intial to: {0}", buddy);
                }
                Presence.sendPresence(null, null, buddy, results, presInit);
                this.roster_util.setPresenceSent(session, buddy, true);
            }
        }
        if ((buddies_to = this.roster_util.getBuddies(session, RosterAbstract.SUB_TO)) != null) {
            for (JID buddy : buddies_to) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Sending probe to: {0}", buddy);
                }
                Presence.sendPresence(null, null, buddy, results, presProbe);
            }
        }
        if ((buddies_from = this.roster_util.getBuddies(session, RosterAbstract.SUB_FROM)) != null) {
            for (JID buddy : buddies_from) {
                if (!Presence.requiresPresenceSending(this.roster_util, buddy, session)) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Sending initial to: {0}", buddy);
                }
                Presence.sendPresence(null, null, buddy, results, presInit);
                this.roster_util.setPresenceSent(session, buddy, true);
            }
        }
    }

    @Override
    public int concurrentQueuesNo() {
        return Runtime.getRuntime().availableProcessors() * 2;
    }

    @Override
    public String id() {
        return "presence";
    }

    @Override
    public void init(Map<String, Object> settings) throws TigaseDBException {
        skipOffline = Boolean.parseBoolean((String)settings.get(SKIP_OFFLINE_PROP_KEY));
        String tmp = (String)settings.get(OFFLINE_ROSTER_LAST_SEEN_PROP_KEY);
        if (tmp != null) {
            this.offlineRosterLastSeen = tmp.split(",");
            log.config("Loaded roster offline last seen config: " + tmp);
        } else {
            log.config("No configuration found for Loaded roster offline last seen.");
        }
        tmp = (String)settings.get(PRESENCE_GLOBAL_FORWARD);
        if (tmp != null) {
            try {
                this.presenceGLobalForward = JID.jidInstance((String)tmp);
            }
            catch (TigaseStringprepException ex) {
                this.presenceGLobalForward = null;
                log.warning("Presence global forward misconfiguration, cannot parse JID " + tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Session is null, ignoring packet: {0}", packet);
            }
            return;
        }
        if (!session.isAuthorized()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Session is not authorized, ignoring packet: {0}", packet);
            }
            return;
        }
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            try {
                RosterAbstract.PresenceType pres_type = this.roster_util.getPresenceType(session, packet);
                if (pres_type == null) {
                    log.log(Level.INFO, "Invalid presence found: {0}", packet);
                    return;
                }
                StanzaType type = packet.getType();
                if (type == null) {
                    type = StanzaType.available;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0} presence found: {1}", new Object[]{pres_type, packet});
                }
                switch (pres_type) {
                    case in_unsubscribe: 
                    case in_subscribe: 
                    case in_unsubscribed: 
                    case in_subscribed: {
                        if (packet.getStanzaFrom() == null) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("'in' subscription presence without valid 'from' address, dropping packet: " + packet);
                            }
                            return;
                        }
                        if (!session.isUserId(packet.getStanzaFrom().getBareJID())) break;
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "''in'' subscription to myself, not allowed, returning error for packet: {0}", packet);
                        }
                        results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "You can not subscribe to yourself.", false));
                        return;
                    }
                    case out_subscribe: 
                    case out_unsubscribe: 
                    case out_subscribed: 
                    case out_unsubscribed: {
                        if (packet.getStanzaTo() == null || packet.getStanzaTo().toString().isEmpty()) {
                            results.offer(Authorization.JID_MALFORMED.getResponseMessage(packet, "The destination address is incorrect.", false));
                            return;
                        }
                        packet.initVars(session.getJID().copyWithoutResource(), packet.getStanzaTo().copyWithoutResource());
                        break;
                    }
                }
                switch (pres_type) {
                    case out_initial: {
                        this.processOutInitial(packet, session, results, settings, pres_type);
                        break;
                    }
                    case out_subscribe: 
                    case out_unsubscribe: {
                        this.processOutSubscribe(packet, session, results, settings, pres_type);
                        break;
                    }
                    case out_subscribed: 
                    case out_unsubscribed: {
                        this.processOutSubscribed(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_initial: {
                        String resource = packet.getStanzaTo().getResource();
                        if (session.getPresence() == null && (resource == null || resource.isEmpty())) {
                            return;
                        }
                        if (type == StanzaType.unavailable) {
                            this.roster_util.setOnline(session, packet.getStanzaFrom(), false);
                        } else {
                            this.buddyOnline(session, packet.getStanzaFrom(), results);
                        }
                        this.processInInitial(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_subscribe: {
                        this.processInSubscribe(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_unsubscribe: {
                        this.processInUnsubscribe(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_subscribed: {
                        this.processInSubscribed(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_unsubscribed: {
                        this.processInUnsubscribed(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_probe: {
                        if (session.getPresence() == null) {
                            return;
                        }
                        this.processInProbe(packet, session, results, settings, pres_type);
                        break;
                    }
                    case error: {
                        this.processError(packet, session, results, settings, pres_type);
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                        break;
                    }
                }
            }
            catch (NotAuthorizedException e) {
                log.log(Level.INFO, "Can not access user Roster, user session is not authorized yet: {0}", packet);
                log.log(Level.FINEST, "presence problem...", e);
            }
            catch (TigaseDBException e) {
                log.log(Level.WARNING, "Error accessing database for presence data: {0}", e);
            }
        }
    }

    public void resendPendingInRequests(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException {
        JID[] buddies = this.roster_util.getBuddies(session, RosterAbstract.PENDING_IN);
        if (buddies != null) {
            for (JID buddy : buddies) {
                Element presence = new Element("presence");
                presence.setAttribute("type", StanzaType.subscribe.toString());
                presence.setXMLNS(XMLNS);
                Packet pres = Packet.packetInstance(presence, buddy, null);
                Presence.updatePresenceChange(pres, session, results);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            try {
                if (session.getPresence() != null) {
                    Element pres = session.getPresence();
                    if (!StanzaType.unavailable.toString().equals(pres.getAttribute("type"))) {
                        pres.setAttribute("type", StanzaType.unavailable.toString());
                        session.setPresence(pres);
                    }
                    Presence.broadcastOffline(session, results, settings, this.roster_util);
                    Presence.updateOfflineChange(session, results);
                } else {
                    Presence.broadcastDirectPresences(StanzaType.unavailable, session, results, null);
                }
                this.roster_util.logout(session);
            }
            catch (NotAuthorizedException e) {
            }
            catch (TigaseDBException e) {
                log.log(Level.WARNING, "Error accessing database for offline message: ", e);
            }
        }
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    protected RosterAbstract getRosterUtil() {
        return RosterFactory.getRosterImplementation(true);
    }

    protected void processError(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType presenceType) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException {
        if (session.isUserId(packet.getStanzaTo().getBareJID())) {
            Packet result = packet.copyElementOnly();
            result.setPacketTo(session.getConnectionId());
            result.setPacketFrom(packet.getTo());
            results.offer(result);
        }
    }

    protected void processInInitial(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType presenceType) throws NoConnectionIdException, NotAuthorizedException, TigaseDBException {
        if (packet.getStanzaFrom() == null) {
            log.log(Level.WARNING, "Initial presence without from attribute set: {0}", packet);
            return;
        }
        String resource = packet.getStanzaTo().getResource();
        if (resource != null && !resource.isEmpty()) {
            XMPPResourceConnection direct = session.getParentSession().getResourceForResource(resource);
            if (direct != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Received direct presence from: {0} to: {1}", new Object[]{packet.getStanzaFrom(), packet.getStanzaTo()});
                }
                Packet result = packet.copyElementOnly();
                result.setPacketTo(direct.getConnectionId());
                result.setPacketFrom(packet.getTo());
                results.offer(result);
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Ignoring direct presence from: {0} to: {1}, resource gone.", new Object[]{packet.getStanzaFrom(), packet.getStanzaTo()});
            }
            return;
        }
        if (session.getPresence() == null) {
            return;
        }
        JID presBuddy = packet.getStanzaFrom().copyWithoutResource();
        if (this.roster_util.isSubscribedTo(session, presBuddy) || DynamicRoster.getBuddyItem(session, settings, presBuddy) != null) {
            RosterElementIfc rel;
            boolean online;
            boolean bl = online = StanzaType.unavailable != packet.getType();
            if (online && (rel = this.roster_util.getRosterElement(session, presBuddy)) != null && rel instanceof RosterElement) {
                ((RosterElement)rel).setLastSeen(System.currentTimeMillis());
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received initial presence, setting buddy: {0} online status to: {1}", new Object[]{packet.getStanzaFrom(), online});
            }
            this.roster_util.setOnline(session, packet.getStanzaFrom(), online);
            Presence.updatePresenceChange(packet, session, results);
            if (skipOffline && !this.roster_util.presenceSent(session, packet.getStanzaFrom())) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Presence not yet sent to this buddy, sending: {0}", new Object[]{packet.getStanzaFrom()});
                }
                Presence.sendPresence(null, null, packet.getStanzaFrom().copyWithoutResource(), results, session.getPresence());
                this.roster_util.setPresenceSent(session, packet.getStanzaFrom(), true);
            }
        }
    }

    protected void processInProbe(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType presenceType) throws NotAuthorizedException, TigaseDBException, PacketErrorTypeException {
        RosterAbstract.SubscriptionType buddy_subscr = null;
        buddy_subscr = DynamicRoster.getBuddyItem(session, settings, packet.getStanzaFrom()) != null ? RosterAbstract.SubscriptionType.both : this.roster_util.getBuddySubscription(session, packet.getStanzaFrom());
        if (buddy_subscr == null) {
            buddy_subscr = RosterAbstract.SubscriptionType.none;
        }
        if (this.roster_util.isSubscribedFrom(buddy_subscr)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received probe, setting buddy: {0} as online.", packet.getStanzaFrom());
            }
            this.roster_util.setOnline(session, packet.getStanzaFrom(), true);
            for (XMPPResourceConnection conn : session.getActiveSessions()) {
                try {
                    Element pres = conn.getPresence();
                    if (pres == null) continue;
                    Presence.sendPresence(null, null, packet.getStanzaFrom().copyWithoutResource(), results, pres);
                    this.roster_util.setPresenceSent(session, packet.getStanzaFrom(), true);
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "Received probe, sending presence response to: {0}", packet.getStanzaFrom());
                }
                catch (Exception e) {}
            }
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received probe, users bare JID: {0} is not in the roster. Responding with unsubscribed", packet.getStanzaFrom().getBareJID());
            }
            Presence.sendPresence(StanzaType.unsubscribed, session.getBareJID(), packet.getStanzaFrom().getBareJID(), results, null);
        }
    }

    protected void processInSubscribe(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException {
        if (this.roster_util.isSubscribedFrom(session, packet.getStanzaFrom())) {
            Presence.sendPresence(StanzaType.subscribed, session.getJID().copyWithoutResource(), packet.getStanzaFrom(), results, null);
        } else {
            RosterAbstract.SubscriptionType curr_sub = this.roster_util.getBuddySubscription(session, packet.getStanzaFrom());
            if (curr_sub == null) {
                curr_sub = RosterAbstract.SubscriptionType.none;
                this.roster_util.addBuddy(session, packet.getStanzaFrom(), null, null, null);
            }
            this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom());
            Presence.updatePresenceChange(packet, session, results);
        }
    }

    protected void processInSubscribed(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException {
        boolean subscr_changed;
        RosterAbstract.SubscriptionType curr_sub = this.roster_util.getBuddySubscription(session, packet.getStanzaFrom());
        if (curr_sub == null) {
            curr_sub = RosterAbstract.SubscriptionType.none;
            this.roster_util.addBuddy(session, packet.getStanzaFrom(), null, null, null);
        }
        if (subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom())) {
            Packet forward_p = packet.copyElementOnly();
            forward_p.setPacketTo(session.getConnectionId());
            results.offer(forward_p);
            this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, packet.getStanzaFrom()));
        }
    }

    protected void processInUnsubscribe(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException {
        boolean subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom());
        if (subscr_changed) {
            Packet forward_p = packet.copyElementOnly();
            forward_p.setPacketTo(session.getConnectionId());
            results.offer(forward_p);
            Element item = this.roster_util.getBuddyItem(session, packet.getStanzaFrom());
            if (item != null) {
                this.roster_util.updateBuddyChange(session, results, item);
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received unsubscribe request from a user who is not in the roster: {0}", packet.getStanzaFrom());
            }
        }
    }

    protected void processInUnsubscribed(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException {
        RosterAbstract.SubscriptionType curr_sub = this.roster_util.getBuddySubscription(session, packet.getStanzaFrom());
        if (curr_sub != null) {
            Packet forward_p = packet.copyElementOnly();
            forward_p.setPacketTo(session.getConnectionId());
            results.offer(forward_p);
            boolean subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom());
            if (subscr_changed) {
                Element item = this.roster_util.getBuddyItem(session, packet.getStanzaFrom());
                if (item != null) {
                    this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, packet.getStanzaFrom()));
                } else if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Received unsubscribe request from a user who is not in the roster: {0}", packet.getStanzaFrom());
                }
            }
        }
    }

    protected void sendRosterOfflinePresence(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException {
        if (this.offlineRosterLastSeen == null) {
            log.finest("No clients specified in config, skipping...");
            return;
        }
        Element pres = session.getPresence();
        if (pres == null) {
            log.finest("Presence not set yet, skipping...");
            return;
        }
        String node = pres.getAttribute("/presence/c", "node");
        if (node == null) {
            log.finest("Presence node not set, skipping...");
            return;
        }
        boolean validClient = false;
        int i = 0;
        while (!(validClient |= node.contains(this.offlineRosterLastSeen[i++]))) {
        }
        if (!validClient) {
            log.finest("Client does not match, skipping...");
            return;
        }
        Object[] buddies = this.roster_util.getBuddies(session, RosterAbstract.TO_SUBSCRIBED);
        if (buddies != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Buddies found: " + Arrays.toString(buddies));
            }
            Priority pack_priority = Priority.PRESENCE;
            int pres_cnt = 0;
            for (Object buddy : buddies) {
                String status = this.roster_util.getCustomStatus(session, (JID)buddy);
                if (status == null) continue;
                Packet pack = Presence.sendPresence(StanzaType.unavailable, (JID)buddy, session.getJID(), results, null);
                if (pres_cnt == HIGH_PRIORITY_PRESENCES_NO) {
                    ++pres_cnt;
                    pack_priority = Priority.LOWEST;
                }
                pack.setPriority(pack_priority);
                pack.setPacketTo(session.getConnectionId());
                pack.getElement().addChild((XMLNodeIfc)new Element("status", status));
            }
        }
    }

    protected void processOutInitial(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType type) throws NotAuthorizedException, TigaseDBException {
        if (packet.getStanzaTo() != null) {
            results.offer(packet.copyElementOnly());
            if (packet.getType() == StanzaType.unavailable) {
                Presence.removeDirectPresenceJID(packet.getStanzaTo(), session);
            } else {
                Presence.addDirectPresenceJID(packet.getStanzaTo(), session);
            }
        } else {
            ++this.usersStatusChanges;
            boolean first = false;
            if (session.getPresence() == null) {
                first = true;
            }
            packet.initVars(session.getJID(), packet.getStanzaTo());
            session.setPresence(packet.getElement());
            if (packet.getType() == null || packet.getType() == StanzaType.available) {
                session.removeSessionData(OFFLINE_BUD_SENT);
                session.removeSessionData(OFFLINE_RES_SENT);
                if (first) {
                    try {
                        this.sendRosterOfflinePresence(session, results);
                    }
                    catch (Exception ex) {
                        log.log(Level.INFO, "Experimental code throws exception: ", ex);
                    }
                    this.broadcastProbe(session, results, settings);
                    this.resendPendingInRequests(session, results);
                } else {
                    Presence.sendPresenceBroadcast(StanzaType.available, session, RosterAbstract.FROM_SUBSCRIBED, results, packet.getElement(), settings, this.roster_util);
                }
                Presence.updateUserResources(packet.getElement(), session, results, first);
            } else {
                this.stopped(session, results, settings);
            }
            JID forwardTo = session.getDomain().getPresenceForward();
            if (forwardTo == null) {
                forwardTo = this.presenceGLobalForward;
            }
            if (forwardTo != null) {
                Presence.sendPresence(null, session.getJID(), forwardTo, results, packet.getElement());
            }
        }
    }

    protected void processOutSubscribe(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException {
        boolean subscr_changed = false;
        Presence.forwardPresence(results, packet, session.getJID().copyWithoutResource());
        RosterAbstract.SubscriptionType current_subscription = this.roster_util.getBuddySubscription(session, packet.getStanzaTo());
        if (pres_type == RosterAbstract.PresenceType.out_subscribe) {
            if (current_subscription == null) {
                this.roster_util.addBuddy(session, packet.getStanzaTo(), null, null, null);
            }
            if (subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaTo())) {
                this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, packet.getStanzaTo()));
            }
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "out_subscribe: current_subscription = " + (Object)((Object)current_subscription));
            }
            if (current_subscription != null) {
                subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaTo());
                current_subscription = this.roster_util.getBuddySubscription(session, packet.getStanzaTo());
                if (subscr_changed) {
                    this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, packet.getStanzaTo()));
                }
                if (RosterAbstract.SUB_NONE.contains((Object)current_subscription)) {
                    this.roster_util.removeBuddy(session, packet.getStanzaTo());
                }
            }
        }
    }

    protected void processOutSubscribed(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType pres_type) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException {
        Presence.forwardPresence(results, packet, session.getJID().copyWithoutResource());
        Element initial_presence = session.getPresence();
        JID buddy = packet.getStanzaTo().copyWithoutResource();
        boolean subscr_changed = this.roster_util.updateBuddySubscription(session, pres_type, buddy);
        if (subscr_changed) {
            this.roster_util.updateBuddyChange(session, results, this.roster_util.getBuddyItem(session, buddy));
            if (initial_presence != null) {
                if (pres_type == RosterAbstract.PresenceType.out_subscribed) {
                    List<XMPPResourceConnection> activeSessions = session.getActiveSessions();
                    for (XMPPResourceConnection userSessions : activeSessions) {
                        Element presence = userSessions.getPresence();
                        Presence.sendPresence(StanzaType.available, userSessions.getjid(), buddy, results, presence);
                    }
                    this.roster_util.setPresenceSent(session, buddy, true);
                } else {
                    Presence.sendPresence(StanzaType.unavailable, session.getJID(), buddy, results, null);
                }
            }
        }
    }

    protected void buddyOnline(XMPPResourceConnection session, JID buddy, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException {
        Element pres;
        this.roster_util.setOnline(session, buddy, true);
        if (skipOffline && !this.roster_util.presenceSent(session, buddy) && this.roster_util.isSubscribedFrom(session, buddy) && (pres = session.getPresence()) != null) {
            Presence.sendPresence(null, null, buddy, results, pres);
            this.roster_util.setPresenceSent(session, buddy, true);
        }
    }
}

