/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPResourceConnection;

public class DomainFilter
extends XMPPProcessor
implements XMPPPacketFilterIfc,
XMPPPreprocessorIfc {
    private static final Logger log = Logger.getLogger(DomainFilter.class.getName());
    public static final String ALLOWED_DOMAINS_LIST_KEY = "allowed-domains-list";
    public static final String ALLOWED_DOMAINS_KEY = "allowed-domains";
    private static final String ID = "domain-filter";
    private static final String[] ELEMENTS = new String[]{"*"};
    private static final String[] XMLNSS = new String[]{"*"};

    @Override
    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session == null || results == null || results.size() == 0) {
            return;
        }
        try {
            DOMAINS domains = this.getDomains(session);
            if (domains == DOMAINS.ALL) {
                return;
            }
            ArrayDeque<Packet> errors = new ArrayDeque<Packet>(1);
            Iterator<Packet> it = results.iterator();
            while (it.hasNext()) {
                Packet res = (Packet)it.next();
                if (domains == DOMAINS.BLOCK) {
                    if (res.getType() == StanzaType.error || (res.getStanzaFrom() == null || session.isUserId(res.getStanzaFrom().getBareJID())) && (res.getStanzaTo() == null || session.isUserId(res.getStanzaTo().getBareJID()))) continue;
                    this.removePacket(it, res, errors, "Communication blocked.");
                    continue;
                }
                String outDomain = null;
                if (res.getStanzaTo() != null) {
                    outDomain = res.getStanzaTo().getDomain();
                }
                switch (domains) {
                    case LOCAL: {
                        if (outDomain == null || session.isLocalDomain(outDomain, true)) break;
                        this.removePacket(it, res, errors, "You can only communicate within the server local domains.");
                        break;
                    }
                    case OWN: {
                        if (outDomain == null || outDomain.equals(session.getDomain().getVhost().getDomain())) break;
                        this.removePacket(it, res, errors, "You can only communicate within your own domain.");
                        break;
                    }
                    case LIST: {
                        String[] allowedDomains = this.getDomainsList(session);
                        boolean found = false;
                        for (String domain : allowedDomains) {
                            if (domain != outDomain) continue;
                            found = true;
                            break;
                        }
                        if (found) break;
                        this.removePacket(it, res, errors, "You can only communicate within selected list of domains.");
                    }
                }
            }
            results.addAll(errors);
        }
        catch (NotAuthorizedException ex) {
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Can't access user repository.", ex);
        }
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing: {0}", packet);
        }
        boolean stop = false;
        if (session == null) {
            return stop;
        }
        if (session.isServerSession()) {
            return stop;
        }
        try {
            DOMAINS domains = this.getDomains(session);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "DOMAINS setting is: {0}", domains.name());
            }
            if (domains == DOMAINS.ALL) {
                return stop;
            }
            String outDomain = packet.getStanzaFrom() != null ? packet.getStanzaFrom().getDomain() : null;
            try {
                if (session.getConnectionId().equals((Object)packet.getPacketFrom())) {
                    outDomain = packet.getStanzaTo() != null ? packet.getStanzaTo().getDomain() : null;
                }
            }
            catch (NoConnectionIdException ex) {
                log.log(Level.WARNING, "No connection id for session, even though this is not a server session: {0}, request: {1}", new Object[]{session, packet});
            }
            switch (domains) {
                case BLOCK: {
                    if (packet.getType() == StanzaType.error || packet.getStanzaFrom() == null || session.isUserId(packet.getStanzaFrom().getBareJID()) && (packet.getStanzaTo() == null || session.isUserId(packet.getStanzaTo().getBareJID()))) {
                        return stop;
                    }
                    this.removePacket(null, packet, results, "Communication blocked.");
                    stop = true;
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.log(Level.FINEST, "BLOCK, blocking packet: {0}", packet);
                    break;
                }
                case LOCAL: {
                    if (outDomain != null && !session.isLocalDomain(outDomain, true)) {
                        this.removePacket(null, packet, results, "You can only communicate within the server local domains.");
                        stop = true;
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.log(Level.FINEST, "LOCAL Domains only, blocking packet: {0}", packet);
                        break;
                    }
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.log(Level.FINEST, "LOCAL Domains only, packet not blocked: {0}", packet);
                    break;
                }
                case OWN: {
                    if (outDomain != null && !outDomain.equals(session.getDomain().getVhost().getDomain())) {
                        this.removePacket(null, packet, results, "You can only communicate within your own domain.");
                        stop = true;
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.log(Level.FINEST, "OWN Domain only, blocking packet: {0}", packet);
                        break;
                    }
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.log(Level.FINEST, "OWN Domain only, packet not blocked: {0}", packet);
                    break;
                }
                case LIST: {
                    String[] allowedDomains = this.getDomainsList(session);
                    boolean found = false;
                    for (String domain : allowedDomains) {
                        if (domain != outDomain) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.removePacket(null, packet, results, "You can only communicate within selected list of domains.");
                        stop = true;
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.log(Level.FINEST, "LISTED Domains only, blocking packet: {0}", packet);
                        break;
                    }
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.log(Level.FINEST, "LISTED Domain only, packet not blocked: {0}", packet);
                }
            }
        }
        catch (NotAuthorizedException ex) {
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Can't access user repository.", ex);
        }
        return stop;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    public DOMAINS getDomains(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        DOMAINS domains = (DOMAINS)((Object)session.getCommonSessionData(ALLOWED_DOMAINS_KEY));
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "domains read from user session: {0}", (Object)domains);
        }
        if (domains == null) {
            String dbDomains = session.getData(null, ALLOWED_DOMAINS_KEY, null);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Domains read from database: {0}", dbDomains);
            }
            if ((domains = DOMAINS.valueof(dbDomains)) == null) {
                domains = session.isAnonymous() ? DOMAINS.LOCAL : DOMAINS.ALL;
            }
            session.putCommonSessionData(ALLOWED_DOMAINS_KEY, (Object)domains);
        }
        return domains;
    }

    public String[] getDomainsList(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        String[] allowedDomains = (String[])session.getCommonSessionData(ALLOWED_DOMAINS_LIST_KEY);
        if (allowedDomains == null) {
            String dbDomains = session.getData(null, ALLOWED_DOMAINS_KEY, null);
            allowedDomains = dbDomains.split(",");
            for (int i = 0; i < allowedDomains.length; ++i) {
                allowedDomains[i] = allowedDomains[i].intern();
            }
            session.putCommonSessionData(ALLOWED_DOMAINS_LIST_KEY, allowedDomains);
        }
        return allowedDomains;
    }

    private void removePacket(Iterator<Packet> it, Packet res, Queue<Packet> errors, String msg) {
        if (it != null) {
            it.remove();
        }
        try {
            errors.add(Authorization.FORBIDDEN.getResponseMessage(res, msg, true));
        }
        catch (PacketErrorTypeException ex) {
            log.log(Level.FINE, "Already error packet, dropping it..: {0}", res);
        }
    }

    public static enum DOMAINS {
        ALL,
        LOCAL,
        OWN,
        BLOCK,
        LIST;


        public static DOMAINS valueof(String domains) {
            if (domains == null) {
                return null;
            }
            try {
                return DOMAINS.valueOf(domains);
            }
            catch (Exception e) {
                return LIST;
            }
        }
    }
}

