/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.comp.RepositoryItemAbstract;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.JID;

public class VHostItem
extends RepositoryItemAbstract {
    private static final Logger log = Logger.getLogger(VHostItem.class.getName());
    public static final String VHOST_ELEM = "vhost";
    public static final String COMPONENTS_ELEM = "comps";
    public static final String OTHER_PARAMS_ELEM = "other";
    public static final String OTHER_PARAMS_LABEL = "Other parameters";
    public static final String HOSTNAME_ATT = "hostname";
    public static final String HOSTNAME_LABEL = "Domain name";
    public static final String ENABLED_ATT = "enabled";
    public static final String ENABLED_LABEL = "Enabled";
    public static final String ANONYMOUS_ENABLED_ATT = "anon";
    public static final String ANONYMOUS_ENABLED_LABEL = "Anonymous enabled";
    public static final String REGISTER_ENABLED_ATT = "register";
    public static final String REGISTER_ENABLED_LABEL = "In-band registration";
    public static final String MAX_USERS_NUMBER_ATT = "max-users";
    public static final String MAX_USERS_NUMBER_LABEL = "Max users";
    public static final String PRESENCE_FORWARD_ADDRESS_ATT = "pres-forw";
    public static final String PRESENCE_FORWARD_ADDRESS_LABEL = "Presence forward address";
    public static final String MESSAGE_FORWARD_ADDRESS_ATT = "mess-forw";
    public static final String MESSAGE_FORWARD_ADDRESS_LABEL = "Message forward address";
    private String[] comps = null;
    private long maxUsersNumber = 0L;
    private String otherDomainParams = null;
    private VHostItem unmodifiableItem = null;
    private JID vhost = null;
    private boolean registerEnabled = true;
    private boolean enabled = true;
    private boolean anonymousEnabled = true;
    private JID presenceForward = null;
    private JID messageForward = null;

    public VHostItem() {
    }

    public VHostItem(Element elem) {
        this.initFromElement(elem);
    }

    public VHostItem(JID vhost) {
        this.setVHost(vhost);
    }

    public VHostItem(String vhost) throws TigaseStringprepException {
        this.setVHost(vhost);
    }

    @Override
    public void addCommandFields(Packet packet) {
        Command.addFieldValue(packet, HOSTNAME_LABEL, this.vhost != null ? this.vhost.getDomain() : "");
        Command.addCheckBoxField(packet, ENABLED_LABEL, this.enabled);
        Command.addCheckBoxField(packet, ANONYMOUS_ENABLED_LABEL, this.anonymousEnabled);
        Command.addCheckBoxField(packet, REGISTER_ENABLED_LABEL, this.registerEnabled);
        Command.addFieldValue(packet, MAX_USERS_NUMBER_LABEL, "" + this.maxUsersNumber);
        Command.addFieldValue(packet, PRESENCE_FORWARD_ADDRESS_LABEL, this.presenceForward != null ? this.presenceForward.toString() : "");
        Command.addFieldValue(packet, MESSAGE_FORWARD_ADDRESS_LABEL, this.messageForward != null ? this.messageForward.toString() : "");
        Command.addFieldValue(packet, OTHER_PARAMS_LABEL, this.otherDomainParams != null ? this.otherDomainParams : "");
        super.addCommandFields(packet);
    }

    public String[] getComps() {
        return this.comps;
    }

    @Override
    public String getElemName() {
        return VHOST_ELEM;
    }

    @Override
    public String getKey() {
        return this.vhost.getDomain();
    }

    public long getMaxUsersNumber() {
        return this.maxUsersNumber;
    }

    public String getOtherDomainParams() {
        return this.otherDomainParams;
    }

    public VHostItem getUnmodifiableVHostItem() {
        if (this.unmodifiableItem == null) {
            this.unmodifiableItem = new UnmodifiableVHostItem();
        }
        return this.unmodifiableItem;
    }

    public JID getVhost() {
        return this.vhost;
    }

    public JID getPresenceForwardAddress() {
        return this.presenceForward;
    }

    public JID getMessageForwardAddress() {
        return this.presenceForward;
    }

    @Override
    public void initFromCommand(Packet packet) {
        super.initFromCommand(packet);
        String tmp = Command.getFieldValue(packet, HOSTNAME_LABEL);
        try {
            this.setVHost(tmp);
        }
        catch (TigaseStringprepException ex) {
            throw new IllegalArgumentException("Incorrect domain, unable to parse it: " + tmp, ex);
        }
        this.enabled = Command.getCheckBoxFieldValue(packet, ENABLED_LABEL);
        this.anonymousEnabled = Command.getCheckBoxFieldValue(packet, ANONYMOUS_ENABLED_LABEL);
        this.registerEnabled = Command.getCheckBoxFieldValue(packet, REGISTER_ENABLED_LABEL);
        try {
            this.maxUsersNumber = Long.parseLong(Command.getFieldValue(packet, MAX_USERS_NUMBER_LABEL));
        }
        catch (Exception e) {
            log.warning("Can not parse max users number: " + Command.getFieldValue(packet, MAX_USERS_NUMBER_LABEL));
        }
        tmp = Command.getFieldValue(packet, PRESENCE_FORWARD_ADDRESS_LABEL);
        if (tmp != null && !tmp.trim().isEmpty()) {
            try {
                this.presenceForward = JID.jidInstance((String)tmp);
            }
            catch (TigaseStringprepException ex) {
                this.presenceForward = null;
                throw new IllegalArgumentException("Incorrect presence forward address: " + tmp, ex);
            }
        }
        if ((tmp = Command.getFieldValue(packet, MESSAGE_FORWARD_ADDRESS_LABEL)) != null && !tmp.trim().isEmpty()) {
            try {
                this.messageForward = JID.jidInstance((String)tmp);
            }
            catch (TigaseStringprepException ex) {
                this.messageForward = null;
                throw new IllegalArgumentException("Incorrect message forward address: " + tmp, ex);
            }
        }
        this.otherDomainParams = Command.getFieldValue(packet, OTHER_PARAMS_LABEL);
    }

    @Override
    public void initFromElement(Element elem) {
        String comps_str;
        if (elem.getName() != VHOST_ELEM) {
            throw new IllegalArgumentException("Incorrect element name, expected: vhost");
        }
        super.initFromElement(elem);
        this.setVHost(JID.jidInstanceNS((String)elem.getAttribute(HOSTNAME_ATT)));
        this.enabled = Boolean.parseBoolean(elem.getAttribute(ENABLED_ATT));
        this.anonymousEnabled = Boolean.parseBoolean(elem.getAttribute(ANONYMOUS_ENABLED_ATT));
        this.registerEnabled = Boolean.parseBoolean(elem.getAttribute(REGISTER_ENABLED_ATT));
        try {
            this.maxUsersNumber = Long.parseLong(elem.getAttribute(MAX_USERS_NUMBER_ATT));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can not parse max users number: {0}", elem.getAttribute(MAX_USERS_NUMBER_ATT));
        }
        String tmp = elem.getAttribute(PRESENCE_FORWARD_ADDRESS_ATT);
        if (tmp != null && !tmp.trim().isEmpty()) {
            this.presenceForward = JID.jidInstanceNS((String)tmp);
        }
        if ((tmp = elem.getAttribute(MESSAGE_FORWARD_ADDRESS_ATT)) != null && !tmp.trim().isEmpty()) {
            this.messageForward = JID.jidInstanceNS((String)tmp);
        }
        if ((comps_str = elem.getCData("/vhost/comps")) != null && !comps_str.isEmpty()) {
            this.comps = comps_str.split(",");
        }
        this.otherDomainParams = elem.getCData("/vhost/other");
    }

    @Override
    public void initFromPropertyString(String propString) {
        String[] props = propString.split(":");
        try {
            this.setVHost(props[0]);
        }
        catch (TigaseStringprepException ex) {
            throw new IllegalArgumentException("Domain misconfiguration, cannot parse it: " + props[0], ex);
        }
        for (String tmp : props) {
            String[] mu;
            if (tmp.startsWith("-")) {
                if (tmp.endsWith(ANONYMOUS_ENABLED_ATT)) {
                    this.anonymousEnabled = false;
                }
                if (tmp.endsWith(REGISTER_ENABLED_ATT)) {
                    this.registerEnabled = false;
                }
            }
            if (tmp.startsWith(MAX_USERS_NUMBER_ATT)) {
                mu = tmp.split("=");
                try {
                    this.maxUsersNumber = Long.parseLong(mu[1]);
                }
                catch (NumberFormatException ex) {
                    this.maxUsersNumber = 0L;
                    log.warning("Incorrect max users numner for vhost settings, number parsing error: " + tmp);
                }
            }
            if (tmp.startsWith(PRESENCE_FORWARD_ADDRESS_ATT)) {
                mu = tmp.split("=");
                try {
                    this.presenceForward = JID.jidInstance((String)mu[1]);
                }
                catch (TigaseStringprepException ex) {
                    this.presenceForward = null;
                    log.warning("Incorrect presence forwarding address, address parsing error: " + tmp);
                }
            }
            if (!tmp.startsWith(MESSAGE_FORWARD_ADDRESS_ATT)) continue;
            mu = tmp.split("=");
            try {
                this.messageForward = JID.jidInstance((String)mu[1]);
            }
            catch (TigaseStringprepException ex) {
                this.messageForward = null;
                log.warning("Incorrect presence forwarding address, address parsing error: " + tmp);
            }
        }
    }

    public boolean isAnonymousEnabled() {
        return this.anonymousEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public void setAnonymousEnabled(boolean enabled) {
        this.anonymousEnabled = enabled;
    }

    public void setComps(String[] comps) {
        this.comps = comps;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setMaxUsersNumber(long maxUsersNumber) {
        this.maxUsersNumber = maxUsersNumber;
    }

    public JID getPresenceForward() {
        return this.presenceForward;
    }

    public void setPresenceForward(JID presenceForward) {
        this.presenceForward = presenceForward;
    }

    public JID getMessageForward() {
        return this.messageForward;
    }

    public void setMessageForward(JID messageForward) {
        this.messageForward = messageForward;
    }

    public void setOtherDomainParams(String otherParams) {
        this.otherDomainParams = otherParams;
    }

    public void setRegisterEnabled(boolean enabled) {
        this.registerEnabled = enabled;
    }

    public void setVHost(String vhost) throws TigaseStringprepException {
        if (vhost == null) {
            vhost = "";
        }
        this.vhost = JID.jidInstance((String)vhost);
    }

    public void setVHost(JID vhost) {
        this.vhost = vhost;
    }

    @Override
    public Element toElement() {
        Element elem = super.toElement();
        String comps_str = "";
        if (this.comps != null && this.comps.length > 0) {
            for (String comp : this.comps) {
                if (!comps_str.isEmpty()) {
                    comps_str = comps_str + ",";
                }
                comps_str = comps_str + comp;
            }
        }
        String other_params = this.otherDomainParams != null ? this.otherDomainParams : "";
        elem.addChild((XMLNodeIfc)new Element(COMPONENTS_ELEM, comps_str));
        elem.addChild((XMLNodeIfc)new Element(OTHER_PARAMS_ELEM, other_params));
        elem.addAttribute(HOSTNAME_ATT, this.vhost.getDomain());
        elem.addAttribute(ENABLED_ATT, "" + this.enabled);
        elem.addAttribute(ANONYMOUS_ENABLED_ATT, "" + this.anonymousEnabled);
        elem.addAttribute(REGISTER_ENABLED_ATT, "" + this.registerEnabled);
        elem.addAttribute(MAX_USERS_NUMBER_ATT, "" + this.maxUsersNumber);
        if (this.presenceForward != null) {
            elem.addAttribute(PRESENCE_FORWARD_ADDRESS_ATT, this.presenceForward.toString());
        }
        if (this.messageForward != null) {
            elem.addAttribute(MESSAGE_FORWARD_ADDRESS_ATT, this.messageForward.toString());
        }
        return elem;
    }

    @Override
    public String toPropertyString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.vhost.toString());
        if (!this.anonymousEnabled) {
            sb.append(":-").append(ANONYMOUS_ENABLED_ATT);
        }
        if (!this.registerEnabled) {
            sb.append(":-").append(REGISTER_ENABLED_ATT);
        }
        if (this.maxUsersNumber > 0L) {
            sb.append(':').append(MAX_USERS_NUMBER_ATT).append('=').append(this.maxUsersNumber);
        }
        if (this.presenceForward != null) {
            sb.append(':').append(PRESENCE_FORWARD_ADDRESS_ATT).append('=').append(this.presenceForward.toString());
        }
        if (this.messageForward != null) {
            sb.append(':').append(MESSAGE_FORWARD_ADDRESS_ATT).append('=').append(this.messageForward.toString());
        }
        return sb.toString();
    }

    public String toString() {
        return "Domain: " + this.vhost + ", enabled: " + this.enabled + ", anonym: " + this.anonymousEnabled + ", register: " + this.registerEnabled + ", maxusers: " + this.maxUsersNumber;
    }

    private class UnmodifiableVHostItem
    extends VHostItem {
        private UnmodifiableVHostItem() {
        }

        @Override
        public String[] getComps() {
            return VHostItem.this.getComps();
        }

        @Override
        public long getMaxUsersNumber() {
            return VHostItem.this.getMaxUsersNumber();
        }

        @Override
        public String getOtherDomainParams() {
            return VHostItem.this.getOtherDomainParams();
        }

        @Override
        public VHostItem getUnmodifiableVHostItem() {
            return this;
        }

        @Override
        public JID getVhost() {
            return VHostItem.this.getVhost();
        }

        @Override
        public void initFromElement(Element elem) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void initFromPropertyString(String propString) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public boolean isAnonymousEnabled() {
            return VHostItem.this.isAnonymousEnabled();
        }

        @Override
        public JID getPresenceForward() {
            return VHostItem.this.presenceForward;
        }

        @Override
        public void setPresenceForward(JID presenceForward) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public JID getMessageForward() {
            return VHostItem.this.messageForward;
        }

        @Override
        public void setMessageForward(JID messageForward) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public boolean isEnabled() {
            return VHostItem.this.isEnabled();
        }

        @Override
        public boolean isRegisterEnabled() {
            return VHostItem.this.isRegisterEnabled();
        }

        @Override
        public void setAnonymousEnabled(boolean enabled) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setComps(String[] comps) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setEnabled(boolean enabled) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setMaxUsersNumber(long maxUsersNumber) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setOtherDomainParams(String otherParams) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setRegisterEnabled(boolean enabled) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public Element toElement() {
            return VHostItem.this.toElement();
        }

        @Override
        public String toString() {
            return VHostItem.this.toString();
        }
    }
}

