/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.sys.TigaseRuntime;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;

public class PacketDefaultHandler {
    private static final Logger log = Logger.getLogger("tigase.server.xmppsession.PacketFilter");
    private static TigaseRuntime runtime = TigaseRuntime.getTigaseRuntime();
    private String[] AUTH_ONLY_ELEMS = new String[]{"message", "presence"};
    private String[] IGNORE_PACKETS = new String[]{"stream:features"};
    private StanzaType[] IGNORE_TYPES = new StanzaType[]{StanzaType.error};

    public boolean canHandle(Packet packet, XMPPResourceConnection session) {
        if (session == null) {
            return false;
        }
        if (packet.getStanzaTo() == null) {
            if (packet.getElemName() == "iq" && packet.getType() == StanzaType.result) {
                return true;
            }
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "No ''to'' address, can''t deliver packet: {0}", packet);
            }
            return false;
        }
        return true;
    }

    public boolean forward(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        return false;
    }

    public boolean preprocess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        block20: {
            if (session != null) {
                session.incPacketsCounter();
                XMPPSession parent = session.getParentSession();
                if (parent != null) {
                    parent.incPacketsCounter();
                }
            }
            for (int i = 0; i < this.IGNORE_PACKETS.length; ++i) {
                if (packet.getElemName() != this.IGNORE_PACKETS[i] || packet.getType() != this.IGNORE_TYPES[i]) continue;
                return true;
            }
            if (session == null || session.isServerSession()) {
                return false;
            }
            try {
                if (!session.getConnectionId().equals((Object)packet.getPacketFrom())) break block20;
                if (!session.isAuthorized()) {
                    for (String elem : this.AUTH_ONLY_ELEMS) {
                        if (packet.getElemName() != elem) continue;
                        results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authenticate session first, before you can send any message or presence packet.", true));
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Packet received before the session has been authenticated.Session details: connectionId={0}, sessionId={1}, packet={2}", new Object[]{session.getConnectionId(), session.getSessionId(), packet.toStringSecure()});
                        }
                        return true;
                    }
                    return false;
                }
                if (session.isResourceSet() || packet.isXMLNS("/iq/bind", "urn:ietf:params:xml:ns:xmpp-bind") || packet.isXMLNS("compress", "http://jabber.org/protocol/compress")) {
                    JID from_jid = session.getJID();
                    if (from_jid != null) {
                        if (packet.getStanzaFrom() == null || !from_jid.getBareJID().equals((Object)packet.getStanzaFrom().getBareJID())) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, "Setting correct from attribute: {0}", from_jid);
                            }
                            packet.initVars(from_jid, packet.getStanzaTo());
                        } else if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Skipping setting correct from attribute: {0}, is already correct.", from_jid);
                        }
                    } else {
                        log.log(Level.WARNING, "Session is authenticated but session.getJid() is empty: {0}", packet.toStringSecure());
                    }
                    break block20;
                }
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must bind the resource first: http://www.xmpp.org/rfcs/rfc3920.html#bind", true));
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "Session details: connectionId={0}, sessionId={1}", new Object[]{session.getConnectionId(), session.getSessionId()});
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Session more detais: JID={0}", session.getjid());
                }
                return true;
            }
            catch (PacketErrorTypeException e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Ignoring packet with an error to non-existen user session: {0}", packet.toStringSecure());
                }
            }
            catch (Exception e) {
                log.log(Level.FINEST, "Packet preprocessing exception: ", e);
                return false;
            }
        }
        return false;
    }

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet.toStringSecure());
        }
        try {
            BareJID from;
            JID to = packet.getStanzaTo();
            if (to == null && packet.getElemName() == "iq" && packet.getType() == StanzaType.result) {
                return;
            }
            if (session.isUserId(to.getBareJID())) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Yes, this is packet to ''this'' client: {0}", to);
                }
                Packet result = packet.copyElementOnly();
                result.setPacketFrom(packet.getTo());
                try {
                    result.setPacketTo(session.getConnectionId(packet.getStanzaTo()));
                    results.offer(result);
                }
                catch (NoConnectionIdException ex) {
                    log.log(Level.WARNING, "Packet to the server which hasn't been properly processed: {0}", packet);
                }
                return;
            }
            if (packet.getStanzaFrom() != null && session.isUserId(from = packet.getStanzaFrom().getBareJID())) {
                Packet result = packet.copyElementOnly();
                results.offer(result);
                return;
            }
        }
        catch (NotAuthorizedException e) {
            try {
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
                log.log(Level.INFO, "NotAuthorizedException for packet: {0}", packet.toString());
            }
            catch (PacketErrorTypeException e2) {
                log.log(Level.INFO, "Packet processing exception: {0}", e2);
            }
        }
    }
}

