/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.IOService;
import tigase.net.SocketThread;
import tigase.server.Command;
import tigase.server.ConnectionManager;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.server.xmppclient.IPMonitor;
import tigase.server.xmppclient.SeeOtherHostIfc;
import tigase.util.DNSResolver;
import tigase.util.RoutingsContainer;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class ClientConnectionManager
extends ConnectionManager<XMPPIOService<Object>> {
    private static final Logger log = Logger.getLogger(ClientConnectionManager.class.getName());
    private static final String XMLNS = "jabber:client";
    private static final String ROUTINGS_PROP_KEY = "routings";
    private static final String ROUTING_MODE_PROP_KEY = "multi-mode";
    private static final boolean ROUTING_MODE_PROP_VAL = true;
    private static final String ROUTING_ENTRY_PROP_KEY = ".+";
    private static final String SOCKET_CLOSE_WAIT_PROP_KEY = "socket-close-wait";
    private static final long SOCKET_CLOSE_WAIT_PROP_DEF = 1L;
    protected SeeOtherHostIfc see_other_host_strategy = null;
    protected RoutingsContainer routings = null;
    private final Map<String, XMPPProcessorIfc> processors = new ConcurrentHashMap<String, XMPPProcessorIfc>();
    private final ReceiverTimeoutHandler stoppedHandler = this.newStoppedHandler();
    private final ReceiverTimeoutHandler startedHandler = this.newStartedHandler();
    private long socket_close_wait_time = 1L;
    private IPMonitor ipMonitor = new IPMonitor();

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        Boolean r_mode = (Boolean)params.get(this.getName() + "/" + ROUTINGS_PROP_KEY + "/" + ROUTING_MODE_PROP_KEY);
        String see_other_host_class = (String)params.get("--cm-see-other-host");
        this.see_other_host_strategy = this.getSeeOtherHostInstance(see_other_host_class);
        props.put("cm-see-other-host", see_other_host_class);
        if (this.see_other_host_strategy != null) {
            this.see_other_host_strategy.getDefaults(props, params);
        }
        if (r_mode == null) {
            props.put("routings/multi-mode", true);
            if (params.get("config-type").equals("--gen-config-cs") && params.get("--ext-comp") != null) {
                String[] comp_params = ((String)params.get("--ext-comp")).split(",");
                props.put("routings/.+", "sess-man@" + comp_params[1]);
            } else {
                props.put("routings/.+", "sess-man@" + DNSResolver.getDefaultHostname());
            }
        }
        props.put(SOCKET_CLOSE_WAIT_PROP_KEY, 1L);
        return props;
    }

    @Override
    public String getDiscoCategoryType() {
        return "c2s";
    }

    @Override
    public String getDiscoDescription() {
        return "Client connection manager";
    }

    public SeeOtherHostIfc getSeeOtherHostInstance(String see_other_host_class) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Configuring see_other_host strategy for: " + see_other_host_class);
        }
        if (see_other_host_class == null) {
            see_other_host_class = "tigase.server.xmppclient.SeeOtherHost";
        }
        if (see_other_host_class.equals("none")) {
            return null;
        }
        try {
            this.see_other_host_strategy = (SeeOtherHostIfc)Class.forName(see_other_host_class).newInstance();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not instantiate see_other_host strategy for class: " + see_other_host_class, e);
        }
        return this.see_other_host_strategy;
    }

    @Override
    public int hashCodeForPacket(Packet packet) {
        if (packet.getPacketFrom() != null && this.getComponentId().getBareJID().equals((Object)packet.getPacketFrom().getBareJID())) {
            return packet.getPacketFrom().hashCode();
        }
        return packet.getTo().hashCode();
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet.toStringSecure());
        }
        if (packet.isCommand() && packet.getCommand() != Command.OTHER) {
            this.processCommand(packet);
        } else if (!this.writePacketToSocket(packet)) {
            block12: {
                if (packet.getType() != StanzaType.result && packet.getType() != StanzaType.available && packet.getType() != StanzaType.unavailable && packet.getType() != StanzaType.error && (packet.getElemName() != "presence" || packet.getType() != null)) {
                    try {
                        Packet error = Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "The user connection is no longer active.", true);
                        this.addOutPacket(error);
                    }
                    catch (PacketErrorTypeException e) {
                        if (!log.isLoggable(Level.FINEST)) break block12;
                        log.finest("Ups, already error packet. Dropping it to prevent infinite loop.");
                    }
                }
            }
            if (packet.getType() != StanzaType.unavailable && packet.getPacketFrom() != null) {
                if (packet.getStanzaTo() != null) {
                    Packet command2 = Command.STREAM_CLOSED_UPDATE.getPacket(packet.getStanzaTo(), packet.getPacketFrom(), StanzaType.set, UUID.randomUUID().toString());
                    command2.setPacketFrom(packet.getPacketTo());
                    command2.setPacketTo(packet.getPacketFrom());
                    this.addOutPacket(command2);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Sending a command to close the remote session for non-existen {0} connection: {1}", new Object[]{this.getName(), command2.toStringSecure()});
                    }
                } else if (log.isLoggable(Level.WARNING)) {
                    log.log(Level.FINE, "Stream close update without an user JID, skipping for packet: {0}", new Object[]{packet});
                }
            }
        }
    }

    @Override
    public Queue<Packet> processSocketData(XMPPIOService<Object> serv) {
        JID id = serv.getConnectionId();
        Packet p = null;
        while ((p = serv.getReceivedPackets().poll()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Processing socket data: {0} from connection: {1}", new Object[]{p.toStringSecure(), id});
            }
            if (p.getAttribute("xmlns") == null) {
                p.setXMLNS(XMLNS);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "XMLNS set for packet: {0} from connection: {1}", new Object[]{p.toStringSecure(), id});
                }
            }
            p.setPacketFrom(id);
            JID receiver = serv.getDataReceiver();
            if (receiver != null) {
                p.setPacketTo(serv.getDataReceiver());
                this.addOutPacket(p);
                continue;
            }
            if (!log.isLoggable(Level.INFO)) continue;
            log.log(Level.INFO, "Hm, receiver is not set yet (misconfiguration error)..., ignoring: {0}, connection: {1}", new Object[]{p.toStringSecure(), serv});
        }
        return null;
    }

    @Override
    public void reconnectionFailed(Map<String, Object> port_props) {
    }

    @Override
    public boolean serviceStopped(XMPPIOService<Object> service) {
        boolean result = super.serviceStopped(service);
        this.xmppStreamClosed(service);
        return result;
    }

    @Override
    public void serviceStarted(XMPPIOService<Object> service) {
        super.serviceStarted(service);
        String id = this.getUniqueId(service);
        JID connectionId = this.getFromAddress(id);
        service.setConnectionId(connectionId);
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.get(SOCKET_CLOSE_WAIT_PROP_KEY) != null) {
            this.socket_close_wait_time = (Long)props.get(SOCKET_CLOSE_WAIT_PROP_KEY);
        }
        if (props.size() == 1) {
            return;
        }
        String see_other_host_class = (String)props.get("cm-see-other-host");
        this.see_other_host_strategy = this.getSeeOtherHostInstance(see_other_host_class);
        if (this.see_other_host_strategy != null) {
            this.see_other_host_strategy.setProperties(props);
        }
        boolean routing_mode = (Boolean)props.get("routings/multi-mode");
        this.routings = new RoutingsContainer(routing_mode);
        int idx = "routings/".length();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!entry.getKey().startsWith("routings/") || entry.getKey().equals("routings/multi-mode")) continue;
            this.routings.addRouting(entry.getKey().substring(idx), (String)entry.getValue());
        }
    }

    @Override
    public void start() {
        super.start();
        this.ipMonitor = new IPMonitor();
        this.ipMonitor.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.ipMonitor.stopThread();
    }

    @Override
    public void tlsHandshakeCompleted(XMPPIOService<Object> service) {
    }

    @Override
    public void xmppStreamClosed(XMPPIOService<Object> serv) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Stream closed: {0}", serv.getConnectionId());
        }
        if (serv.getXMLNS() == XMLNS && serv.getSessionData().get("stream-closed") == null) {
            serv.getSessionData().put("stream-closed", "stream-closed");
            this.ipMonitor.addDisconnect(serv.getRemoteAddress());
            if (serv.getDataReceiver() != null) {
                Packet command2 = Command.STREAM_CLOSED.getPacket(serv.getConnectionId(), serv.getDataReceiver(), StanzaType.set, UUID.randomUUID().toString());
                this.addOutPacketWithTimeout(command2, this.stoppedHandler, 120L, TimeUnit.SECONDS);
                log.log(Level.FINE, "Service stopped, sending packet: {0}", command2);
            } else {
                log.fine("Service stopped, before stream:stream received");
            }
            serv.stop();
        }
    }

    @Override
    public String xmppStreamOpened(XMPPIOService<Object> serv, Map<String, String> attribs) {
        BareJID see_other_host;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Stream opened: {0}", attribs);
        }
        String lang = attribs.get("xml:lang");
        String hostname = attribs.get("to");
        String from = attribs.get("from");
        BareJID fromJID = null;
        if (from != null) {
            try {
                fromJID = BareJID.bareJIDInstance((String)from);
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.CONFIG, "From JID violates RFC6122 (XMPP:Address Format): ", ex);
                return "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='tigase-error-tigase' from='" + this.getDefVHostItem() + "'" + " version='1.0' xml:lang='en'>" + "<stream:error>" + "<improper-addressing xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>" + "</stream:error>" + "</stream:stream>";
            }
        }
        if (lang == null) {
            lang = "en";
        }
        if (hostname == null) {
            return "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='tigase-error-tigase' from='" + this.getDefVHostItem() + "'" + " version='1.0' xml:lang='en'>" + "<stream:error>" + "<improper-addressing xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>" + "</stream:error>" + "</stream:stream>";
        }
        if (!this.isLocalDomain(hostname)) {
            return "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='tigase-error-tigase' from='" + this.getDefVHostItem() + "'" + " version='1.0' xml:lang='en'>" + "<stream:error>" + "<host-unknown xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>" + "</stream:error>" + "</stream:stream>";
        }
        if (fromJID != null && this.see_other_host_strategy != null && (see_other_host = this.see_other_host_strategy.findHostForJID(fromJID, this.getDefHostName())) != null && !see_other_host.equals((Object)this.getDefHostName())) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Sending redirect for {0} to host {1}, connection {2}.", new Object[]{fromJID, see_other_host, serv});
            }
            return "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='tigase-error-tigase' from='" + this.getDefVHostItem() + "'" + " version='1.0' xml:lang='en'>" + "<stream:error>" + "<see-other-host xmlns='urn:ietf:params:xml:ns:xmpp-streams'>" + see_other_host + "</see-other-host>" + "</stream:error>" + "</stream:stream>";
        }
        String id = (String)serv.getSessionData().get("sessionID");
        if (id == null) {
            id = UUID.randomUUID().toString();
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "No Session ID, generating a new one: {0}", id);
            }
            serv.getSessionData().put("sessionID", id);
            serv.setXMLNS(XMLNS);
            serv.getSessionData().put("hostname-key", hostname);
            serv.setDataReceiver(JID.jidInstanceNS((String)this.routings.computeRouting(hostname)));
            String streamOpenData = "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' from='" + hostname + "'" + " id='" + id + "'" + " version='1.0' xml:lang='en'>";
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Writing raw data to the socket: {0}", streamOpenData);
            }
            this.writeRawData(serv, streamOpenData);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "DONE");
            }
            Packet streamOpen = Command.STREAM_OPENED.getPacket(serv.getConnectionId(), serv.getDataReceiver(), StanzaType.set, this.newPacketId("c2s-"), Command.DataType.submit);
            Command.addFieldValue(streamOpen, "session-id", id);
            Command.addFieldValue(streamOpen, "hostname", hostname);
            Command.addFieldValue(streamOpen, "xml:lang", lang);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Sending a system command to SM: {0}", streamOpen);
            }
            this.addOutPacketWithTimeout(streamOpen, this.startedHandler, 45L, TimeUnit.SECONDS);
            log.log(Level.FINER, "DOEN 2");
        } else {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Session ID is: {0}", id);
            }
            this.writeRawData(serv, "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' from='" + hostname + "'" + " id='" + id + "'" + " version='1.0' xml:lang='en'>");
            this.addOutPacket(Command.GETFEATURES.getPacket(serv.getConnectionId(), serv.getDataReceiver(), StanzaType.get, UUID.randomUUID().toString(), null));
        }
        return null;
    }

    protected JID changeDataReceiver(Packet packet, JID newAddress, String command_sessionId, XMPPIOService<Object> serv) {
        if (serv != null) {
            String serv_sessionId = (String)serv.getSessionData().get("sessionID");
            if (serv_sessionId.equals(command_sessionId)) {
                JID old_receiver = serv.getDataReceiver();
                serv.setDataReceiver(newAddress);
                return old_receiver;
            }
            log.log(Level.WARNING, "Incorrect session ID, ignoring data redirect for: {0}, expected: {1}, received: {2}", new Object[]{newAddress, serv_sessionId, command_sessionId});
        }
        return null;
    }

    @Override
    protected int[] getDefPlainPorts() {
        return new int[]{5222};
    }

    @Override
    protected int[] getDefSSLPorts() {
        return new int[]{5223};
    }

    @Override
    protected long getMaxInactiveTime() {
        return 86400000L;
    }

    @Override
    protected Integer getMaxQueueSize(int def) {
        return def * 10;
    }

    @Override
    protected XMPPIOService<Object> getXMPPIOServiceInstance() {
        return new XMPPIOService<Object>();
    }

    protected ReceiverTimeoutHandler newStartedHandler() {
        return new StartedHandler();
    }

    protected ReceiverTimeoutHandler newStoppedHandler() {
        return new StoppedHandler();
    }

    protected void processCommand(Packet packet) {
        Object serv = this.getXMPPIOService(packet);
        Iq iqc = (Iq)packet;
        switch (iqc.getCommand()) {
            case GETFEATURES: {
                if (iqc.getType() != StanzaType.result) break;
                List<Element> features = this.getFeatures(this.getXMPPSession(iqc));
                Element elem_features = new Element("stream:features");
                elem_features.addChildren(features);
                elem_features.addChildren(Command.getData(iqc));
                Packet result = Packet.packetInstance(elem_features, null, null);
                result.setPacketTo(iqc.getTo());
                this.writePacketToSocket(result);
                break;
            }
            case STARTZLIB: {
                if (serv != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Starting zlib compression: {0}", serv);
                    }
                    try {
                        Element compressed = Command.getData(iqc, "compressed", null);
                        Packet p_compressed = Packet.packetInstance(compressed, null, null);
                        SocketThread.removeSocketService(serv);
                        ((XMPPIOService)serv).addPacketToSend(p_compressed);
                        ((XMPPIOService)serv).processWaitingPackets();
                        ((IOService)serv).startZLib(9);
                        SocketThread.addSocketService(serv);
                    }
                    catch (IOException ex) {
                        log.log(Level.INFO, "Problem enabling zlib compression on the connection: ", ex);
                    }
                    break;
                }
                log.log(Level.WARNING, "Can't find sevice for STARTZLIB command: {0}", iqc);
                break;
            }
            case STARTTLS: {
                if (serv != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Starting TLS for connection: {0}", serv);
                    }
                    try {
                        Element proceed = Command.getData(iqc, "proceed", null);
                        Packet p_proceed = Packet.packetInstance(proceed, null, null);
                        SocketThread.removeSocketService(serv);
                        ((XMPPIOService)serv).addPacketToSend(p_proceed);
                        ((XMPPIOService)serv).processWaitingPackets();
                        ((IOService)serv).startTLS(false);
                        SocketThread.addSocketService(serv);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Error starting TLS: {0}", e);
                        ((IOService)serv).forceStop();
                    }
                    break;
                }
                log.log(Level.WARNING, "Can't find sevice for STARTTLS command: {0}", iqc);
                break;
            }
            case REDIRECT: {
                String command_sessionId = Command.getFieldValue(iqc, "session-id");
                JID newAddress = iqc.getFrom();
                JID old_receiver = this.changeDataReceiver(iqc, newAddress, command_sessionId, (XMPPIOService<Object>)serv);
                if (old_receiver != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Redirecting data for sessionId: {0}, to: {1}", new Object[]{command_sessionId, newAddress});
                    }
                    Packet response = null;
                    response = iqc.commandResult(null);
                    Command.addFieldValue(response, "session-id", command_sessionId);
                    Command.addFieldValue(response, "action", "activate");
                    response.getElement().setAttribute("to", newAddress.toString());
                    this.addOutPacket(response);
                    break;
                }
                if (!log.isLoggable(Level.FINEST)) break;
                log.log(Level.FINEST, "Connection for REDIRECT command does not exist, ignoring packet: {0}", iqc.toStringSecure());
                break;
            }
            case STREAM_CLOSED: {
                break;
            }
            case GETDISCO: {
                break;
            }
            case CLOSE: {
                if (serv != null) {
                    String streamClose = "</stream:stream>";
                    List err_el = packet.getElement().getChildren("/iq/command");
                    boolean moreToSend = false;
                    if (err_el != null && err_el.size() > 0) {
                        streamClose = "<stream:error>" + ((Element)err_el.get(0)).toString() + "</stream:error>" + streamClose;
                        moreToSend = true;
                    }
                    try {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Sending stream close to the client: {0}", streamClose);
                        }
                        ((XMPPIOService)serv).writeRawData(streamClose);
                        if (moreToSend) {
                            Thread.sleep(this.socket_close_wait_time);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ((XMPPIOService)serv).stop();
                    break;
                }
                if (!log.isLoggable(Level.FINE)) break;
                log.log(Level.FINE, "Attempt to stop non-existen service for packet: {0}, Service already stopped?", iqc);
                break;
            }
            case CHECK_USER_CONNECTION: {
                if (serv != null) {
                    this.addOutPacket(iqc.okResult((String)null, 0));
                    break;
                }
                try {
                    this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(iqc, "Connection gone.", false));
                }
                catch (PacketErrorTypeException e) {
                    log.log(Level.INFO, "Error packet is not really expected here: {0}", iqc.toStringSecure());
                }
                break;
            }
            default: {
                this.writePacketToSocket(iqc);
            }
        }
    }

    private List<Element> getFeatures(XMPPResourceConnection session) {
        LinkedList<Element> results = new LinkedList<Element>();
        for (XMPPProcessorIfc proc : this.processors.values()) {
            Element[] features = proc.supStreamFeatures(session);
            if (features == null) continue;
            results.addAll(Arrays.asList(features));
        }
        return results;
    }

    private JID getFromAddress(String id) {
        return JID.jidInstanceNS((String)this.getName(), (String)this.getDefHostName().getDomain(), (String)id);
    }

    private XMPPResourceConnection getXMPPSession(Packet p) {
        Object serv = this.getXMPPIOService(p);
        return serv == null ? null : (XMPPResourceConnection)((IOService)serv).getSessionData().get("xmpp-session");
    }

    private class StoppedHandler
    implements ReceiverTimeoutHandler {
        private StoppedHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Response for stop received...");
            }
        }

        @Override
        public void timeOutExpired(Packet packet) {
            log.log(Level.INFO, "No response within time limit received for a packet: {0}", packet.toStringSecure());
            ClientConnectionManager.this.addOutPacketWithTimeout(packet, ClientConnectionManager.this.stoppedHandler, 60L, TimeUnit.SECONDS);
        }
    }

    private class StartedHandler
    implements ReceiverTimeoutHandler {
        private StartedHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            ClientConnectionManager.this.addOutPacket(Command.GETFEATURES.getPacket(packet.getFrom(), packet.getTo(), StanzaType.get, UUID.randomUUID().toString(), null));
        }

        @Override
        public void timeOutExpired(Packet packet) {
            log.log(Level.INFO, "No response within time limit received for a packet: {0}", packet.toStringSecure());
            XMPPIOService serv = ClientConnectionManager.this.getXMPPIOService(packet.getFrom().toString());
            if (serv != null) {
                serv.stop();
            } else {
                log.log(Level.FINE, "Attempt to stop non-existen service for packet: {0}, Service already stopped?", packet);
            }
        }
    }
}

