/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp.cond;

import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.amp.ConditionIfc;
import tigase.xml.Element;

public class Deliver
implements ConditionIfc {
    private static Logger log = Logger.getLogger(Deliver.class.getName());
    private static final String name = "deliver";
    private boolean offline_storage = true;

    public Deliver() {
        String off_val = System.getProperty("msg-offline");
        this.offline_storage = off_val == null || Boolean.parseBoolean(off_val);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean match(Packet packet, Element rule) {
        String value = rule.getAttribute("value");
        boolean result = false;
        if (value != null) {
            try {
                MatchValue m_val = MatchValue.valueOf(value);
                switch (m_val) {
                    case direct: {
                        result = packet.getAttribute("offline") == null && packet.getAttribute("from-conn-id") == null;
                        break;
                    }
                    case forward: {
                        break;
                    }
                    case gateway: {
                        break;
                    }
                    case none: {
                        result = packet.getAttribute("offline") != null && !this.offline_storage;
                        break;
                    }
                    case stored: {
                        result = packet.getAttribute("offline") != null && this.offline_storage;
                    }
                }
            }
            catch (Exception e) {
                log.info("Incorrect deliver condition value for rule: " + rule);
            }
        } else {
            log.info("No value set for rule: " + rule);
        }
        return result;
    }

    private static enum MatchValue {
        direct,
        forward,
        gateway,
        none,
        stored;

    }
}

