/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import tigase.conf.ConfigurationException;
import tigase.conf.ConfiguratorAbstract;
import tigase.server.MessageRouterIfc;
import tigase.server.ThreadExceptionHandler;

public final class XMPPServer {
    public static final String CONFIGURATOR_PROP_KEY = "tigase-configurator";
    private static final String DEF_CONFIGURATOR = "tigase.conf.Configurator";
    public static final String NAME = "Tigase";
    private static String serverName = "message-router";

    private XMPPServer() {
    }

    public static String getImplementationVersion() {
        String version = XMPPServer.class.getPackage().getImplementationVersion();
        return version == null ? "0.0.0-0" : version;
    }

    public static String help() {
        return "\nParameters:\n -h               this help message\n -v               prints server version info\n -d [true|false]    turn on|off debug mode\n -m               turn on server monitor\n -n server-name    sets server name\n";
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new ThreadExceptionHandler());
        XMPPServer.parseParams(args);
        String initial_config = "tigase.level=ALL\ntigase.xml.level=INFO\nhandlers=java.util.logging.ConsoleHandler\njava.util.logging.ConsoleHandler.level=ALL\njava.util.logging.ConsoleHandler.formatter=tigase.util.LogFormatter\n";
        ConfiguratorAbstract.loadLogManagerConfig(initial_config);
        try {
            String config_class_name = System.getProperty(CONFIGURATOR_PROP_KEY, DEF_CONFIGURATOR);
            ConfiguratorAbstract config = (ConfiguratorAbstract)Class.forName(config_class_name).newInstance();
            config.init(args);
            config.setName("basic-conf");
            String mr_class_name = config.getMessageRouterClassName();
            MessageRouterIfc router = (MessageRouterIfc)Class.forName(mr_class_name).newInstance();
            router.setName(serverName);
            router.setConfig(config);
            router.start();
        }
        catch (ConfigurationException e) {
            System.err.println("");
            System.err.println("  --------------------------------------");
            System.err.println("  ERROR! Terminating the server process.");
            System.err.println("  Invalid configuration data: " + e);
            System.err.println("  Please fix the problem and start the server again.");
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("");
            System.err.println("  --------------------------------------");
            System.err.println("  ERROR! Terminating the server process.");
            System.err.println("  Problem initializing the server: " + e);
            System.err.println("  Please fix the problem and start the server again.");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void parseParams(String[] args) {
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    System.out.print(XMPPServer.help());
                    System.exit(0);
                }
                if (args[i].equals("-v")) {
                    System.out.print(XMPPServer.version());
                    System.exit(0);
                }
                if (!args[i].equals("-n")) continue;
                if (i + 1 == args.length) {
                    System.out.print(XMPPServer.help());
                    System.exit(1);
                    continue;
                }
                serverName = args[++i];
            }
        }
    }

    public static String version() {
        return "\n-- \nTigase XMPP Server, version: " + XMPPServer.getImplementationVersion() + "\n" + "Author:  Artur Hefczyc <artur.hefczyc@tigase.org>\n" + "-- \n";
    }
}

