/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngineManager;
import tigase.conf.Configurable;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.CmdAcl;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.script.AbstractScriptCommand;
import tigase.server.script.AddScriptCommand;
import tigase.server.script.CommandIfc;
import tigase.server.script.RemoveScriptCommand;
import tigase.util.DNSResolver;
import tigase.util.TigaseStringprepException;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostListener;
import tigase.vhosts.VHostManagerIfc;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class BasicComponent
implements Configurable,
XMPPService,
VHostListener {
    public static final String SCRIPTS_DIR_PROP_DEF = "scripts/admin";
    public static final String SCRIPTS_DIR_PROP_KEY = "scripts-dir";
    public static final String COMMAND_PROP_NODE = "command";
    public static final String ALL_PROP_KEY = "ALL";
    private static final Logger log = Logger.getLogger(BasicComponent.class.getName());
    private String DEF_HOSTNAME_PROP_VAL = DNSResolver.getDefaultHostname();
    private JID compId = null;
    private String name = null;
    private BareJID defHostname = BareJID.bareJIDInstanceNS((String)this.DEF_HOSTNAME_PROP_VAL);
    protected Map<String, CommandIfc> scriptCommands = new ConcurrentHashMap<String, CommandIfc>(20);
    private boolean nonAdminCommands = false;
    private Map<String, EnumSet<CmdAcl>> commandsACL = new ConcurrentHashMap<String, EnumSet<CmdAcl>>(20);
    protected Set<BareJID> admins = new ConcurrentSkipListSet<BareJID>();
    private ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private String scriptsBaseDir = null;
    private String scriptsCompDir = null;
    private ServiceEntity serviceEntity = null;
    protected VHostManagerIfc vHostManager = null;

    public void addComponentDomain(String domain) {
        this.vHostManager.addComponentDomain(domain);
    }

    public boolean canCallCommand(JID jid, String commandId) {
        boolean result = this.isAdmin(jid);
        if (result) {
            return true;
        }
        EnumSet<CmdAcl> acl = this.commandsACL.get(ALL_PROP_KEY);
        if (acl != null) {
            result = this.checkCommandAcl(jid, acl);
        }
        if (!result && (acl = this.commandsACL.get(commandId)) != null) {
            result = this.checkCommandAcl(jid, acl);
        }
        return result;
    }

    public boolean checkCommandAcl(JID jid, EnumSet<CmdAcl> acl) {
        block6: for (CmdAcl cmdAcl : acl) {
            switch (cmdAcl) {
                case ALL: {
                    return true;
                }
                case ADMIN: {
                    if (!this.isAdmin(jid)) continue block6;
                    return true;
                }
                case LOCAL: {
                    if (!this.isLocalDomain(jid.getDomain())) continue block6;
                    return true;
                }
                case DOMAIN: {
                    if (!jid.getDomain().equals(cmdAcl.getAclVal())) continue block6;
                    return true;
                }
            }
            if (!jid.getBareJID().toString().equals(cmdAcl.getAclVal())) continue;
            return true;
        }
        return false;
    }

    @Override
    public JID getComponentId() {
        return this.compId;
    }

    public BareJID getDefHostName() {
        return this.defHostname;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        LinkedHashMap<String, Object> defs = new LinkedHashMap<String, Object>(50);
        defs.put("component-id", this.compId.toString());
        this.DEF_HOSTNAME_PROP_VAL = DNSResolver.getDefaultHostname();
        defs.put("def-hostname", this.DEF_HOSTNAME_PROP_VAL);
        String[] adm = null;
        adm = params.get("--admins") != null ? ((String)params.get("--admins")).split(",") : new String[]{"admin@localhost"};
        defs.put("admins", adm);
        String scripts_dir = (String)params.get("--script-dir");
        if (scripts_dir == null) {
            scripts_dir = SCRIPTS_DIR_PROP_DEF;
        }
        defs.put(SCRIPTS_DIR_PROP_KEY, scripts_dir);
        defs.put("command/ALL", CmdAcl.ADMIN.name());
        return defs;
    }

    public String getDiscoCategoryType() {
        return "generic";
    }

    public String getDiscoCategory() {
        return "component";
    }

    public String getDiscoDescription() {
        return "Undefined description";
    }

    @Deprecated
    public List<Element> getDiscoFeatures() {
        return null;
    }

    @Override
    public List<Element> getDiscoFeatures(JID from) {
        return this.getDiscoFeatures();
    }

    @Deprecated
    public Element getDiscoInfo(String node, JID jid) {
        return null;
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        Element result = this.getDiscoInfo(node, jid);
        if (result != null) {
            return result;
        }
        if (this.getName().equals(jid.getLocalpart())) {
            return this.serviceEntity.getDiscoInfo(node, this.isAdmin(from) || this.nonAdminCommands);
        }
        return null;
    }

    @Deprecated
    public List<Element> getDiscoItems(String node, JID jid) {
        return null;
    }

    public List<Element> getScriptItems(String node, JID jid, JID from) {
        LinkedList<Element> result = null;
        boolean isAdminFrom = this.isAdmin(from);
        if (node.equals("http://jabber.org/protocol/commands") && (isAdminFrom || this.nonAdminCommands)) {
            result = new LinkedList<Element>();
            for (CommandIfc comm : this.scriptCommands.values()) {
                if (comm.isAdminOnly() && !isAdminFrom) continue;
                result.add(new Element("item", new String[]{"node", "name", "jid"}, new String[]{comm.getCommandId(), comm.getDescription(), jid.toString()}));
            }
        }
        return result;
    }

    @Override
    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        List<Element> result = this.getDiscoItems(node, jid);
        if (result != null) {
            return result;
        }
        boolean isAdminFrom = this.isAdmin(from);
        if (this.getName().equals(jid.getLocalpart())) {
            if (node != null) {
                result = this.getScriptItems(node, jid, from);
            } else {
                result = this.serviceEntity.getDiscoItems(null, jid.toString(), isAdminFrom || this.nonAdminCommands);
                if (result != null) {
                    Iterator<Element> it = result.iterator();
                    while (it.hasNext()) {
                        Element element = it.next();
                        if (element.getAttribute("node") != null) continue;
                        it.remove();
                    }
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0} Found disco items: {1}", new Object[]{this.getName(), result != null ? result.toString() : null});
            }
            return result;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0} General disco items request, node: {1}", new Object[]{this.getName(), node});
        }
        if (node == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0} Disco items request for null node", new Object[]{this.getName()});
            }
            Element res = null;
            if (!this.serviceEntity.isAdminOnly() || isAdminFrom || this.nonAdminCommands) {
                res = this.serviceEntity.getDiscoItem(null, BareJID.toString((String)this.getName(), (String)jid.toString()));
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0} not admin only or isAdmin, result: {1}", new Object[]{this.getName(), res});
                }
            }
            result = this.serviceEntity.getDiscoItems(null, null, isAdminFrom || this.nonAdminCommands);
            if (res != null) {
                if (result != null) {
                    Iterator<Element> it = result.iterator();
                    while (it.hasNext()) {
                        Element element = it.next();
                        if (element.getAttribute("node") == null) continue;
                        it.remove();
                    }
                    result.add(0, res);
                } else {
                    result = Arrays.asList(res);
                }
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public VHostItem getVHostItem(String domain) {
        return this.vHostManager != null ? this.vHostManager.getVHostItem(domain) : null;
    }

    public BareJID getDefVHostItem() {
        return this.vHostManager != null ? this.vHostManager.getDefVHostItem() : this.getDefHostName();
    }

    @Override
    public boolean handlesLocalDomains() {
        return false;
    }

    @Override
    public boolean handlesNameSubdomains() {
        return true;
    }

    @Override
    public boolean handlesNonLocalDomains() {
        return false;
    }

    public void initBindings(Bindings binds) {
        binds.put("vhostMan", (Object)this.vHostManager);
        binds.put("adminsSet", (Object)this.admins);
        binds.put("cmdsAcl", (Object)this.commandsACL);
        binds.put("scriptManager", (Object)this.scriptEngineManager);
        binds.put("adminCommands", (Object)this.scriptCommands);
        binds.put("adminDisco", (Object)this.serviceEntity);
        binds.put("scriptBaseDir", (Object)this.scriptsBaseDir);
        binds.put("scriptCompDir", (Object)this.scriptsCompDir);
        binds.put("componentName", (Object)this.getName());
    }

    @Override
    public void initializationCompleted() {
    }

    public boolean isAdmin(JID jid) {
        return this.admins.contains(jid.getBareJID());
    }

    public boolean isLocalDomain(String domain) {
        return this.vHostManager != null ? this.vHostManager.isLocalDomain(domain) : false;
    }

    public boolean isLocalDomainOrComponent(String domain) {
        return this.vHostManager != null ? this.vHostManager.isLocalDomainOrComponent(domain) : false;
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        if (packet.isCommand() && this.getName().equals(packet.getStanzaTo().getLocalpart()) && this.isLocalDomain(packet.getStanzaTo().getDomain())) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Command addressed to: {0}, command: {1}", new Object[]{this.getName(), packet});
            }
            this.processScriptCommand(packet, results);
        }
    }

    @Override
    public void release() {
    }

    public void removeComponentDomain(String domain) {
        this.vHostManager.removeComponentDomain(domain);
    }

    public void removeServiceDiscoveryItem(String jid, String node, String description) {
        ServiceEntity item = new ServiceEntity(jid, node, description);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Modifying service-discovery info, removing: {0}", item);
        }
        this.serviceEntity.removeItems(item);
    }

    @Override
    public void setName(String name) {
        this.name = name;
        try {
            this.compId = JID.jidInstance((String)name, (String)this.defHostname.getDomain(), null);
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.WARNING, "Problem setting component ID: ", ex);
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        String[] admins_tmp;
        if (props.get("component-id") != null) {
            try {
                this.compId = JID.jidInstance((String)((String)props.get("component-id")));
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.WARNING, "Problem setting component ID: ", ex);
            }
        }
        if (props.get("def-hostname") != null) {
            this.defHostname = BareJID.bareJIDInstanceNS((String)((String)props.get("def-hostname")));
        }
        if ((admins_tmp = (String[])props.get("admins")) != null) {
            for (String admin : admins_tmp) {
                try {
                    this.admins.add(BareJID.bareJIDInstance((String)admin));
                }
                catch (TigaseStringprepException ex) {
                    log.log(Level.CONFIG, "Incorrect admin JID: ", ex);
                }
            }
        }
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!entry.getKey().startsWith(COMMAND_PROP_NODE)) continue;
            String cmdId = entry.getKey().substring(COMMAND_PROP_NODE.length() + 1);
            String[] cmdAcl = entry.getValue().toString().split(",");
            EnumSet<CmdAcl> acl = EnumSet.noneOf(CmdAcl.class);
            for (String cmda : cmdAcl) {
                CmdAcl acl_tmp = CmdAcl.valueof(cmda);
                acl.add(acl_tmp);
                if (acl_tmp == CmdAcl.ADMIN) continue;
                this.nonAdminCommands = true;
            }
            this.commandsACL.put(cmdId, acl);
        }
        this.serviceEntity = new ServiceEntity(this.name, null, this.getDiscoDescription(), true);
        this.serviceEntity.addIdentities(new ServiceIdentity(this.getDiscoCategory(), this.getDiscoCategoryType(), this.getDiscoDescription()));
        this.serviceEntity.addFeatures("http://jabber.org/protocol/commands");
        AbstractScriptCommand command2 = new AddScriptCommand();
        command2.init("add-script", "New command script");
        this.scriptCommands.put(command2.getCommandId(), command2);
        command2 = new RemoveScriptCommand();
        command2.init("del-script", "Remove command script");
        this.scriptCommands.put(command2.getCommandId(), command2);
        if (props.get(SCRIPTS_DIR_PROP_KEY) != null) {
            this.scriptsBaseDir = (String)props.get(SCRIPTS_DIR_PROP_KEY);
            this.scriptsCompDir = this.scriptsBaseDir + "/" + this.getName();
            this.loadScripts();
        }
    }

    @Override
    public void setVHostManager(VHostManagerIfc manager) {
        this.vHostManager = manager;
    }

    public void updateServiceDiscoveryItem(String jid, String node, String description, boolean admin) {
        this.updateServiceDiscoveryItem(jid, node, description, admin, (String[])null);
    }

    public void updateServiceDiscoveryItem(String jid, String node, String description, boolean admin, String ... features) {
        this.updateServiceDiscoveryItem(jid, node, description, null, null, admin, features);
    }

    public void updateServiceDiscoveryItem(String jid, String node, String description, String category, String type, boolean admin, String ... features) {
        if (this.serviceEntity.getJID().equals(jid) && this.serviceEntity.getNode() == node) {
            this.serviceEntity.setAdminOnly(admin);
            this.serviceEntity.setDescription(description);
            if (category != null || type != null) {
                this.serviceEntity.addIdentities(new ServiceIdentity(category, type, description));
            }
            if (features != null) {
                this.serviceEntity.setFeatures("http://jabber.org/protocol/commands");
                this.serviceEntity.addFeatures(features);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Modifying service-discovery info: {0}", this.serviceEntity);
            }
        } else {
            ServiceEntity item = new ServiceEntity(jid, node, description, admin);
            if (category != null || type != null) {
                item.addIdentities(new ServiceIdentity(category, type, description));
            }
            if (features != null) {
                item.addFeatures(features);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Adding new item: {0}", item);
            }
            this.serviceEntity.addItems(item);
        }
    }

    protected boolean processScriptCommand(Packet pc, Queue<Packet> results) {
        if (pc.getPermissions() == Permissions.NONE) {
            return false;
        }
        Iq iqc = (Iq)pc;
        Command.Action action = Command.getAction(iqc);
        if (action == Command.Action.cancel) {
            Packet result = iqc.commandResult(Command.DataType.result);
            Command.addTextField(result, "Note", "Command canceled.");
            results.offer(result);
            return true;
        }
        String strCommand = iqc.getStrCommand();
        CommandIfc com = this.scriptCommands.get(strCommand);
        if (strCommand != null && com != null) {
            boolean admin = false;
            try {
                admin = this.canCallCommand(iqc.getStanzaFrom(), strCommand);
                if (admin) {
                    Bindings binds;
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Processing admin command: {0}", pc);
                    }
                    if ((binds = com.getBindings()) == null) {
                        binds = this.scriptEngineManager.getBindings();
                    }
                    this.initBindings(binds);
                    com.runCommand(iqc, binds, results);
                } else {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Command rejected non-admin detected: {0}", pc.getStanzaFrom());
                    }
                    results.offer(Authorization.FORBIDDEN.getResponseMessage(pc, "Only Administrator can call the command.", true));
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Unknown admin command processing exception: " + pc, e);
            }
            return true;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "No such command: {0}, ignoring packet: {1}", new Object[]{strCommand, pc});
        }
        return false;
    }

    private void loadScripts() {
        String[] dirs;
        log.log(Level.CONFIG, "Loading admin scripts for component: {0}.", new Object[]{this.getName()});
        File file = null;
        AddScriptCommand addCommand = new AddScriptCommand();
        Bindings binds = this.scriptEngineManager.getBindings();
        this.initBindings(binds);
        for (String scriptsPath : dirs = new String[]{this.scriptsBaseDir, this.scriptsCompDir}) {
            log.log(Level.CONFIG, "{0}: Loading scripts from directory: {1}", new Object[]{this.getName(), scriptsPath});
            try {
                File adminDir = new File(scriptsPath);
                if (adminDir != null && adminDir.exists()) {
                    for (File f : adminDir.listFiles()) {
                        if (!f.isFile() || f.toString().endsWith("~")) continue;
                        String cmdId = null;
                        String cmdDescr = null;
                        String comp = null;
                        file = f;
                        StringBuilder sb = new StringBuilder();
                        BufferedReader buffr = new BufferedReader(new FileReader(file));
                        String line = null;
                        while ((line = buffr.readLine()) != null) {
                            sb.append(line).append("\n");
                            int idx = line.indexOf("AS:Description:");
                            if (idx >= 0) {
                                cmdDescr = line.substring(idx + "AS:Description:".length()).trim();
                            }
                            if ((idx = line.indexOf("AS:CommandId:")) >= 0) {
                                cmdId = line.substring(idx + "AS:CommandId:".length()).trim();
                            }
                            if ((idx = line.indexOf("AS:Component:")) < 0) continue;
                            comp = line.substring(idx + "AS:Component:".length()).trim();
                        }
                        buffr.close();
                        if (cmdId == null || cmdDescr == null || comp == null) {
                            log.log(Level.WARNING, "Admin script found but it has no command ID or commanddescription: {0}", file);
                            continue;
                        }
                        String[] comp_names = comp.split(",");
                        boolean found = false;
                        for (String cmp : comp_names) {
                            found = this.getName().equals(cmp);
                            if (found) break;
                        }
                        if (!found) {
                            log.log(Level.CONFIG, "{0}: skipping admin script for component: {1}", new Object[]{this.getName(), comp});
                            continue;
                        }
                        int idx = file.toString().lastIndexOf(46);
                        String ext = file.toString().substring(idx + 1);
                        addCommand.addAdminScript(cmdId, cmdDescr, sb.toString(), null, ext, binds);
                        log.log(Level.CONFIG, "{0}: Loaded admin command from file: {1}, id: {2}, ext: {3}, descr: {4}", new Object[]{this.getName(), file, cmdId, ext, cmdDescr});
                    }
                    continue;
                }
                log.log(Level.CONFIG, "Admin scripts directory is missing: {0}, creating...", adminDir);
                try {
                    adminDir.mkdirs();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Can't create scripts directory , read-only filesystem: " + file, e);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can't load the admin script file: " + file, e);
            }
        }
    }
}

