/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.db.comp.ComponentRepository;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.ServerComponent;
import tigase.stats.StatisticsContainer;
import tigase.stats.StatisticsList;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostListener;
import tigase.vhosts.VHostManagerIfc;
import tigase.xmpp.BareJID;

public class VHostManager
extends AbstractComponentRegistrator<VHostListener>
implements VHostManagerIfc,
StatisticsContainer {
    public static final String VHOSTS_REPO_CLASS_PROPERTY = "--vhost-repo-class";
    public static final String VHOSTS_REPO_CLASS_PROP_KEY = "repository-class";
    public static final String VHOSTS_REPO_CLASS_PROP_VAL = "tigase.vhosts.VHostJDBCRepository";
    private static final Logger log = Logger.getLogger(VHostManager.class.getName());
    private long getComponentsForLocalDomainCalls = 0L;
    private long getComponentsForNonLocalDomainCalls = 0L;
    private String identity_type = "generic";
    private long isAnonymousEnabledCalls = 0L;
    private long isLocalDomainCalls = 0L;
    private LinkedHashSet<VHostListener> localDomainsHandlers = new LinkedHashSet(10);
    private LinkedHashSet<VHostListener> nonLocalDomainsHandlers = new LinkedHashSet(10);
    private LinkedHashSet<VHostListener> nameSubdomainsHandlers = new LinkedHashSet(10);
    private ConcurrentSkipListSet<String> registeredComponentDomains = new ConcurrentSkipListSet();
    private ComponentRepository<VHostItem> repo = null;

    @Override
    public void addComponentDomain(String domain) {
        this.registeredComponentDomains.add(domain);
    }

    @Override
    public void componentAdded(VHostListener component) {
        component.setVHostManager(this);
        if (component.handlesLocalDomains()) {
            this.localDomainsHandlers.add(component);
        }
        if (component.handlesNonLocalDomains()) {
            this.nonLocalDomainsHandlers.add(component);
        }
        if (component.handlesNameSubdomains()) {
            this.nameSubdomainsHandlers.add(component);
        }
    }

    @Override
    public void componentRemoved(VHostListener component) {
        this.localDomainsHandlers.remove(component);
        this.nonLocalDomainsHandlers.remove(component);
        this.nameSubdomainsHandlers.remove(component);
    }

    @Override
    public ServerComponent[] getComponentsForLocalDomain(String domain) {
        ++this.getComponentsForLocalDomainCalls;
        VHostItem vhost = this.repo.getItem(domain);
        if (vhost == null) {
            int idx = domain.indexOf(46);
            if (idx > 0) {
                String name = domain.substring(0, idx);
                String basedomain = domain.substring(idx + 1);
                VHostListener listener = (VHostListener)this.components.get(name);
                if (listener != null && listener.handlesNameSubdomains() && this.isLocalDomain(basedomain)) {
                    return new ServerComponent[]{listener};
                }
            }
            return null;
        }
        LinkedHashSet<VHostListener> results = new LinkedHashSet<VHostListener>(10);
        results.addAll(this.localDomainsHandlers);
        if (results.size() > 0) {
            return results.toArray(new ServerComponent[results.size()]);
        }
        return null;
    }

    @Override
    public ServerComponent[] getComponentsForNonLocalDomain(String domain) {
        ++this.getComponentsForNonLocalDomainCalls;
        if (this.nonLocalDomainsHandlers.size() > 0) {
            return this.nonLocalDomainsHandlers.toArray(new ServerComponent[this.nonLocalDomainsHandlers.size()]);
        }
        return null;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        String repo_class = (String)params.get(VHOSTS_REPO_CLASS_PROPERTY);
        if (repo_class == null) {
            repo_class = VHOSTS_REPO_CLASS_PROP_VAL;
        }
        defs.put(VHOSTS_REPO_CLASS_PROP_KEY, repo_class);
        try {
            ComponentRepository repo_tmp = (ComponentRepository)Class.forName(repo_class).newInstance();
            repo_tmp.getDefaults(defs, params);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not instantiate VHosts repository for class: " + repo_class, e);
        }
        return defs;
    }

    @Override
    public String getDiscoCategoryType() {
        return this.identity_type;
    }

    @Override
    public String getDiscoDescription() {
        return "VHost Manager";
    }

    @Override
    public void getStatistics(StatisticsList list) {
        list.add(this.getName(), "Number of VHosts", this.repo.size(), Level.FINE);
        list.add(this.getName(), "Checks: is local domain", this.isLocalDomainCalls, Level.FINER);
        list.add(this.getName(), "Checks: is anonymous domain", this.isAnonymousEnabledCalls, Level.FINER);
        list.add(this.getName(), "Get components for local domain", this.getComponentsForLocalDomainCalls, Level.FINER);
        list.add(this.getName(), "Get components for non-local domain", this.getComponentsForNonLocalDomainCalls, Level.FINER);
    }

    @Override
    public VHostItem getVHostItem(String domain) {
        return this.repo.getItem(domain);
    }

    @Override
    public BareJID getDefVHostItem() {
        Iterator vhosts = this.repo.iterator();
        if (vhosts != null && vhosts.hasNext()) {
            return ((VHostItem)vhosts.next()).getVhost().getBareJID();
        }
        return this.getDefHostName();
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("comp_repo", (Object)this.repo);
    }

    @Override
    public boolean isAnonymousEnabled(String domain) {
        ++this.isAnonymousEnabledCalls;
        VHostItem vhost = this.repo.getItem(domain);
        if (vhost == null) {
            return false;
        }
        return vhost.isAnonymousEnabled();
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof VHostListener;
    }

    @Override
    public boolean isLocalDomain(String domain) {
        ++this.isLocalDomainCalls;
        return this.repo.contains(domain);
    }

    @Override
    public boolean isLocalDomainOrComponent(String domain) {
        int idx;
        boolean result = this.isLocalDomain(domain);
        if (!result) {
            result = this.registeredComponentDomains.contains(domain);
        }
        if (!result && (idx = domain.indexOf(46)) > 0) {
            String name = domain.substring(0, idx);
            String basedomain = domain.substring(idx + 1);
            VHostListener listener = (VHostListener)this.components.get(name);
            result = listener != null && listener.handlesNameSubdomains() && this.isLocalDomain(basedomain);
        }
        return result;
    }

    @Override
    public void removeComponentDomain(String domain) {
        this.registeredComponentDomains.remove(domain);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        super.setProperties(properties);
        String repo_class = (String)properties.get(VHOSTS_REPO_CLASS_PROP_KEY);
        if (repo_class != null) {
            try {
                ComponentRepository repo_tmp = (ComponentRepository)Class.forName(repo_class).newInstance();
                repo_tmp.setProperties(properties);
                this.repo = repo_tmp;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not create VHost repository instance for class: " + repo_class, e);
            }
        }
    }
}

