/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import tigase.stats.StatRecord;
import tigase.stats.StatisticType;
import tigase.stats.StatisticsCollector;
import tigase.stats.StatisticsList;
import tigase.stats.StatisticsProviderMBean;
import tigase.sys.TigaseRuntime;
import tigase.util.AllHistoryCache;
import tigase.util.FloatHistoryCache;
import tigase.util.IntHistoryCache;

public class StatisticsProvider
extends StandardMBean
implements StatisticsProviderMBean {
    private static final Logger log = Logger.getLogger(StatisticsProvider.class.getName());
    private StatisticsCache cache = null;
    private StatisticsCollector theRef;

    public StatisticsProvider(StatisticsCollector theRef, int historySize, long updateInterval) throws NotCompliantMBeanException {
        super(StatisticsProviderMBean.class, false);
        this.theRef = theRef;
        this.cache = new StatisticsCache(historySize, updateInterval);
    }

    @Override
    public Map<String, String> getAllStats(int level) {
        StatisticsList list = new StatisticsList(Level.parse("" + level));
        this.theRef.getAllStats(list);
        return this.getMapFromList(list);
    }

    @Override
    public int getCLIOQueueSize() {
        return this.cache.clIOQueue;
    }

    @Override
    public float[] getCLPacketsPerSecHistory() {
        return this.cache.clpacks_history != null ? this.cache.clpacks_history.getCurrentHistory() : null;
    }

    @Override
    public int getCLQueueSize() {
        return this.cache.clQueue;
    }

    @Override
    public float getCPUUsage() {
        return this.cache.cpuUsage;
    }

    @Override
    public float[] getCPUUsageHistory() {
        return this.cache.cpu_usage_history != null ? this.cache.cpu_usage_history.getCurrentHistory() : null;
    }

    @Override
    public int getCPUsNumber() {
        return TigaseRuntime.getTigaseRuntime().getCPUsNumber();
    }

    @Override
    public int getClusterCacheSize() {
        return this.cache.clusterCache;
    }

    @Override
    public float getClusterCompressionRatio() {
        return this.cache.clusterCompressionRatio;
    }

    @Override
    public long getClusterNetworkBytes() {
        return this.cache.clusterNetworkBytes;
    }

    @Override
    public float getClusterNetworkBytesPerSecond() {
        return this.cache.clusterNetworkBytesPerSecond;
    }

    @Override
    public long getClusterPackets() {
        return this.cache.clusterPackets;
    }

    @Override
    public float getClusterPacketsPerSec() {
        return this.cache.clusterPacketsPerSec;
    }

    public int getCompConnections(String comp) {
        return this.cache.allStats.getCompConnections(comp);
    }

    public long getCompIqs(String comp) {
        return this.cache.allStats.getCompIq(comp);
    }

    public long getCompMessages(String comp) {
        return this.cache.allStats.getCompMsg(comp);
    }

    public long getCompPackets(String comp) {
        return this.cache.allStats.getCompPackets(comp);
    }

    public long getCompPresences(String comp) {
        return this.cache.allStats.getCompPres(comp);
    }

    @Override
    public Map<String, String> getComponentStats(String compName, int level) {
        StatisticsList list = new StatisticsList(Level.parse("" + level));
        this.theRef.getComponentStats(compName, list);
        return this.getMapFromList(list);
    }

    @Override
    public List<String> getComponentsNames() {
        return this.theRef.getComponentsNames();
    }

    @Override
    public int getConnectionsNumber() {
        return this.cache.clientConnections;
    }

    @Override
    public int[] getConnectionsNumberHistory() {
        return this.cache.conns_history != null ? this.cache.conns_history.getCurrentHistory() : null;
    }

    @Override
    public float getHeapMemUsage() {
        return TigaseRuntime.getTigaseRuntime().getHeapMemUsage();
    }

    @Override
    public float[] getHeapUsageHistory() {
        return this.cache.heap_usage_history != null ? this.cache.heap_usage_history.getCurrentHistory() : null;
    }

    @Override
    public long getIQAuthNumber() {
        return this.cache.iqAuthNumber;
    }

    @Override
    public long getIQOtherNumber() {
        return this.cache.iqOtherNumber;
    }

    @Override
    public float getIQOtherNumberPerSec() {
        return this.cache.iqOtherNumberPerSec;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbinfo = super.getMBeanInfo();
        return new MBeanInfo(mbinfo.getClassName(), mbinfo.getDescription(), mbinfo.getAttributes(), mbinfo.getConstructors(), mbinfo.getOperations(), this.getNotificationInfo());
    }

    @Override
    public long getMessagesNumber() {
        return this.cache.messagesNumber;
    }

    @Override
    public float getMessagesNumberPerSec() {
        return this.cache.messagesPerSec;
    }

    @Override
    public String getName() {
        return this.theRef.getName();
    }

    @Override
    public float getNonHeapMemUsage() {
        return TigaseRuntime.getTigaseRuntime().getNonHeapMemUsage();
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    public long getPresencesNumber() {
        return this.cache.presencesNumber;
    }

    @Override
    public float getPresencesNumberPerSec() {
        return this.cache.presencesPerSec;
    }

    @Override
    public long getProcesCPUTime() {
        return TigaseRuntime.getTigaseRuntime().getProcessCPUTime();
    }

    @Override
    public long getQueueOverflow() {
        return this.cache.queueOverflow;
    }

    @Override
    public int getQueueSize() {
        return this.cache.queueSize;
    }

    public long getRegistered() {
        return this.cache.registered;
    }

    @Override
    public long getSMPacketsNumber() {
        return this.cache.smPackets;
    }

    @Override
    public float getSMPacketsNumberPerSec() {
        return this.cache.smPacketsPerSec;
    }

    @Override
    public float[] getSMPacketsPerSecHistory() {
        return this.cache.smpacks_history != null ? this.cache.smpacks_history.getCurrentHistory() : null;
    }

    @Override
    public int getSMQueueSize() {
        return this.cache.smQueue;
    }

    @Override
    public int getServerConnections() {
        return this.cache.serverConnections;
    }

    @Override
    public int[] getServerConnectionsHistory() {
        return this.cache.server_conns_history != null ? this.cache.server_conns_history.getCurrentHistory() : null;
    }

    public long getStats(String cmp_name, String stat, long def) {
        return this.cache.allStats.getValue(cmp_name, stat, def);
    }

    public float getStats(String cmp_name, String stat, float def) {
        return this.cache.allStats.getValue(cmp_name, stat, def);
    }

    public String getStats(String cmp_name, String stat, String def) {
        return this.cache.allStats.getValue(cmp_name, stat, def);
    }

    public int getStats(String cmp_name, String stat, int def) {
        return this.cache.allStats.getValue(cmp_name, stat, def);
    }

    @Override
    public String getSystemDetails() {
        return this.cache.systemDetails;
    }

    @Override
    public long getUptime() {
        return TigaseRuntime.getTigaseRuntime().getUptime();
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "Provides the Tigase server statistics";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String description = null;
        if (info.getName().equals("AllStats")) {
            description = "Collection of statistics from all components.";
        } else if (info.getName().equals("ComponentsNames")) {
            description = "List of components names for which statistics are available";
        } else if (info.getName().equals("Name")) {
            description = "This is a component name - name of the statistics collector component,";
        } else if (info.getName().equals("getUptime")) {
            description = "Returns JVM uptime.";
        } else if (info.getName().equals("getProcesCPUTime")) {
            description = "Returns JMV process CPU time.";
        }
        return description;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (op.getName().equals("getAllStats")) {
            switch (sequence) {
                case 0: {
                    return "Statistics level, 0 - All, 500 - Medium, 800 - Minimal";
                }
            }
            return null;
        }
        if (op.getName().equals("getComponentStats")) {
            switch (sequence) {
                case 0: {
                    return "The component name to provide statistics for";
                }
                case 1: {
                    return "Statistics level, 0 - All, 500 - Medium, 800 - Minimal";
                }
            }
            return null;
        }
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String description = null;
        MBeanParameterInfo[] params = info.getSignature();
        Object[] signature = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            signature[i] = params[i].getType();
        }
        Object[] methodSignature = new String[]{Integer.TYPE.getName()};
        if (info.getName().equals("getAllStats") && Arrays.equals(signature, methodSignature)) {
            description = "Provides statistics for all components for a given level.";
        }
        methodSignature = new String[]{String.class.getName(), Integer.TYPE.getName()};
        if (info.getName().equals("getComponentStats") && Arrays.equals(signature, methodSignature)) {
            description = "Provides statistics for a given component name and statistics level.";
        }
        return description;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        if (op.getName().equals("getAllStats")) {
            switch (sequence) {
                case 0: {
                    return "level";
                }
            }
            return null;
        }
        if (op.getName().equals("getComponentStats")) {
            switch (sequence) {
                case 0: {
                    return "compName";
                }
                case 1: {
                    return "level";
                }
            }
            return null;
        }
        return null;
    }

    private Map<String, String> getMapFromList(StatisticsList list) {
        if (list != null) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(300);
            for (StatRecord rec : list) {
                String key = rec.getComponent() + "/" + rec.getDescription();
                String value = rec.getValue();
                if (rec.getType() == StatisticType.LIST) {
                    value = rec.getListValue().toString();
                }
                result.put(key, value);
            }
            return result;
        }
        return null;
    }

    @Override
    public Map<String, LinkedList<Object>> getStatsHistory(String[] statsKeys) {
        log.log(Level.INFO, "Generating history for metrics: {0}", Arrays.toString(statsKeys));
        LinkedHashMap<String, LinkedList<Object>> result = null;
        if (this.cache.allHistory != null) {
            result = new LinkedHashMap<String, LinkedList<Object>>();
            for (StatisticsList stHist : this.cache.allHistory.getCurrentHistory()) {
                for (String key : statsKeys) {
                    LinkedList<Object> statsForKey = (LinkedList<Object>)result.get(key);
                    if (statsForKey == null) {
                        statsForKey = new LinkedList<Object>();
                        result.put(key, statsForKey);
                    }
                    statsForKey.add(stHist.getValue(key));
                }
            }
        } else {
            log.log(Level.INFO, "The server does not keep metrics history.");
        }
        return result;
    }

    @Override
    public Map<String, Object> getCurStats(String[] statsKeys) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String key : statsKeys) {
            result.put(key, this.cache.allStats.getValue(key));
        }
        return result;
    }

    private class StatisticsCache {
        private static final String BOSH_COMP = "bosh";
        private static final String C2S_COMP = "c2s";
        private static final String S2S_COMP = "s2s";
        private static final String CL_COMP = "cl-comp";
        private static final int HISTORY_SIZE = 30;
        private static final long SECOND = 1000L;
        private static final String SM_COMP = "sess-man";
        private static final long MINUTE = 60000L;
        private static final long HOUR = 3600000L;
        private int clIOQueue = 0;
        private int clQueue = 0;
        private int clientConnections = 0;
        private int clusterCache = 0;
        private float clusterCompressionRatio = 0.0f;
        private long clusterNetworkBytes = 0L;
        private float clusterNetworkBytesPerSecond = 0.0f;
        private long clusterNetworkBytesReceived = 0L;
        private long clusterNetworkBytesSent = 0L;
        private long clusterPackets = 0L;
        private float clusterPacketsPerSec = 0.0f;
        private long clusterPacketsReceived = 0L;
        private long clusterPacketsSent = 0L;
        private int cnt = 0;
        private float cpuUsage = 0.0f;
        private int inter = 10;
        private long iqAuthNumber = 0L;
        private long iqOtherNumber = 0L;
        private float iqOtherNumberPerSec = 0.0f;
        private String largeQueues = "";
        private long lastPresencesReceived = 0L;
        private long lastPresencesSent = 0L;
        private long messagesNumber = 0L;
        private float messagesPerSec = 0.0f;
        private long presencesNumber = 0L;
        private float presencesPerSec = 0.0f;
        private long presences_received_per_update = 0L;
        private long presences_sent_per_update = 0L;
        private long prevClusterNetworkBytes = 0L;
        private float prevClusterNetworkBytesPerSecond = 0.0f;
        private long prevClusterPackets = 0L;
        private float prevClusterPacketsPerSec = 0.0f;
        private float prevCpuUsage = 0.0f;
        private float prevIqOtherNumberPerSec = 0.0f;
        private long prevMessagesNumber = 0L;
        private float prevMessagesPerSec = 0.0f;
        private long prevPresencesNumber = 0L;
        private float prevPresencesPerSec = 0.0f;
        private long prevSmPackets = 0L;
        private float prevSmPacketsPerSec = 0.0f;
        private long queueOverflow = 0L;
        private int queueSize = 0;
        private long registered = 0L;
        private int runs_counter = 100;
        private int serverConnections = 0;
        private long smPackets = 0L;
        private float smPacketsPerSec = 0.0f;
        private int smQueue = 0;
        private String systemDetails = "";
        private Timer updateTimer = null;
        private FloatHistoryCache smpacks_history = null;
        private IntHistoryCache server_conns_history = null;
        private FloatHistoryCache heap_usage_history = null;
        private FloatHistoryCache cpu_usage_history = null;
        private IntHistoryCache conns_history = null;
        private FloatHistoryCache clpacks_history = null;
        private AllHistoryCache allHistory = null;
        private StatisticsList allStats = new StatisticsList(Level.FINER);

        private StatisticsCache(int historySize, long cacheUpdate) {
            if (historySize > 0) {
                this.smpacks_history = new FloatHistoryCache(historySize);
                this.server_conns_history = new IntHistoryCache(historySize);
                this.heap_usage_history = new FloatHistoryCache(historySize);
                this.cpu_usage_history = new FloatHistoryCache(historySize);
                this.conns_history = new IntHistoryCache(historySize);
                this.clpacks_history = new FloatHistoryCache(historySize);
                this.allHistory = new AllHistoryCache(historySize);
            }
            this.updateTimer = new Timer("stats-cache", true);
            this.updateTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        StatisticsCache.this.update();
                        StatisticsCache.this.updateSystemDetails();
                        StatisticsProvider.this.theRef.statsUpdated();
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Problem retrieving statistics: ", e);
                    }
                }
            }, 10000L, cacheUpdate * 1000L);
        }

        private void update() {
            long tmp_reg;
            float temp = this.cpuUsage;
            this.cpuUsage = (this.prevCpuUsage + temp * 2.0f + TigaseRuntime.getTigaseRuntime().getCPUUsage()) / 4.0f;
            if (this.cpu_usage_history != null) {
                this.cpu_usage_history.addItem(this.cpuUsage);
            }
            this.prevCpuUsage = temp;
            if (this.heap_usage_history != null) {
                this.heap_usage_history.addItem(StatisticsProvider.this.getHeapMemUsage());
            }
            if (++this.runs_counter >= 100) {
                this.allStats = new StatisticsList(Level.FINEST);
                this.runs_counter = 0;
            } else {
                this.allStats = new StatisticsList(Level.FINER);
            }
            StatisticsProvider.this.theRef.getAllStats(this.allStats);
            if (this.allHistory != null) {
                this.allHistory.addItem(this.allStats);
            }
            if ((tmp_reg = this.allStats.getValue(SM_COMP, "Registered accounts", -1L)) > 0L) {
                this.registered = tmp_reg;
            }
            this.clusterCompressionRatio = (this.allStats.getValue(CL_COMP, "Average compression ratio", -1.0f) + this.allStats.getValue(CL_COMP, "Average decompression ratio", -1.0f)) / 2.0f;
            this.clusterPacketsReceived = this.allStats.getCompReceivedPackets(CL_COMP);
            this.clusterPacketsSent = this.allStats.getCompSentPackets(CL_COMP);
            this.clusterPackets = this.clusterPacketsSent + this.clusterPacketsReceived;
            temp = this.clusterPacketsPerSec;
            this.clusterPacketsPerSec = (this.prevClusterPacketsPerSec + temp * 2.0f + (float)(this.clusterPackets - this.prevClusterPackets)) / 4.0f;
            if (this.clpacks_history != null) {
                this.clpacks_history.addItem(this.clusterPacketsPerSec);
            }
            this.prevClusterPacketsPerSec = temp;
            this.prevClusterPackets = this.clusterPackets;
            this.smPackets = this.allStats.getCompPackets(SM_COMP);
            temp = this.smPacketsPerSec;
            this.smPacketsPerSec = (this.prevSmPacketsPerSec + temp * 2.0f + (float)(this.smPackets - this.prevSmPackets)) / 4.0f;
            if (this.smpacks_history != null) {
                this.smpacks_history.addItem(this.smPacketsPerSec);
            }
            this.prevSmPacketsPerSec = temp;
            this.prevSmPackets = this.smPackets;
            this.clientConnections = this.allStats.getCompConnections(C2S_COMP) + this.allStats.getCompConnections(BOSH_COMP);
            if (this.conns_history != null) {
                this.conns_history.addItem(this.clientConnections);
            }
            this.serverConnections = this.allStats.getCompConnections(S2S_COMP);
            if (this.server_conns_history != null) {
                this.server_conns_history.addItem(this.serverConnections);
            }
            this.clIOQueue = this.allStats.getValue(CL_COMP, "Waiting to send", 0);
            this.clusterCache = this.allStats.getValue("cl-caching-strat", "Cached JIDs", 0);
            this.messagesNumber = this.allStats.getCompMsg(SM_COMP);
            temp = this.messagesPerSec;
            this.messagesPerSec = (this.prevMessagesPerSec + temp * 2.0f + (float)(this.messagesNumber - this.prevMessagesNumber)) / 4.0f;
            this.prevMessagesPerSec = temp;
            this.prevMessagesNumber = this.messagesNumber;
            this.clusterNetworkBytesSent = this.allStats.getValue(CL_COMP, "Bytes sent", 0L);
            this.clusterNetworkBytesReceived = this.allStats.getValue(CL_COMP, "Bytes received", 0L);
            this.clusterNetworkBytes = this.clusterNetworkBytesSent + this.clusterNetworkBytesReceived;
            temp = this.clusterNetworkBytesPerSecond;
            this.clusterNetworkBytesPerSecond = (this.prevClusterNetworkBytesPerSecond + temp * 2.0f + (float)(this.clusterNetworkBytes - this.prevClusterNetworkBytes)) / 4.0f;
            this.prevClusterNetworkBytesPerSecond = temp;
            this.prevClusterNetworkBytes = this.clusterNetworkBytes;
            long currPresencesReceived = this.allStats.getCompPresReceived(SM_COMP);
            long currPresencesSent = this.allStats.getCompPresSent(SM_COMP);
            this.presencesNumber = currPresencesReceived + currPresencesSent;
            temp = this.presencesPerSec;
            this.presencesPerSec = (this.prevPresencesPerSec + temp * 2.0f + (float)(this.presencesNumber - this.prevPresencesNumber)) / 4.0f;
            this.prevPresencesPerSec = temp;
            this.prevPresencesNumber = this.presencesNumber;
            if (++this.cnt >= this.inter) {
                this.presences_sent_per_update = (currPresencesSent - this.lastPresencesSent) / 10L;
                this.presences_received_per_update = (currPresencesReceived - this.lastPresencesReceived) / 10L;
                this.lastPresencesSent = currPresencesSent;
                this.lastPresencesReceived = currPresencesReceived;
                this.cnt = 0;
            }
            this.queueSize = 0;
            this.queueOverflow = 0L;
            this.smQueue = 0;
            this.clQueue = 0;
            this.largeQueues = "";
            for (StatRecord rec : this.allStats) {
                if (rec.getDescription() == StatisticType.IN_QUEUE_OVERFLOW.getDescription() || rec.getDescription() == StatisticType.OUT_QUEUE_OVERFLOW.getDescription()) {
                    this.queueOverflow += rec.getLongValue();
                }
                if (rec.getDescription() != "Total In queues wait" && rec.getDescription() != "Total Out queues wait") continue;
                this.queueSize += rec.getIntValue();
                if (rec.getComponent().equals(SM_COMP)) {
                    this.smQueue += rec.getIntValue();
                }
                if (rec.getComponent().equals(CL_COMP)) {
                    this.clQueue += rec.getIntValue();
                }
                if (rec.getIntValue() <= 10000) continue;
                this.largeQueues = this.largeQueues + rec.getComponent() + " - queue size: " + rec.getIntValue() + "\n";
            }
        }

        private void updateSystemDetails() {
            LinkedHashMap<String, StatRecord> compStats;
            String cpu_throt;
            String cpu_freq;
            StringBuilder sb = new StringBuilder();
            sb.append("Uptime: ").append(TigaseRuntime.getTigaseRuntime().getUptimeString());
            int cpu_temp = this.allStats.getValue("cpu-mon", "CPU temp", 0);
            if (cpu_temp > 0) {
                sb.append(",      Temp: ").append(cpu_temp).append(" C");
            }
            if ((cpu_freq = this.allStats.getValue("cpu-mon", "CPU freq", null)) != null) {
                sb.append("\nFreq: ").append(cpu_freq);
            }
            if ((cpu_throt = this.allStats.getValue("cpu-mon", "CPU throt", null)) != null) {
                sb.append("\nThrott: ").append(cpu_throt);
            }
            sb.append("\nTop threads:");
            String cpu_thread = this.allStats.getValue("cpu-mon", "1st max CPU thread", null);
            if (cpu_thread != null) {
                sb.append("\n   ").append(cpu_thread);
            }
            if ((cpu_thread = this.allStats.getValue("cpu-mon", "2nd max CPU thread", null)) != null) {
                sb.append("\n   ").append(cpu_thread);
            }
            if ((cpu_thread = this.allStats.getValue("cpu-mon", "3rd max CPU thread", null)) != null) {
                sb.append("\n   ").append(cpu_thread);
            }
            if ((cpu_thread = this.allStats.getValue("cpu-mon", "4th max CPU thread", null)) != null) {
                sb.append("\n   ").append(cpu_thread);
            }
            if ((cpu_thread = this.allStats.getValue("cpu-mon", "5th max CPU thread", null)) != null) {
                sb.append("\n   ").append(cpu_thread);
            }
            if ((compStats = this.allStats.getCompStats(SM_COMP)) != null) {
                for (StatRecord rec : compStats.values()) {
                    if (!rec.getDescription().startsWith("Processor:")) continue;
                    sb.append("\n").append(rec.getDescription()).append(rec.getValue());
                }
            }
            sb.append("\nSM presences rec Tot: ").append(this.lastPresencesReceived);
            sb.append(" / ").append(this.presences_received_per_update).append(" last sec");
            sb.append("\nSM presences sent Tot: ").append(this.lastPresencesSent);
            sb.append(" / ").append(this.presences_sent_per_update).append(" last sec");
            sb.append("\nCluster bytes/sec: ").append(this.clusterNetworkBytesPerSecond);
            sb.append(", compress: ").append(this.clusterCompressionRatio);
            sb.append("\nCluster bytes: [S] ").append(this.clusterNetworkBytesSent);
            sb.append(" / [R] ").append(this.clusterNetworkBytesReceived);
            sb.append("\nCluster packets: [S] ").append(this.clusterPacketsSent);
            sb.append(" / [R] ").append(this.clusterPacketsReceived);
            if (!this.largeQueues.isEmpty()) {
                sb.append("\n").append(this.largeQueues);
            }
            this.systemDetails = sb.toString();
        }
    }
}

