/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.server.bosh.BoshIOService;
import tigase.server.bosh.BoshSession;
import tigase.server.bosh.BoshSessionTaskHandler;
import tigase.server.bosh.BoshTask;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.stats.StatisticsList;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPIOService;

public class BoshConnectionManager
extends ClientConnectionManager
implements BoshSessionTaskHandler {
    private static final Logger log = Logger.getLogger("tigase.server.bosh.BoshConnectionManager");
    private static final int DEF_PORT_NO = 5280;
    private int[] PORTS = new int[]{5280};
    private long max_wait = 30L;
    private long min_polling = 10L;
    private long max_pause = 10L;
    private long max_inactivity = 10L;
    private int hold_requests = 1;
    private int concurrent_requests = 2;
    private ReceiverTimeoutHandler stoppedHandler = this.newStoppedHandler();
    private ReceiverTimeoutHandler startedHandler = this.newStartedHandler();
    protected final Map<UUID, BoshSession> sessions = new ConcurrentSkipListMap<UUID, BoshSession>();

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet.toString());
        }
        super.processPacket(packet);
    }

    @Override
    public boolean addOutStreamClosed(Packet packet, BoshSession bs) {
        packet.setPacketFrom(this.getFromAddress(bs.getSid().toString()));
        packet.setPacketTo(bs.getDataReceiver());
        packet.initVars(packet.getPacketFrom(), packet.getPacketTo());
        bs.close();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("closing BOSH session with sid = " + bs.getSid().toString());
        }
        this.sessions.remove(bs.getSid());
        return this.addOutPacketWithTimeout(packet, this.stoppedHandler, 15L, TimeUnit.SECONDS);
    }

    @Override
    public boolean addOutStreamOpen(Packet packet, BoshSession bs) {
        packet.initVars(this.getFromAddress(bs.getSid().toString()), bs.getDataReceiver());
        return this.addOutPacketWithTimeout(packet, this.startedHandler, 15L, TimeUnit.SECONDS);
    }

    @Override
    public void cancelTask(BoshTask tt) {
        tt.cancel();
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        props.put("max-wait", 30L);
        props.put("min-polling", 10L);
        props.put("max-inactivity", 10L);
        props.put("concurrent-requests", 2);
        props.put("hold-requests", 1);
        props.put("max-inactivity", 10L);
        return props;
    }

    @Override
    public String getDiscoCategoryType() {
        return "c2s";
    }

    @Override
    public String getDiscoDescription() {
        return "Bosh connection manager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue<Packet> processSocketData(XMPPIOService<Object> srv) {
        BoshIOService serv = (BoshIOService)srv;
        Packet p = null;
        while ((p = serv.getReceivedPackets().poll()) != null) {
            ArrayDeque<Packet> out_results = new ArrayDeque<Packet>(2);
            BoshSession bs = null;
            String sid_str = null;
            Object object = this.sessions;
            synchronized (object) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Processing packet: {0}, type: {1}", new Object[]{p.getElemName(), p.getType()});
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Processing socket data: {0}", p);
                }
                sid_str = p.getAttribute("sid");
                UUID sid = null;
                if (sid_str == null) {
                    String hostname = p.getAttribute("to");
                    if (hostname != null && this.isLocalDomain(hostname)) {
                        bs = new BoshSession(this.getDefVHostItem().getDomain(), JID.jidInstanceNS((String)this.routings.computeRouting(hostname)), this);
                        sid = bs.getSid();
                        this.sessions.put(sid, bs);
                    } else {
                        log.info("Invalid hostname. Closing invalid connection");
                        try {
                            serv.sendErrorAndStop(Authorization.NOT_ALLOWED, p, "Invalid hostname.");
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, "Problem sending invalid hostname error for sid =  " + sid, e);
                        }
                    }
                } else {
                    sid = UUID.fromString(sid_str);
                    bs = this.sessions.get(sid);
                }
            }
            try {
                if (bs != null) {
                    object = bs;
                    synchronized (object) {
                        if (sid_str == null) {
                            bs.init(p, serv, this.max_wait, this.min_polling, this.max_inactivity, this.concurrent_requests, this.hold_requests, this.max_pause, out_results);
                        } else {
                            bs.processSocketPacket(p, serv, out_results);
                        }
                    }
                } else {
                    log.info("There is no session with given SID. Closing invalid connection");
                    serv.sendErrorAndStop(Authorization.ITEM_NOT_FOUND, p, "Invalid SID");
                }
                this.addOutPackets(out_results, bs);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Problem processing socket data for sid =  " + sid_str, e);
            }
        }
        return null;
    }

    @Override
    public BoshTask scheduleTask(BoshSession bs, long delay) {
        BoshTask bt = new BoshTask(bs, this);
        this.addTimerTask(bt, delay);
        return bt;
    }

    @Override
    public void serviceStarted(BoshIOService service) {
        super.serviceStarted(service);
    }

    public void serviceStopped(BoshIOService service) {
        BoshSession bs;
        super.serviceStopped(service);
        UUID sid = service.getSid();
        if (sid != null && (bs = this.sessions.get(sid)) != null) {
            bs.disconnected(service);
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.get("max-wait") != null) {
            this.max_wait = (Long)props.get("max-wait");
            log.info("Setting max_wait to: " + this.max_wait);
        }
        if (props.get("min-polling") != null) {
            this.min_polling = (Long)props.get("min-polling");
            log.info("Setting min_polling to: " + this.min_polling);
        }
        if (props.get("max-inactivity") != null) {
            this.max_inactivity = (Long)props.get("max-inactivity");
            log.info("Setting max_inactivity to: " + this.max_inactivity);
        }
        if (props.get("concurrent-requests") != null) {
            this.concurrent_requests = (Integer)props.get("concurrent-requests");
            log.info("Setting concurrent_requests to: " + this.concurrent_requests);
        }
        if (props.get("hold-requests") != null) {
            this.hold_requests = (Integer)props.get("hold-requests");
            log.info("Setting hold_requests to: " + this.hold_requests);
        }
        if (props.get("max-inactivity") != null) {
            this.max_pause = (Long)props.get("max-inactivity");
            log.info("Setting max_pause to: " + this.max_pause);
        }
    }

    @Override
    public void writeRawData(BoshIOService ios, String data) {
        super.writeRawData(ios, data);
    }

    @Override
    public void xmppStreamClosed(BoshIOService serv) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Stream closed.");
        }
    }

    @Override
    public String xmppStreamOpened(BoshIOService serv, Map<String, String> attribs) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ups, what just happened? Stream open. Hey, this is a Bosh connection manager. c2s and s2s are not supported on the same port as Bosh yet.");
        }
        return "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='1' from='" + this.getDefVHostItem() + "'" + " version='1.0' xml:lang='en'>" + "<stream:error>" + "<invalid-namespace xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>" + "<text xmlns='urn:ietf:params:xml:ns:xmpp-streams' xml:lang='langcode'>" + "Ups, what just happened? Stream open. Hey, this is a Bosh connection manager. " + "c2s and s2s are not supported on the same port... yet." + "</text>" + "</stream:error>" + "</stream:stream>";
    }

    @Override
    public BareJID getSeeOtherHostForJID(BareJID fromJID) {
        if (this.see_other_host_strategy == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("no see-other-host implementation set");
            }
            return null;
        }
        BareJID see_other_host = this.see_other_host_strategy.findHostForJID(fromJID, this.getDefHostName());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("using = " + this.see_other_host_strategy.getClass().getCanonicalName() + "for jid = " + fromJID.toString() + " got = " + (see_other_host != null ? see_other_host.toString() : "null"));
        }
        return see_other_host != null && !see_other_host.equals((Object)this.getDefHostName()) ? see_other_host : null;
    }

    @Override
    protected JID changeDataReceiver(Packet packet, JID newAddress, String command_sessionId, XMPPIOService<Object> serv) {
        BoshSession session = this.getBoshSession(packet.getTo());
        if (session != null) {
            String sessionId = session.getSessionId();
            if (sessionId.equals(command_sessionId)) {
                JID old_receiver = session.getDataReceiver();
                session.setDataReceiver(newAddress);
                return old_receiver;
            }
            log.info("Incorrect session ID, ignoring data redirect for: " + newAddress);
        }
        return null;
    }

    protected BoshSession getBoshSession(JID jid) {
        UUID sid = UUID.fromString(jid.getResource());
        return this.sessions.get(sid);
    }

    @Override
    protected int[] getDefPlainPorts() {
        return this.PORTS;
    }

    @Override
    protected int[] getDefSSLPorts() {
        return null;
    }

    @Override
    protected long getMaxInactiveTime() {
        return 600000L;
    }

    @Override
    protected BoshIOService getXMPPIOServiceInstance() {
        return new BoshIOService();
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        if (list.checkLevel(Level.FINEST)) {
            list.add(this.getName(), "Bosh sessions", this.sessions.size(), Level.FINEST);
        }
    }

    @Override
    protected ReceiverTimeoutHandler newStartedHandler() {
        return new StartedHandler();
    }

    @Override
    protected void processCommand(Packet packet) {
        BoshSession session = this.getBoshSession(packet.getTo());
        switch (packet.getCommand()) {
            case CLOSE: {
                if (session != null) {
                    log.log(Level.FINE, "Terminating session for command CLOSE: {0}", session.getSid());
                    session.terminateBoshSession();
                    break;
                }
                log.log(Level.INFO, "Session does not exist for packet: {0}", packet);
                break;
            }
            case CHECK_USER_CONNECTION: {
                if (session != null) {
                    this.addOutPacket(packet.okResult((String)null, 0));
                    break;
                }
                try {
                    this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Connection gone.", false));
                }
                catch (PacketErrorTypeException e) {
                    log.log(Level.INFO, "Error packet is not really expected here: {0}", packet);
                }
                break;
            }
            default: {
                super.processCommand(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean writePacketToSocket(Packet packet) {
        BoshSession session = this.getBoshSession(packet.getTo());
        if (session != null) {
            BoshSession boshSession = session;
            synchronized (boshSession) {
                ArrayDeque<Packet> out_results = new ArrayDeque<Packet>();
                session.processPacket(packet, out_results);
                this.addOutPackets(out_results, session);
            }
            return true;
        }
        log.info("Session does not exist for packet: " + packet.toString());
        return false;
    }

    protected void addOutPackets(Queue<Packet> out_results, BoshSession bs) {
        for (Packet res : out_results) {
            res.setPacketFrom(this.getFromAddress(bs.getSid().toString()));
            res.setPacketTo(bs.getDataReceiver());
            if (res.getCommand() != null) {
                switch (res.getCommand()) {
                    case STREAM_CLOSED: 
                    case GETFEATURES: {
                        res.initVars(res.getPacketFrom(), res.getPacketTo());
                        break;
                    }
                }
            }
            this.addOutPacket(res);
        }
        out_results.clear();
    }

    private JID getFromAddress(String id) {
        return JID.jidInstanceNS((String)this.getName(), (String)this.getDefHostName().getDomain(), (String)id);
    }

    private class StartedHandler
    implements ReceiverTimeoutHandler {
        private StartedHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            BoshConnectionManager.this.addOutPacket(Command.GETFEATURES.getPacket(packet.getFrom(), packet.getTo(), StanzaType.get, UUID.randomUUID().toString(), null));
        }

        @Override
        public void timeOutExpired(Packet packet) {
            log.warning("No response within time limit received for a packet: " + packet.toString());
            BoshSession session = BoshConnectionManager.this.getBoshSession(packet.getFrom());
            if (session != null) {
                log.fine("Closing session for timeout: " + session.getSid());
                session.close();
                BoshConnectionManager.this.sessions.remove(session.getSid());
            } else {
                log.info("Session does not exist for packet: " + packet.toString());
            }
        }
    }
}

