/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp.cond;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.amp.ConditionIfc;
import tigase.xml.Element;

public class ExpireAt
implements ConditionIfc {
    private static Logger log = Logger.getLogger(ExpireAt.class.getName());
    public static final String NAME = "expire-at";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean match(Packet packet, Element rule) {
        String value = rule.getAttribute("value");
        if (value != null) {
            try {
                Date val_date = null;
                SimpleDateFormat simpleDateFormat = this.formatter;
                synchronized (simpleDateFormat) {
                    val_date = this.formatter.parse(value);
                }
                return val_date.before(new Date());
            }
            catch (ParseException ex) {
                log.info("Incorrect expire-at condition value for rule: " + rule);
            }
        } else {
            log.info("No value set for rule: " + rule);
        }
        return false;
    }
}

