/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp;

import java.security.NoSuchAlgorithmException;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DataRepository;
import tigase.db.MsgRepositoryIfc;
import tigase.db.RepositoryFactory;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.util.Algorithms;
import tigase.util.SimpleCache;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class MsgRepository
implements MsgRepositoryIfc {
    private static final Logger log = Logger.getLogger(MsgRepository.class.getName());
    private static final String MSG_TABLE = "msg_history";
    private static final String MSG_ID_COLUMN = "msg_id";
    private static final String MSG_TIMESTAMP_COLUMN = "ts";
    private static final String MSG_EXPIRED_COLUMN = "expired";
    private static final String MSG_FROM_UID_COLUMN = "sender_uid";
    private static final String MSG_TO_UID_COLUMN = "receiver_uid";
    private static final String MSG_BODY_COLUMN = "message";
    private static final String HISTORY_FLAG_COLUMN = "history_enabled";
    private static final String JID_TABLE = "user_jid";
    private static final String JID_ID_COLUMN = "jid_id";
    private static final String JID_SHA_COLUMN = "jid_sha";
    private static final String JID_COLUMN = "jid";
    private static final String MYSQL_CREATE_MSG_TABLE = "create table msg_history (   msg_id serial,  ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP,  expired DATETIME,  sender_uid bigint unsigned,  receiver_uid bigint unsigned NOT NULL,  message varchar(4096) NOT NULL,   key (expired),  key (sender_uid, receiver_uid), key (receiver_uid, sender_uid))";
    private static final String PGSQL_CREATE_MSG_TABLE = "create table msg_history (   msg_id serial,  ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP,  expired TIMESTAMP,  sender_uid bigint,  receiver_uid bigint NOT NULL,  message varchar(4096) NOT NULL);create index index_expired on msg_history (expired);create index index_sender_uid_receiver_uid on msg_history(sender_uid,receiver_uid);create index index_receiver_uid_receiver_uid on msg_history(sender_uid,receiver_uid);";
    private static final String DERBY_CREATE_MSG_TABLE = "create table msg_history (   msg_id bigint generated by default as identity not null,  ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP,  expired TIMESTAMP,  sender_uid bigint,  receiver_uid bigint NOT NULL,  message varchar(4096) NOT NULL);create index index_expired on msg_history (expired);create index index_sender_uid_receiver_uid on msg_history(sender_uid,receiver_uid);create index index_receiver_uid_receiver_uid on msg_history(sender_uid,receiver_uid);";
    private static final String MYSQL_CREATE_JID_TABLE = "create table user_jid (   jid_id serial,  jid_sha char(128) NOT NULL,  jid varchar(2049) NOT NULL,  history_enabled int default 0, primary key (jid_id), unique key jid_sha (jid_sha), key jid (jid(765)))";
    private static final String PGSQL_CREATE_JID_TABLE = "create table user_jid (   jid_id serial,  jid_sha char(128) NOT NULL,  jid varchar(2049) NOT NULL,  history_enabled int default 0, primary key (jid_id)); create unique index index_jid_sha on user_jid (jid_sha); create unique index index_jid on user_jid (jid); ";
    private static final String DERBY_CREATE_JID_TABLE = "create table user_jid (   jid_id bigint generated by default as identity not null,  jid_sha char(128) NOT NULL,  jid varchar(2049) NOT NULL,  history_enabled int default 0, primary key (jid_id)); create unique index index_jid_sha on user_jid (jid_sha); create unique index index_jid on user_jid (jid); ";
    private static final String MSG_INSERT_QUERY = "insert into msg_history ( expired, sender_uid, receiver_uid, message) values (?, ?, ?, ?)";
    private static final String MSG_SELECT_TO_JID_QUERY = "select * from msg_history where receiver_uid = ?";
    private static final String MSG_DELETE_TO_JID_QUERY = "delete from msg_history where receiver_uid = ?";
    private static final String MSG_DELETE_ID_QUERY = "delete from msg_history where msg_id = ?";
    private static final String MSG_SELECT_EXPIRED_QUERY = "select * from msg_history where expired is not null order by expired";
    private static final String MSG_SELECT_EXPIRED_BEFORE_QUERY = "select * from msg_history where expired is not null and expired <= ? order by expired";
    private static final String GET_USER_UID_DEF_QUERY = "select jid_id, jid from user_jid where jid_sha = ?";
    private static final String MSG_COUNT_FOR_TO_AND_FROM_QUERY_DEF = "select count(*) from msg_history where receiver_uid = ? and sender_uid = ?";
    private static final String ADD_USER_JID_ID_QUERY = "insert into user_jid ( jid_sha, jid) values (?, ?)";
    private static final String GET_USER_UID_PROP_KEY = "user-uid-query";
    private static final String MSGS_STORE_LIMIT_KEY = "store-limit";
    private static final String MSGS_COUNT_LIMIT_PROP_KEY = "count-limit-query";
    private static final long MSGS_STORE_LIMIT_VAL = 100L;
    private static final int MAX_UID_CACHE_SIZE = 100000;
    private static final long MAX_UID_CACHE_TIME = 3600000L;
    private static final Map<String, MsgRepository> repos = new ConcurrentSkipListMap<String, MsgRepository>();
    private static final int MAX_QUEUE_SIZE = 1000;
    private DataRepository data_repo = null;
    private long earliestOffline = Long.MAX_VALUE;
    private SimpleParser parser = SingletonFactory.getParserInstance();
    private String uid_query = "select jid_id, jid from user_jid where jid_sha = ?";
    private String msg_count_for_limit_query = "select count(*) from msg_history where receiver_uid = ? and sender_uid = ?";
    private long msgs_store_limit = 100L;
    private boolean initialized = false;
    private Map<BareJID, Long> uids_cache = Collections.synchronizedMap(new SimpleCache(100000, 3600000L));
    private DelayQueue<MsgDBItem> expiredQueue = new DelayQueue();

    public static MsgRepository getInstance(String id_string) {
        MsgRepository result = repos.get(id_string);
        if (result == null) {
            result = new MsgRepository();
            repos.put(id_string, result);
        }
        return result;
    }

    @Override
    public Element getMessageExpired(long time, boolean delete) {
        MsgDBItem item;
        if (this.expiredQueue.size() == 0) {
            this.loadExpiredQueue(1000);
        } else {
            item = (MsgDBItem)this.expiredQueue.peek();
            if (item != null && this.earliestOffline < item.expired.getTime()) {
                this.loadExpiredQueue(item.expired);
            }
        }
        item = null;
        while (item == null) {
            try {
                item = (MsgDBItem)this.expiredQueue.take();
            }
            catch (InterruptedException ex) {}
        }
        if (delete) {
            this.deleteMessage(item.db_id);
        }
        return item.msg;
    }

    public void initRepository(String conn_str, Map<String, String> map) throws SQLException {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        log.log(Level.INFO, "Initializing dbAccess for db connection url: {0}", conn_str);
        if (map != null) {
            String msgs_store_limit_str;
            String query = map.get(GET_USER_UID_PROP_KEY);
            if (query != null) {
                this.uid_query = query;
            }
            if ((query = map.get(MSGS_COUNT_LIMIT_PROP_KEY)) != null) {
                this.msg_count_for_limit_query = query;
            }
            if ((msgs_store_limit_str = map.get(MSGS_STORE_LIMIT_KEY)) != null) {
                this.msgs_store_limit = Long.parseLong(msgs_store_limit_str);
            }
        }
        try {
            this.data_repo = RepositoryFactory.getDataRepository(null, conn_str, map);
            this.checkDB();
            this.data_repo.initPreparedStatement(this.uid_query, this.uid_query);
            this.data_repo.initPreparedStatement(MSG_INSERT_QUERY, MSG_INSERT_QUERY);
            this.data_repo.initPreparedStatement(MSG_SELECT_TO_JID_QUERY, MSG_SELECT_TO_JID_QUERY);
            this.data_repo.initPreparedStatement(MSG_DELETE_TO_JID_QUERY, MSG_DELETE_TO_JID_QUERY);
            this.data_repo.initPreparedStatement(MSG_DELETE_ID_QUERY, MSG_DELETE_ID_QUERY);
            this.data_repo.initPreparedStatement(MSG_SELECT_EXPIRED_QUERY, MSG_SELECT_EXPIRED_QUERY);
            this.data_repo.initPreparedStatement(MSG_SELECT_EXPIRED_BEFORE_QUERY, MSG_SELECT_EXPIRED_BEFORE_QUERY);
            this.data_repo.initPreparedStatement(this.msg_count_for_limit_query, this.msg_count_for_limit_query);
            this.data_repo.initPreparedStatement(ADD_USER_JID_ID_QUERY, ADD_USER_JID_ID_QUERY);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "MsgRepository not initialized due to exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue<Element> loadMessagesToJID(JID to, boolean delete) throws UserNotFoundException {
        Queue result = null;
        ResultSet rs = null;
        try {
            PreparedStatement select_to_jid_st;
            long to_uid = this.getUserUID(to.getBareJID());
            if (to_uid < 0L) {
                throw new UserNotFoundException("User: " + to + " was not found in database.");
            }
            PreparedStatement preparedStatement = select_to_jid_st = this.data_repo.getPreparedStatement(to.getBareJID(), MSG_SELECT_TO_JID_QUERY);
            synchronized (preparedStatement) {
                select_to_jid_st.setLong(1, to_uid);
                rs = select_to_jid_st.executeQuery();
                StringBuilder sb = new StringBuilder(1000);
                while (rs.next()) {
                    sb.append(rs.getString(MSG_BODY_COLUMN));
                }
                if (sb.length() > 0) {
                    DomBuilderHandler domHandler = new DomBuilderHandler();
                    this.parser.parse((SimpleHandler)domHandler, sb.toString().toCharArray(), 0, sb.length());
                    result = domHandler.getParsedElements();
                }
            }
            if (delete) {
                PreparedStatement delete_to_jid_st;
                PreparedStatement preparedStatement2 = delete_to_jid_st = this.data_repo.getPreparedStatement(to.getBareJID(), MSG_DELETE_TO_JID_QUERY);
                synchronized (preparedStatement2) {
                    delete_to_jid_st.setLong(1, to_uid);
                    delete_to_jid_st.executeUpdate();
                }
            }
            this.data_repo.release(null, rs);
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages for user: " + to, e);
        }
        finally {
            this.data_repo.release(null, rs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessage(JID from, JID to, Date expired, Element msg) throws UserNotFoundException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Storring expired: {0} message: {1}", new Object[]{expired, Packet.elemToString(msg)});
        }
        ResultSet rs = null;
        try {
            PreparedStatement insert_msg_st;
            PreparedStatement count_msgs_st;
            long to_uid;
            long from_uid = this.getUserUID(from.getBareJID());
            if (from_uid < 0L) {
                from_uid = this.addUserJID(from.getBareJID());
            }
            if ((to_uid = this.getUserUID(to.getBareJID())) < 0L) {
                to_uid = this.addUserJID(to.getBareJID());
            }
            long count = 0L;
            PreparedStatement preparedStatement = count_msgs_st = this.data_repo.getPreparedStatement(to.getBareJID(), this.msg_count_for_limit_query);
            synchronized (preparedStatement) {
                count_msgs_st.setLong(1, to_uid);
                count_msgs_st.setLong(2, from_uid);
                rs = count_msgs_st.executeQuery();
                if (rs.next()) {
                    count = rs.getLong(1);
                }
            }
            if (this.msgs_store_limit <= count) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Message store limit ({0}) exceeded for message: {1}", new Object[]{this.msgs_store_limit, Packet.elemToString(msg)});
                }
                return;
            }
            PreparedStatement preparedStatement2 = insert_msg_st = this.data_repo.getPreparedStatement(to.getBareJID(), MSG_INSERT_QUERY);
            synchronized (preparedStatement2) {
                if (expired == null) {
                    insert_msg_st.setNull(1, 93);
                } else {
                    Timestamp time = new Timestamp(expired.getTime());
                    insert_msg_st.setTimestamp(1, time);
                }
                if (from_uid <= 0L) {
                    insert_msg_st.setNull(2, -5);
                } else {
                    insert_msg_st.setLong(2, from_uid);
                }
                insert_msg_st.setLong(3, to_uid);
                insert_msg_st.setString(4, msg.toString());
                insert_msg_st.executeUpdate();
            }
            if (expired != null) {
                if (expired.getTime() < this.earliestOffline) {
                    this.earliestOffline = expired.getTime();
                }
                if (this.expiredQueue.size() == 0) {
                    this.loadExpiredQueue(1);
                }
            }
        }
        catch (DataTruncation dte) {
            log.log(Level.FINE, "Data truncated for message from {0} to {1}", new Object[]{from, to});
            this.data_repo.release(null, rs);
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem adding new entry to DB: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addUserJID(BareJID bareJID) throws SQLException, UserNotFoundException {
        try {
            PreparedStatement add_jid_id_st;
            String jid_sha = Algorithms.hexDigest((String)bareJID.toString(), (String)"", (String)"SHA");
            PreparedStatement preparedStatement = add_jid_id_st = this.data_repo.getPreparedStatement(bareJID, ADD_USER_JID_ID_QUERY);
            synchronized (preparedStatement) {
                add_jid_id_st.setString(1, jid_sha);
                add_jid_id_st.setString(2, bareJID.toString());
                add_jid_id_st.executeUpdate();
            }
        }
        catch (NoSuchAlgorithmException ex) {
            log.log(Level.WARNING, "Configuration error or code bug: ", ex);
            return -1L;
        }
        return this.getUserUID(bareJID);
    }

    private void checkDB() throws SQLException {
        if (this.data_repo.getResourceUri().contains("mysql")) {
            this.data_repo.checkTable(JID_TABLE, MYSQL_CREATE_JID_TABLE);
            this.data_repo.checkTable(MSG_TABLE, MYSQL_CREATE_MSG_TABLE);
        } else if (this.data_repo.getResourceUri().contains("postgresql")) {
            this.data_repo.checkTable(JID_TABLE, PGSQL_CREATE_JID_TABLE);
            this.data_repo.checkTable(MSG_TABLE, PGSQL_CREATE_MSG_TABLE);
        } else if (this.data_repo.getResourceUri().contains("derby")) {
            this.data_repo.checkTable(JID_TABLE, DERBY_CREATE_JID_TABLE);
            this.data_repo.checkTable(MSG_TABLE, DERBY_CREATE_MSG_TABLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMessage(long msg_id) {
        try {
            PreparedStatement delete_id_st;
            PreparedStatement preparedStatement = delete_id_st = this.data_repo.getPreparedStatement(null, MSG_DELETE_ID_QUERY);
            synchronized (preparedStatement) {
                delete_id_st.setLong(1, msg_id);
                delete_id_st.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem removing entry from DB: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUserUID(BareJID user_id) throws SQLException, UserNotFoundException {
        String jid_sha;
        Long cache_res = this.uids_cache.get(user_id);
        if (cache_res != null) {
            return cache_res;
        }
        ResultSet rs = null;
        long result = -1L;
        try {
            jid_sha = Algorithms.hexDigest((String)user_id.toString(), (String)"", (String)"SHA");
        }
        catch (NoSuchAlgorithmException ex) {
            log.log(Level.WARNING, "Configuration error or code bug: ", ex);
            return -1L;
        }
        try {
            PreparedStatement uid_st;
            PreparedStatement preparedStatement = uid_st = this.data_repo.getPreparedStatement(user_id, this.uid_query);
            synchronized (preparedStatement) {
                uid_st.setString(1, jid_sha);
                rs = uid_st.executeQuery();
                if (rs.next()) {
                    BareJID res_jid = BareJID.bareJIDInstanceNS((String)rs.getString(JID_COLUMN));
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Found entry for JID: {0}, DB JID: {1}", new Object[]{user_id, res_jid});
                    }
                    if (user_id.equals((Object)res_jid)) {
                        result = rs.getLong(JID_ID_COLUMN);
                    } else if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "JIDs don't match, SHA conflict? JID: {0}, DB JID: {1}", new Object[]{user_id, res_jid});
                    }
                } else if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "No entry for JID: {0}", user_id);
                }
            }
            this.data_repo.release(null, rs);
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        if (result > 0L) {
            this.uids_cache.put(user_id, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExpiredQueue(int min_elements) {
        ResultSet rs = null;
        try {
            PreparedStatement select_expired_st;
            PreparedStatement preparedStatement = select_expired_st = this.data_repo.getPreparedStatement(null, MSG_SELECT_EXPIRED_QUERY);
            synchronized (preparedStatement) {
                rs = select_expired_st.executeQuery();
                DomBuilderHandler domHandler = new DomBuilderHandler();
                int counter = 0;
                while (rs.next() && (this.expiredQueue.size() < 1000 || counter++ < min_elements)) {
                    String msg_str = rs.getString(MSG_BODY_COLUMN);
                    this.parser.parse((SimpleHandler)domHandler, msg_str.toCharArray(), 0, msg_str.length());
                    Queue elems = domHandler.getParsedElements();
                    Element msg = (Element)elems.poll();
                    if (msg == null) {
                        log.log(Level.INFO, "Something wrong, loaded offline message from DB but parsed no XML elements: {0}", msg_str);
                        continue;
                    }
                    Timestamp ts = rs.getTimestamp(MSG_EXPIRED_COLUMN);
                    MsgDBItem item = new MsgDBItem(rs.getLong(MSG_ID_COLUMN), msg, ts);
                    this.expiredQueue.offer(item);
                }
            }
            this.data_repo.release(null, rs);
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages from db: ", e);
        }
        finally {
            this.data_repo.release(null, rs);
        }
        this.earliestOffline = Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExpiredQueue(Date expired) {
        ResultSet rs = null;
        try {
            PreparedStatement select_expired_before_st;
            if (this.expiredQueue.size() > 100000) {
                this.expiredQueue.clear();
            }
            PreparedStatement preparedStatement = select_expired_before_st = this.data_repo.getPreparedStatement(null, MSG_SELECT_EXPIRED_BEFORE_QUERY);
            synchronized (preparedStatement) {
                select_expired_before_st.setTimestamp(1, new Timestamp(expired.getTime()));
                rs = select_expired_before_st.executeQuery();
                DomBuilderHandler domHandler = new DomBuilderHandler();
                int counter = 0;
                while (rs.next() && counter++ < 1000) {
                    String msg_str = rs.getString(MSG_BODY_COLUMN);
                    this.parser.parse((SimpleHandler)domHandler, msg_str.toCharArray(), 0, msg_str.length());
                    Queue elems = domHandler.getParsedElements();
                    Element msg = (Element)elems.poll();
                    if (msg == null) {
                        log.log(Level.INFO, "Something wrong, loaded offline message from DB but parsed no XML elements: {0}", msg_str);
                        continue;
                    }
                    Timestamp ts = rs.getTimestamp(MSG_EXPIRED_COLUMN);
                    MsgDBItem item = new MsgDBItem(rs.getLong(MSG_ID_COLUMN), msg, ts);
                    this.expiredQueue.offer(item);
                }
            }
            this.data_repo.release(null, rs);
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting offline messages from db: ", e);
        }
        finally {
            this.data_repo.release(null, rs);
        }
        this.earliestOffline = Long.MAX_VALUE;
    }

    private class MsgDBItem
    implements Delayed {
        private long db_id = -1L;
        private Date expired = null;
        private Element msg = null;

        public MsgDBItem(long db_id, Element msg, Date expired) {
            this.db_id = db_id;
            this.msg = msg;
            this.expired = expired;
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.getDelay(TimeUnit.NANOSECONDS) - o.getDelay(TimeUnit.NANOSECONDS));
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expired.getTime() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
    }
}

