/*
 * Decompiled with CFR 0.152.
 */
package tigase.disco;

import java.util.List;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.Packet;
import tigase.server.ServerComponent;
import tigase.server.XMPPServer;
import tigase.xml.Element;
import tigase.xmpp.JID;

public abstract class XMPPServiceCollector
extends AbstractComponentRegistrator<XMPPService> {
    private static final Logger log = Logger.getLogger(XMPPServiceCollector.class.getName());
    private ServiceEntity serviceEntity = new ServiceEntity("Tigase", "server", "Session manager");

    public XMPPServiceCollector() {
        this.serviceEntity.addIdentities(new ServiceIdentity("server", "im", "Tigase ver. " + XMPPServer.getImplementationVersion()));
    }

    @Override
    public void componentAdded(XMPPService component) {
    }

    @Override
    public void componentRemoved(XMPPService component) {
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof XMPPService;
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        if (packet.isXMLNS("/iq/query", "http://jabber.org/protocol/disco#info") || packet.isXMLNS("/iq/query", "http://jabber.org/protocol/disco#items")) {
            JID jid = packet.getStanzaTo();
            JID from = packet.getStanzaFrom();
            String node = packet.getAttribute("/iq/query", "node");
            Element query = packet.getElement().getChild("query").clone();
            if (packet.isXMLNS("/iq/query", "http://jabber.org/protocol/disco#info")) {
                for (XMPPService comp : this.components.values()) {
                    Element resp = comp.getDiscoInfo(node, jid, from);
                    if (resp == null) continue;
                    query = resp;
                    break;
                }
            }
            if (packet.isXMLNS("/iq/query", "http://jabber.org/protocol/disco#items")) {
                for (XMPPService comp : this.components.values()) {
                    List<Element> items = comp.getDiscoItems(node, jid, from);
                    if (items == null || items.size() <= 0) continue;
                    query.addChildren(items);
                }
            }
            results.offer(packet.okResult(query, 0));
        }
    }
}

