/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.comp;

import tigase.db.comp.RepositoryItem;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.xml.Element;

public abstract class RepositoryItemAbstract
implements RepositoryItem {
    public static final String OWNER_LABEL = "Owner";
    public static final String OWNER_ATT = "owner";
    public static final String ADMINS_LABEL = "Administrators";
    public static final String ADMINS_ATT = "admins";
    private String[] admins = null;
    private String owner = null;

    public abstract String getElemName();

    @Override
    public void addCommandFields(Packet packet) {
        Command.addFieldValue(packet, OWNER_LABEL, this.owner != null ? this.owner : packet.getStanzaTo().getBareJID().toString());
        Command.addFieldValue(packet, ADMINS_LABEL, this.adminsToString(this.admins));
    }

    @Override
    public String[] getAdmins() {
        return this.admins;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void initFromCommand(Packet packet) {
        this.owner = Command.getFieldValue(packet, OWNER_LABEL);
        if (this.owner == null || this.owner.trim().isEmpty()) {
            this.owner = packet.getStanzaFrom().getBareJID().toString();
        }
        this.admins = this.adminsFromString(Command.getFieldValue(packet, ADMINS_LABEL));
    }

    @Override
    public void initFromElement(Element elem) {
        this.owner = elem.getAttribute(OWNER_ATT);
        this.admins = this.adminsFromString(elem.getAttribute(ADMINS_ATT));
    }

    @Override
    public boolean isAdmin(String id) {
        if (this.admins == null) {
            return false;
        }
        for (String admin : this.admins) {
            if (!admin.equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOwner(String id) {
        return this.owner == null ? false : this.owner.equals(id);
    }

    @Override
    public void setAdmins(String[] admins) {
        this.admins = admins;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public Element toElement() {
        Element elem = new Element(this.getElemName());
        if (this.owner != null) {
            elem.addAttribute(OWNER_ATT, this.owner);
        }
        if (this.admins != null) {
            elem.addAttribute(ADMINS_ATT, this.adminsToString(this.admins));
        }
        return elem;
    }

    private String[] adminsFromString(String admins_m) {
        String[] result = null;
        if (admins_m != null && admins_m.trim().length() > 0) {
            String[] tmp = admins_m.split(",");
            result = new String[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = tmp[i].trim();
            }
        }
        return result;
    }

    private String adminsToString(String[] admins_m) {
        StringBuilder sb = new StringBuilder(100);
        if (admins_m != null && admins_m.length > 0) {
            for (String adm : admins_m) {
                if (sb.length() == 0) {
                    sb.append(adm);
                    continue;
                }
                sb.append(',').append(adm);
            }
        }
        return sb.toString();
    }
}

