/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.strategy;

import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.JID;

public class ConnectionRecord
implements Comparable<ConnectionRecord> {
    private static final String TOP_ELEMENT = "conn-rec";
    private static final String NODE_ELEMENT = "node-jid";
    private static final String JID_ELEMENT = "user-jid";
    private static final String CONNECTION_ID_ELEMENT = "connection-id";
    private static final String SESSION_ID_ELEMENT = "session-id";
    private static final String PRESENCE_ELEMENT = "presence";
    private JID node;
    private JID userJid;
    private JID connectionId;
    private String sessionId;
    private Element lastPresence;

    public ConnectionRecord(JID node, JID userJid, String sessionId, JID connectionId) {
        this.node = node;
        this.userJid = userJid;
        this.connectionId = connectionId;
        this.sessionId = sessionId;
    }

    public ConnectionRecord(Element elem) {
        this.node = JID.jidInstanceNS((String)elem.getChild(NODE_ELEMENT).getCData());
        this.userJid = JID.jidInstanceNS((String)elem.getChild(JID_ELEMENT).getCData());
        this.connectionId = JID.jidInstanceNS((String)elem.getChild(CONNECTION_ID_ELEMENT).getCData());
        this.sessionId = elem.getChild(SESSION_ID_ELEMENT).getCData();
        this.lastPresence = elem.getChild(PRESENCE_ELEMENT);
    }

    public Element toElement() {
        Element result = new Element(TOP_ELEMENT);
        result.addChild((XMLNodeIfc)new Element(NODE_ELEMENT, this.node.toString()));
        result.addChild((XMLNodeIfc)new Element(JID_ELEMENT, this.userJid.toString()));
        result.addChild((XMLNodeIfc)new Element(CONNECTION_ID_ELEMENT, this.connectionId.toString()));
        result.addChild((XMLNodeIfc)new Element(SESSION_ID_ELEMENT, this.sessionId));
        if (this.lastPresence != null) {
            result.addChild((XMLNodeIfc)this.lastPresence);
        }
        return result;
    }

    public JID getNode() {
        return this.node;
    }

    public JID getUserJid() {
        return this.userJid;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public JID getConnectionId() {
        return this.connectionId;
    }

    public void setLastPresence(Element lastPresence) {
        this.lastPresence = lastPresence;
    }

    public Element getLastPresence() {
        return this.lastPresence;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionRecord=[");
        sb.append("node: ").append(this.node);
        sb.append(", userJid: ").append(this.userJid);
        sb.append(", connectionId: ").append(this.connectionId);
        sb.append(", sessionId: ").append(this.sessionId);
        sb.append(", lastPresence: ").append(this.lastPresence);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int compareTo(ConnectionRecord rec) {
        return this.connectionId.compareTo(rec.connectionId);
    }

    public boolean equals(Object rec) {
        boolean result = false;
        if (rec instanceof ConnectionRecord) {
            result = this.connectionId.equals((Object)((ConnectionRecord)rec).connectionId);
        }
        return result;
    }

    public int hashCode() {
        return this.connectionId.hashCode();
    }
}

