/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.cluster.api.CommandListener;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.S2SConnectionManager;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class S2SConnectionClustered
extends S2SConnectionManager
implements ClusteredComponentIfc {
    private static final Logger log = Logger.getLogger(S2SConnectionClustered.class.getName());
    private static final String CHECK_DB_KEY_CMD = "check-db-key-s2s-cmd";
    private static final String CHECK_DB_KEY_RESULT_CMD = "check-db-key-result-s2s-cmd";
    private static final String CONN_CID = "connection-cid";
    private static final String KEY_CID = "key-cid";
    private static final String KEY_P = "key";
    private static final String FORKEY_SESSION_ID = "forkey_sessionId";
    private static final String ASKING_SESSION_ID = "asking_sessionId";
    private static final String VALID = "valid";
    private ClusterControllerIfc clusterController = null;
    private CommandListener checkDBKey = new CheckDBKey();
    private CommandListener checkDBKeyResult = new CheckDBKeyResult();
    private List<JID> cl_nodes_array = new CopyOnWriteArrayList<JID>();

    @Override
    public String getLocalDBKey(CID connectionCid, CID keyCid, String key, String key_sessionId, String asking_sessionId) {
        String local_key = super.getLocalDBKey(connectionCid, keyCid, key, key_sessionId, asking_sessionId);
        if (local_key != null) {
            return local_key;
        }
        JID toNode = this.getFirstClusterNode();
        if (toNode != null) {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(6, 0.25f);
            params.put(CONN_CID, connectionCid.toString());
            params.put(KEY_CID, keyCid.toString());
            params.put(KEY_P, key);
            params.put(FORKEY_SESSION_ID, key_sessionId);
            params.put(ASKING_SESSION_ID, asking_sessionId);
            this.clusterController.sendToNodes(CHECK_DB_KEY_CMD, params, this.getComponentId(), toNode);
            return null;
        }
        return "invalid-key";
    }

    @Override
    public void nodeConnected(String node) {
        this.cl_nodes_array.add(JID.jidInstanceNS((String)this.getName(), (String)node, null));
    }

    @Override
    public void nodeDisconnected(String node) {
        this.cl_nodes_array.remove(JID.jidInstanceNS((String)this.getName(), (String)node, null));
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        this.clusterController = cl_controller;
        this.clusterController.removeCommandListener(CHECK_DB_KEY_CMD, this.checkDBKey);
        this.clusterController.removeCommandListener(CHECK_DB_KEY_RESULT_CMD, this.checkDBKeyResult);
        this.clusterController.setCommandListener(CHECK_DB_KEY_CMD, this.checkDBKey);
        this.clusterController.setCommandListener(CHECK_DB_KEY_RESULT_CMD, this.checkDBKeyResult);
    }

    protected JID getFirstClusterNode() {
        JID cluster_node = null;
        for (JID node : this.cl_nodes_array) {
            if (node.equals((Object)this.getComponentId())) continue;
            cluster_node = node;
            break;
        }
        return cluster_node;
    }

    private class CheckDBKeyResult
    implements CommandListener {
        private CheckDBKeyResult() {
        }

        @Override
        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
            }
            CID connCid = new CID(data.get(S2SConnectionClustered.CONN_CID));
            CID keyCid = new CID(data.get(S2SConnectionClustered.KEY_CID));
            String forkey_sessionId = data.get(S2SConnectionClustered.FORKEY_SESSION_ID);
            String asking_sessionId = data.get(S2SConnectionClustered.ASKING_SESSION_ID);
            boolean valid = "true".equals(data.get(S2SConnectionClustered.VALID));
            S2SConnectionClustered.this.sendVerifyResult("db:verify", connCid, keyCid, valid, forkey_sessionId, asking_sessionId, null, false);
        }
    }

    private class CheckDBKey
    implements CommandListener {
        private CheckDBKey() {
        }

        @Override
        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
            }
            CID connCid = new CID(data.get(S2SConnectionClustered.CONN_CID));
            CID keyCid = new CID(data.get(S2SConnectionClustered.KEY_CID));
            String key = data.get(S2SConnectionClustered.KEY_P);
            String forkey_sessionId = data.get(S2SConnectionClustered.FORKEY_SESSION_ID);
            String asking_sessionId = data.get(S2SConnectionClustered.ASKING_SESSION_ID);
            if (fromNode.equals((Object)S2SConnectionClustered.this.getComponentId())) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "the request came back to the first sending node then no one had a valid key for this connection, therefore we are sending invalid back. fromNode: {0}, compId: {1}, connCid: {2}, keyCid: {3}, forkey_sessionId: {4}, asking_sessionId: {5}", new Object[]{fromNode, S2SConnectionClustered.this.getComponentId(), connCid, keyCid, forkey_sessionId, asking_sessionId});
                }
                S2SConnectionClustered.this.sendVerifyResult("db:verify", connCid, keyCid, false, forkey_sessionId, asking_sessionId, null, false);
                return;
            }
            String local_key = S2SConnectionClustered.super.getLocalDBKey(connCid, keyCid, key, forkey_sessionId, asking_sessionId);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "LocalDBKey: {0}", local_key);
            }
            boolean valid = false;
            if (local_key == null) {
                JID nextNode = this.getNextNode(fromNode, visitedNodes);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "No local db key, sending to next node: {0}", nextNode);
                }
                S2SConnectionClustered.this.clusterController.sendToNodes(S2SConnectionClustered.CHECK_DB_KEY_CMD, data, fromNode, visitedNodes, nextNode);
                return;
            }
            valid = local_key.equals(key);
            data.put(S2SConnectionClustered.VALID, "" + valid);
            S2SConnectionClustered.this.clusterController.sendToNodes(S2SConnectionClustered.CHECK_DB_KEY_RESULT_CMD, data, S2SConnectionClustered.this.getComponentId(), fromNode);
        }

        private JID getNextNode(JID fromNode, Set<JID> visitedNodes) {
            JID result = fromNode;
            for (JID jid : S2SConnectionClustered.this.cl_nodes_array) {
                if (fromNode.equals((Object)jid) || visitedNodes.contains(jid)) continue;
                result = jid;
                break;
            }
            return result;
        }
    }
}

