/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class Message
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final Logger log = Logger.getLogger(Message.class.getName());
    private static final String XMLNS = "jabber:client";
    private static final String ID = "message";
    private static final String[] ELEMENTS = new String[]{"message"};
    private static final String[] XMLNSS = new String[]{"jabber:client"};

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet);
        }
        if (session == null) {
            return;
        }
        try {
            BareJID id;
            BareJID bareJID = id = packet.getStanzaTo() != null ? packet.getStanzaTo().getBareJID() : null;
            if (session.isUserId(id)) {
                Packet result = packet.copyElementOnly();
                result.setPacketTo(session.getConnectionId(packet.getStanzaTo()));
                result.setPacketFrom(packet.getTo());
                results.offer(result);
                return;
            }
            BareJID bareJID2 = id = packet.getStanzaFrom() != null ? packet.getStanzaFrom().getBareJID() : null;
            if (session.isUserId(id)) {
                results.offer(packet.copyElementOnly());
                return;
            }
            JID jid = packet.getFrom();
            if (session.getConnectionId().equals((Object)jid)) {
                Element el_result = packet.getElement().clone();
                el_result.setAttribute("from", session.getJID().toString());
                Packet result = Packet.packetInstance(el_result, session.getJID(), packet.getStanzaTo());
                results.offer(result);
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("NotAuthorizedException for packet: " + packet);
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }
}

