/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.proc.S2SAbstractProcessor;

public class PacketChecker
extends S2SAbstractProcessor {
    private static final Logger log = Logger.getLogger(PacketChecker.class.getName());

    @Override
    public boolean process(Packet p, S2SIOService serv, Queue<Packet> results) {
        if (p.getXMLNS() == "jabber:server" || p.getXMLNS() == "jabber:client") {
            if (p.getStanzaFrom() == null || p.getStanzaFrom().getDomain().trim().isEmpty() || p.getStanzaTo() == null || p.getStanzaTo().getDomain().trim().isEmpty()) {
                this.generateStreamError(false, "improper-addressing", serv);
                return true;
            }
            CID cid = new CID(p.getStanzaTo().getDomain(), p.getStanzaFrom().getDomain());
            if (!serv.isAuthenticated(cid)) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "{0}, Invalid hostname from the remote server for packet: {1}, authenticated domains for this connection: {2}", new Object[]{serv, p, serv.getCIDs()});
                }
                this.generateStreamError(false, "invalid-from", serv);
                return true;
            }
        } else {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "{0}, Invalid namespace for packet: {1}", new Object[]{serv, p});
            }
            this.generateStreamError(false, "invalid-namespace", serv);
            return true;
        }
        return false;
    }
}

