/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.CIDConnections;
import tigase.server.xmppserver.LocalhostException;
import tigase.server.xmppserver.NotLocalhostException;
import tigase.server.xmppserver.S2SConnectionHandlerIfc;
import tigase.server.xmppserver.S2SConnectionSelector;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.S2SProcessor;
import tigase.server.xmppserver.proc.Dialback;
import tigase.server.xmppserver.proc.PacketChecker;
import tigase.server.xmppserver.proc.StartTLS;
import tigase.server.xmppserver.proc.StartZlib;
import tigase.server.xmppserver.proc.StreamError;
import tigase.server.xmppserver.proc.StreamFeatures;
import tigase.server.xmppserver.proc.StreamOpen;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;

public class S2SConnectionManager
extends ConnectionManager<S2SIOService>
implements S2SConnectionHandlerIfc<S2SIOService> {
    private static final Logger log = Logger.getLogger(S2SConnectionManager.class.getName());
    private static final String XMLNS_SERVER_VAL = "jabber:server";
    private static final String XMLNS_CLIENT_VAL = "jabber:client";
    protected static final String DB_RESULT_EL_NAME = "db:result";
    protected static final String DB_VERIFY_EL_NAME = "db:verify";
    public static final String MAX_PACKET_WAITING_TIME_PROP_KEY = "max-packet-waiting-time";
    public static final String MAX_CONNECTION_INACTIVITY_TIME_PROP_KEY = "max-inactivity-time";
    public static final String MAX_INCOMING_CONNECTIONS_PROP_KEY = "max-in-conns";
    public static final String MAX_OUT_TOTAL_CONNECTIONS_PROP_KEY = "max-out-total-conns";
    public static final String MAX_OUT_PER_IP_CONNECTIONS_PROP_KEY = "max-out-per-ip-conns";
    public static final String S2S_CONNECTION_SELECTOR_PROP_KEY = "s2s-conn-selector";
    public static final String S2S_CONNECTION_SELECTOR_PROP_VAL = "tigase.server.xmppserver.S2SRandomSelector";
    public static final int MAX_INCOMING_CONNECTIONS_PROP_VAL = 4;
    public static final int MAX_OUT_TOTAL_CONNECTIONS_PROP_VAL = 1;
    public static final int MAX_OUT_PER_IP_CONNECTIONS_PROP_VAL = 1;
    public static final long MAX_PACKET_WAITING_TIME_PROP_VAL = 420000L;
    public static final long MAX_CONNECTION_INACTIVITY_TIME_PROP_VAL = 900000L;
    public static final String CID_CONNECTIONS_BIND = "cidConnections";
    private S2SConnectionSelector connSelector = null;
    private long maxPacketWaitingTime = 420000L;
    private int maxOUTTotalConnections = 1;
    private int maxOUTPerIPConnections = 1;
    private long maxInactivityTime = 900000L;
    private int maxINConnections = 4;
    private Map<CID, CIDConnections> cidConnections = new ConcurrentHashMap<CID, CIDConnections>(10000);
    private Map<String, S2SProcessor> processors = new LinkedHashMap<String, S2SProcessor>(10);
    private Map<String, S2SProcessor> filters = new LinkedHashMap<String, S2SProcessor>(10);

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put(CID_CONNECTIONS_BIND, (Object)this.cidConnections);
    }

    @Override
    public boolean addOutPacket(Packet packet) {
        return super.addOutPacket(packet);
    }

    @Override
    public void addTimerTask(TimerTask task, long delay, TimeUnit unit) {
        super.addTimerTask(task, delay, unit);
    }

    @Override
    public CIDConnections getCIDConnections(CID cid, boolean createNew) throws NotLocalhostException, LocalhostException {
        CIDConnections result = this.getCIDConnections(cid);
        if (result == null && createNew && cid != null) {
            result = this.createNewCIDConnections(cid);
        }
        return result;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        props.put(MAX_PACKET_WAITING_TIME_PROP_KEY, 420L);
        props.put(MAX_CONNECTION_INACTIVITY_TIME_PROP_KEY, 900L);
        props.put(MAX_INCOMING_CONNECTIONS_PROP_KEY, 4);
        props.put(MAX_OUT_TOTAL_CONNECTIONS_PROP_KEY, 1);
        props.put(MAX_OUT_PER_IP_CONNECTIONS_PROP_KEY, 1);
        props.put(S2S_CONNECTION_SELECTOR_PROP_KEY, S2S_CONNECTION_SELECTOR_PROP_VAL);
        return props;
    }

    @Override
    public String getDiscoCategoryType() {
        return "s2s";
    }

    @Override
    public String getDiscoDescription() {
        return "S2S connection manager";
    }

    @Override
    public String getLocalDBKey(CID connectionCid, CID keyCid, String key, String key_sessionId, String asking_sessionId) {
        String result;
        CIDConnections cid_conns = this.getCIDConnections(keyCid);
        String string = result = cid_conns == null ? null : cid_conns.getDBKey(key_sessionId);
        if (result == null) {
            cid_conns = this.getCIDConnections(connectionCid);
            result = cid_conns == null ? null : cid_conns.getDBKey(key_sessionId);
        }
        return result;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "CIDs number", this.cidConnections.size(), Level.INFO);
        if (list.checkLevel(Level.FINEST)) {
            long total_outgoing = 0L;
            long total_outgoing_tls = 0L;
            long total_outgoing_handshaking = 0L;
            long total_incoming = 0L;
            long total_incoming_tls = 0L;
            long total_dbKeys = 0L;
            long total_waiting = 0L;
            long total_waiting_control = 0L;
            for (Map.Entry<CID, CIDConnections> cid_conn : this.cidConnections.entrySet()) {
                int outgoing = cid_conn.getValue().getOutgoingCount();
                int outgoing_tls = cid_conn.getValue().getOutgoingTLSCount();
                int outgoing_handshaking = cid_conn.getValue().getOutgoingHandshakingCount();
                int incoming = cid_conn.getValue().getIncomingCount();
                int incoming_tls = cid_conn.getValue().getIncomingTLSCount();
                int dbKeys = cid_conn.getValue().getDBKeysCount();
                int waiting = cid_conn.getValue().getWaitingCount();
                int waiting_control = cid_conn.getValue().getWaitingControlCount();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "CID: {0}, OUT: {1}, OUT_HAND: {2}, IN: {3}, dbKeys: {4}, waiting: {5}, waiting_control: {6}", new Object[]{cid_conn.getKey(), outgoing, outgoing_handshaking, incoming, dbKeys, waiting, waiting_control});
                }
                total_outgoing += (long)outgoing;
                total_outgoing_tls += (long)outgoing_tls;
                total_outgoing_handshaking += (long)outgoing_handshaking;
                total_incoming += (long)incoming;
                total_incoming_tls += (long)incoming_tls;
                total_dbKeys += (long)dbKeys;
                total_waiting += (long)waiting;
                total_waiting_control += (long)waiting_control;
            }
            list.add(this.getName(), "Total outgoing", total_outgoing, Level.FINEST);
            list.add(this.getName(), "Total outgoing TLS", total_outgoing_tls, Level.FINEST);
            list.add(this.getName(), "Total outgoing handshaking", total_outgoing_handshaking, Level.FINEST);
            list.add(this.getName(), "Total incoming", total_incoming, Level.FINEST);
            list.add(this.getName(), "Total incoming TLS", total_incoming_tls, Level.FINEST);
            list.add(this.getName(), "Total DB keys", total_dbKeys, Level.FINEST);
            list.add(this.getName(), "Total waiting", total_waiting, Level.FINEST);
            list.add(this.getName(), "Total control waiting", total_waiting_control, Level.FINEST);
        }
    }

    @Override
    public List<Element> getStreamFeatures(S2SIOService serv) {
        ArrayList<Element> results = new ArrayList<Element>(10);
        for (S2SProcessor proc : this.processors.values()) {
            proc.streamFeatures(serv, results);
        }
        return results;
    }

    @Override
    public boolean handlesNonLocalDomains() {
        return true;
    }

    @Override
    public int hashCodeForPacket(Packet packet) {
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().getDomain().hashCode();
        }
        return 1;
    }

    @Override
    public void initNewConnection(Map<String, Object> port_props) {
        this.addWaitingTask(port_props);
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet);
        }
        if (packet.getStanzaTo() == null || packet.getStanzaTo().getDomain().trim().isEmpty()) {
            log.log(Level.WARNING, "Missing ''to'' attribute, ignoring packet...{0}\n This most likely happens due to missconfiguration of components domain names.", packet);
            return;
        }
        if (packet.getStanzaFrom() == null || packet.getStanzaFrom().getDomain().trim().isEmpty()) {
            log.log(Level.WARNING, "Missing ''from'' attribute, ignoring packet...{0}", packet);
            return;
        }
        String to_hostname = packet.getStanzaTo().getDomain();
        try {
            String from_hostname = packet.getStanzaFrom().getDomain();
            CID cid = new CID(from_hostname, to_hostname);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Connection ID is: {0}", cid);
            }
            try {
                CIDConnections cid_conns = this.getCIDConnections(cid, true);
                Packet server_packet = packet.copyElementOnly();
                server_packet.getElement().removeAttribute("xmlns");
                cid_conns.sendPacket(server_packet);
            }
            catch (NotLocalhostException e) {
                this.addOutPacket(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "S2S - Incorrect source address - none of any local virtual hosts or components.", true));
            }
            catch (LocalhostException e) {
                this.addOutPacket(Authorization.NOT_ACCEPTABLE.getResponseMessage(packet, "S2S - Incorrect destinationaddress - one of local virtual hosts or components.", true));
            }
        }
        catch (PacketErrorTypeException e) {
            log.log(Level.WARNING, "Packet processing exception: {0}", e);
        }
    }

    @Override
    public Queue<Packet> processSocketData(S2SIOService serv) {
        Queue<Packet> packets = serv.getReceivedPackets();
        Packet p = null;
        ArrayDeque<Packet> results = new ArrayDeque<Packet>(2);
        while ((p = packets.poll()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Processing socket data: {0}", p);
            }
            if (p.getXMLNS() == null) {
                p.setXMLNS(XMLNS_SERVER_VAL);
            }
            boolean processed = false;
            for (S2SProcessor proc : this.processors.values()) {
                processed |= proc.process(p, serv, results);
                this.writePacketsToSocket(serv, results);
            }
            if (!processed) {
                for (S2SProcessor filter : this.filters.values()) {
                    processed |= filter.process(p, serv, results);
                    this.writePacketsToSocket(serv, results);
                }
            }
            if (processed) continue;
            if (p.getXMLNS() == XMLNS_SERVER_VAL || p.getXMLNS() == null) {
                p.setXMLNS(XMLNS_CLIENT_VAL);
            }
            try {
                if (this.isLocalDomainOrComponent(p.getStanzaTo().getDomain())) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0}, Adding packet out: {1}", new Object[]{serv, p});
                    }
                    p.setPermissions(Permissions.REMOTE);
                    this.addOutPacket(p);
                    continue;
                }
                try {
                    serv.addPacketToSend(Authorization.NOT_ACCEPTABLE.getResponseMessage(p, "Not a local virtual domain or component", true));
                }
                catch (PacketErrorTypeException ex) {
                }
            }
            catch (Exception e) {
                log.log(Level.INFO, "Unexpected exception for packet: " + p, e);
            }
        }
        return null;
    }

    @Override
    public void reconnectionFailed(Map<String, Object> port_props) {
        CID cid = (CID)port_props.get("cid");
        if (cid == null) {
            log.log(Level.WARNING, "Protocol error cid not set for outgoing connection: {0}", port_props);
            return;
        }
        CIDConnections cid_conns = this.getCIDConnections(cid);
        if (cid_conns == null) {
            log.log(Level.WARNING, "Protocol error cid_conns not found for outgoing connection: {0}", port_props);
            return;
        }
        cid_conns.reconnectionFailed(port_props);
    }

    @Override
    public boolean sendVerifyResult(String elem_name, CID connCid, CID keyCid, Boolean valid, String key_sessionId, String serv_sessionId, String cdata, boolean handshakingOnly) {
        CIDConnections cid_conns = this.getCIDConnections(connCid);
        if (cid_conns != null) {
            Packet verify_valid = this.getValidResponse(elem_name, keyCid, key_sessionId, valid, cdata);
            if (handshakingOnly) {
                cid_conns.sendHandshakingOnly(verify_valid);
                return true;
            }
            return cid_conns.sendControlPacket(serv_sessionId, verify_valid);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can't find CID connections for cid: {0}, can't send verify response.", keyCid);
        }
        return false;
    }

    @Override
    public void serviceStarted(S2SIOService serv) {
        super.serviceStarted(serv);
        log.log(Level.FINEST, "s2s connection opened: {0}", serv);
        for (S2SProcessor proc : this.processors.values()) {
            proc.serviceStarted(serv);
        }
    }

    @Override
    public boolean serviceStopped(S2SIOService serv) {
        boolean result = super.serviceStopped(serv);
        if (result) {
            for (S2SProcessor proc : this.processors.values()) {
                proc.serviceStopped(serv);
            }
        }
        return result;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        this.processors.clear();
        this.processors.put(Dialback.class.getName(), new Dialback());
        this.processors.put(StartTLS.class.getName(), new StartTLS());
        this.processors.put(StartZlib.class.getName(), new StartZlib());
        this.processors.put(StreamError.class.getName(), new StreamError());
        this.processors.put(StreamFeatures.class.getName(), new StreamFeatures());
        this.processors.put(StreamOpen.class.getName(), new StreamOpen());
        for (S2SProcessor proc : this.processors.values()) {
            proc.init(this);
        }
        this.filters.clear();
        this.filters.put(PacketChecker.class.getName(), new PacketChecker());
        for (S2SProcessor filter : this.filters.values()) {
            filter.init(this);
        }
        if (props.size() == 1) {
            return;
        }
        this.maxPacketWaitingTime = (Long)props.get(MAX_PACKET_WAITING_TIME_PROP_KEY) * 1000L;
        this.maxInactivityTime = (Long)props.get(MAX_CONNECTION_INACTIVITY_TIME_PROP_KEY) * 1000L;
        this.maxOUTTotalConnections = (Integer)props.get(MAX_OUT_TOTAL_CONNECTIONS_PROP_KEY);
        this.maxOUTPerIPConnections = (Integer)props.get(MAX_OUT_PER_IP_CONNECTIONS_PROP_KEY);
        this.maxINConnections = (Integer)props.get(MAX_INCOMING_CONNECTIONS_PROP_KEY);
        String selector_str = (String)props.get(S2S_CONNECTION_SELECTOR_PROP_KEY);
        try {
            this.connSelector = (S2SConnectionSelector)Class.forName(selector_str).newInstance();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Incorrect s2s connection selector class provided: {0}", selector_str);
            log.log(Level.SEVERE, "Selector initialization exception: ", e);
        }
    }

    @Override
    public void tlsHandshakeCompleted(S2SIOService serv) {
        for (S2SProcessor proc : this.processors.values()) {
            proc.serviceStarted(serv);
        }
    }

    @Override
    public void writeRawData(S2SIOService ios, String data) {
        super.writeRawData(ios, data);
    }

    @Override
    public void xmppStreamClosed(S2SIOService serv) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "{0}, Stream closed.", new Object[]{serv});
        }
        for (S2SProcessor proc : this.processors.values()) {
            proc.streamClosed(serv);
        }
    }

    @Override
    public String xmppStreamOpened(S2SIOService serv, Map<String, String> attribs) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "{0}, Stream opened: {1}", new Object[]{serv, attribs});
        }
        StringBuilder sb = new StringBuilder(256);
        for (S2SProcessor proc : this.processors.values()) {
            String res = proc.streamOpened(serv, attribs);
            if (res == null) continue;
            sb.append(res);
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "{0}, Sending stream open: {1}", new Object[]{serv, sb});
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    @Override
    protected int[] getDefPlainPorts() {
        return new int[]{5269};
    }

    @Override
    protected long getMaxInactiveTime() {
        return this.maxInactivityTime;
    }

    @Override
    protected S2SIOService getXMPPIOServiceInstance() {
        return new S2SIOService();
    }

    @Override
    protected boolean isHighThroughput() {
        return true;
    }

    private CIDConnections createNewCIDConnections(CID cid) throws NotLocalhostException, LocalhostException {
        if (!this.isLocalDomainOrComponent(cid.getLocalHost())) {
            throw new NotLocalhostException("This is not a valid localhost: " + cid.getLocalHost());
        }
        if (this.isLocalDomainOrComponent(cid.getRemoteHost())) {
            throw new LocalhostException("This is not a valid remotehost: " + cid.getRemoteHost());
        }
        CIDConnections cid_conns = new CIDConnections(cid, this, this.connSelector, this.maxINConnections, this.maxOUTTotalConnections, this.maxOUTPerIPConnections, this.maxPacketWaitingTime);
        this.cidConnections.put(cid, cid_conns);
        return cid_conns;
    }

    private CIDConnections getCIDConnections(CID cid) {
        if (cid == null) {
            return null;
        }
        return this.cidConnections.get(cid);
    }

    private Packet getValidResponse(String elem_name, CID cid, String id, Boolean valid, String cdata) {
        Element elem = new Element(elem_name);
        if (cdata != null) {
            elem.setCData(cdata);
        }
        if (valid != null) {
            if (valid.booleanValue()) {
                elem.addAttribute("type", "valid");
            } else {
                elem.addAttribute("type", "invalid");
            }
        }
        if (id != null) {
            elem.addAttribute("id", id);
        }
        Packet result = Packet.packetInstance(elem, JID.jidInstanceNS((String)cid.getLocalHost()), JID.jidInstanceNS((String)cid.getRemoteHost()));
        return result;
    }
}

