/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver.sysmon;

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.sreceiver.sysmon.ResourceMonitorIfc;
import tigase.server.sreceiver.sysmon.SystemMonitorTask;
import tigase.stats.StatisticsList;
import tigase.xml.XMLUtils;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public abstract class AbstractMonitor
implements ResourceMonitorIfc {
    protected Set<Object> warningsSent = new LinkedHashSet<Object>();
    private JID jid = null;
    private SystemMonitorTask smTask = null;
    protected float treshold = 0.8f;

    @Override
    public void init(JID jid, float treshold, SystemMonitorTask smTask) {
        this.jid = jid;
        this.treshold = treshold;
        this.smTask = smTask;
        this.resetWarnings();
    }

    public void resetWarnings() {
        this.warningsSent = new LinkedHashSet<Object>();
    }

    public void prepareWarning(String text, Queue<Packet> results, Object warning) {
        if (!this.warningsSent.contains(warning)) {
            Packet result = Message.getMessage(this.jid, null, StanzaType.normal, XMLUtils.escape((String)("Warning! High resource usage alert from: " + this.getClass().getSimpleName() + "\n" + new Date() + " - " + text)), "System Monitor Alert", null, null);
            results.add(result);
            this.warningsSent.add(warning);
        }
    }

    public void prepareCalmDown(String text, Queue<Packet> results, Object warning) {
        if (this.warningsSent.contains(warning)) {
            Packet result = Message.getMessage(this.jid, null, StanzaType.normal, XMLUtils.escape((String)("Calm down! Resource usage notification from: " + this.getClass().getSimpleName() + "\n" + new Date() + " - " + text)), "System Monitor Alert", null, null);
            results.add(result);
            this.warningsSent.remove(warning);
        }
    }

    public void sendWarningOut(String text, Object warning) {
        if (warning == null || !this.warningsSent.contains(warning)) {
            Packet result = Message.getMessage(this.jid, null, StanzaType.normal, XMLUtils.escape((String)("Warning! High resource usage alert from: " + this.getClass().getSimpleName() + "\n" + new Date() + " - " + text)), "System Monitor Alert", null, null);
            this.smTask.sendPacketOut(result);
            if (warning != null) {
                this.warningsSent.add(warning);
            }
        }
    }

    public int setValueInArr(float[] arr, int idx, float val) {
        arr[idx] = val;
        ++idx;
        return idx %= arr.length;
    }

    public int setValueInArr(double[] arr, int idx, double val) {
        arr[idx] = val;
        ++idx;
        return idx %= arr.length;
    }

    @Override
    public void check10Secs(Queue<Packet> results) {
    }

    @Override
    public void check1Day(Queue<Packet> results) {
    }

    @Override
    public void check1Hour(Queue<Packet> results) {
    }

    @Override
    public void check1Min(Queue<Packet> results) {
    }

    @Override
    public String commandsHelp() {
        return "";
    }

    @Override
    public String runCommand(String[] command2) {
        return null;
    }

    @Override
    public boolean isMonitorCommand(String command2) {
        return false;
    }

    @Override
    public void getStatistics(StatisticsList list) {
    }
}

