/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.sreceiver.PropertyConstants;
import tigase.server.sreceiver.PropertyItem;
import tigase.server.sreceiver.RepoRosterTask;
import tigase.xml.XMLUtils;
import tigase.xmpp.StanzaType;

public class ShortNewsPublisher
extends RepoRosterTask {
    private static final String DB_CONNECTION_DISPL_NAME = "Database connection string";
    private static final String DB_CONNECTION_PROP_KEY = "db-connection-string";
    private static final String DB_CONNECTION_PROP_VAL = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
    private static final String DB_TABLE_DISPL_NAME = "Database table name";
    private static final String DB_TABLE_PROP_KEY = "db-table";
    private static final String DB_TABLE_PROP_VAL = "short_news";
    private static final String NEWS_TYPE_DISPL_NAME = "News type";
    private static final String NEWS_TYPE_PROP_KEY = "news-type";
    private static final String NEWS_TYPE_PROP_VAL = "minis";
    private static final String TASK_HELP = "This tasks writes all messages to special table in database called 'short_news' and notifies all subscribed users about new post. Table in database keeps following information about post: publishing_time, author, subject, body. This subscription task is ideal for publish short news on your Web site. Users can subscribe to the news just by adding task JID to their roster, unsubscribing is equally simple - remove JID from roster to stop receiving news. By default subscription to this task is moderated.";
    private static final String TASK_TYPE = "Short news publisher";
    private static final Logger log = Logger.getLogger("tigase.server.ssender.JDBCTask");
    private Connection conn = null;
    private PreparedStatement conn_valid_st = null;
    private long connectionValidateInterval = 60000L;
    private String db_conn = null;
    private PreparedStatement delete_post = null;
    private PreparedStatement insert_post = null;
    private long lastConnectionValidated = 0L;
    private String newsType = "minis";
    private String tableName = "short_news";
    private PreparedStatement update_post = null;

    @Override
    public void destroy(Queue<Packet> results) {
        super.destroy(results);
        try {
            this.conn_valid_st.close();
            this.insert_post.close();
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Map<String, PropertyItem> getDefaultParams() {
        Map<String, PropertyItem> defs = super.getDefaultParams();
        defs.put("message-type", new PropertyItem("message-type", "Message type", PropertyConstants.MessageType.NORMAL));
        defs.put("subscription-restr", new PropertyItem("subscription-restr", "Subscription restrictions", PropertyConstants.SubscrRestrictions.MODERATED));
        defs.put("description", new PropertyItem("description", "Description", "Short news for the Web site..."));
        defs.put(DB_CONNECTION_PROP_KEY, new PropertyItem(DB_CONNECTION_PROP_KEY, DB_CONNECTION_DISPL_NAME, DB_CONNECTION_PROP_VAL));
        defs.put(DB_TABLE_PROP_KEY, new PropertyItem(DB_TABLE_PROP_KEY, DB_TABLE_DISPL_NAME, DB_TABLE_PROP_VAL));
        defs.put(NEWS_TYPE_PROP_KEY, new PropertyItem(NEWS_TYPE_PROP_KEY, NEWS_TYPE_DISPL_NAME, NEWS_TYPE_PROP_VAL));
        return defs;
    }

    @Override
    public String getHelp() {
        return TASK_HELP;
    }

    @Override
    public String getType() {
        return TASK_TYPE;
    }

    @Override
    public void setParams(Map<String, Object> map) {
        super.setParams(map);
        Map<String, PropertyItem> props = this.getParams();
        if (map.get(DB_TABLE_PROP_KEY) != null) {
            this.tableName = (String)map.get(DB_TABLE_PROP_KEY);
            props.put(DB_TABLE_PROP_KEY, new PropertyItem(DB_TABLE_PROP_KEY, DB_TABLE_DISPL_NAME, this.tableName));
        }
        if (map.get(NEWS_TYPE_PROP_KEY) != null) {
            this.newsType = (String)map.get(NEWS_TYPE_PROP_KEY);
            props.put(NEWS_TYPE_PROP_KEY, new PropertyItem(NEWS_TYPE_PROP_KEY, NEWS_TYPE_DISPL_NAME, this.newsType));
        }
        if (map.get(DB_CONNECTION_PROP_KEY) != null) {
            this.db_conn = (String)map.get(DB_CONNECTION_PROP_KEY);
            props.put(DB_CONNECTION_PROP_KEY, new PropertyItem(DB_CONNECTION_PROP_KEY, DB_CONNECTION_DISPL_NAME, this.db_conn));
            try {
                this.initRepo();
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "Problem initializing database connection.", e);
            }
        }
    }

    @Override
    protected void processMessage(Packet packet, Queue<Packet> results) {
        if (this.isPostCommand(packet)) {
            this.runCommand(packet, results);
        } else {
            super.processMessage(packet, results);
            this.addPost(packet, results);
        }
    }

    private void addPost(Packet packet, Queue<Packet> results) {
        try {
            this.checkConnection();
            String author = packet.getStanzaFrom().getBareJID().toString();
            String subject = packet.getElemCData("/message/subject");
            String body = packet.getElemCData("/message/body");
            if (body != null) {
                if (subject == null || subject.length() == 0) {
                    int dotIdx = body.indexOf(46);
                    subject = dotIdx > 0 ? body.substring(0, dotIdx) : "--";
                }
                this.insert_post.setString(1, author);
                this.insert_post.setString(2, XMLUtils.unescape((String)subject));
                this.insert_post.setString(3, XMLUtils.unescape((String)body));
                this.insert_post.executeUpdate();
                results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.chat, "Your post has been successfuly submitted.", "Short news submitions result.", null, packet.getStanzaId()));
            } else {
                results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.normal, "Missing body, post has NOT been submitted.", "Short news submitions result.", null, packet.getStanzaId()));
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Problem inserting new post: " + packet.toString(), e);
            results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.normal, "There was a problem with post submitting: " + e, "Short news submitions result.", null, packet.getStanzaId()));
        }
    }

    private boolean checkConnection() throws SQLException {
        try {
            long tmp = System.currentTimeMillis();
            if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                this.conn_valid_st.executeQuery();
                this.lastConnectionValidated = tmp;
            }
        }
        catch (Exception e) {
            this.initRepo();
        }
        return true;
    }

    private String commandsHelp() {
        return "Available commands are:\n//help - display this help info\n//update N - update post number N, posts content to update\n             starts from the next line\n//delete N - remove post number N";
    }

    private void deletePost(long snid) throws SQLException {
        this.checkConnection();
        this.delete_post.setLong(1, snid);
        this.delete_post.executeUpdate();
    }

    private void initRepo() throws SQLException {
        this.conn = DriverManager.getConnection(this.db_conn);
        this.conn.setAutoCommit(true);
        String query = "select 1;";
        this.conn_valid_st = this.conn.prepareStatement(query);
        query = this.newsType == null || this.newsType.length() == 0 ? "insert into " + this.tableName + " (news_type, author, subject, body) " + " values (null, ?, ?, ?)" : "insert into " + this.tableName + " (news_type, author, subject, body) " + " values ('" + this.newsType + "', ?, ?, ?)";
        this.insert_post = this.conn.prepareStatement(query);
        query = "delete from " + this.tableName + " where snid = ?";
        this.delete_post = this.conn.prepareStatement(query);
        query = "update " + this.tableName + " set subject = ?, body = ?" + " where snid = ? ";
        this.update_post = this.conn.prepareStatement(query);
    }

    private boolean isPostCommand(Packet packet) {
        String body = packet.getElemCData("/message/body");
        if (body != null) {
            for (command comm : command.values()) {
                if (!body.startsWith("//" + comm.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private void runCommand(Packet packet, Queue<Packet> results) {
        String body = packet.getElemCData("/message/body");
        String[] body_split = body.split(" |\n|\r");
        try {
            command comm = command.valueOf(body_split[0].substring(2));
            switch (comm) {
                case help: {
                    results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.chat, this.commandsHelp(), "Commands description", null, packet.getStanzaId()));
                    break;
                }
                case update: {
                    this.updatePost(packet, Long.parseLong(body_split[1]));
                    results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.normal, "Post " + body_split[1] + " successfuly updated.", "Command execution result", null, packet.getStanzaId()));
                    break;
                }
                case delete: {
                    this.deletePost(Long.parseLong(body_split[1]));
                    results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.normal, "Post " + body_split[1] + " successfuly deleted.", "Command execution result", null, packet.getStanzaId()));
                    break;
                }
            }
        }
        catch (Exception e) {
            String error_text = "Hm, something wrong with command executing...: " + body_split[0] + ", " + body_split[1] + ", " + e;
            log.log(Level.WARNING, error_text, e);
            results.offer(Message.getMessage(packet.getStanzaTo(), packet.getStanzaFrom(), StanzaType.normal, error_text, "Problem with command execution", null, packet.getStanzaId()));
        }
    }

    private void updatePost(Packet packet, long snid) throws SQLException {
        this.checkConnection();
        String subject = packet.getElemCData("/message/subject");
        String body = packet.getElemCData("/message/body");
        if (body != null && subject != null) {
            int idx = body.indexOf(10);
            if (idx > 0 && idx < body.length() - 1 && body.charAt(idx + 1) == '\r') {
                ++idx;
            }
            this.update_post.setString(1, XMLUtils.unescape((String)subject));
            this.update_post.setString(2, XMLUtils.unescape((String)body.substring(idx)));
            this.update_post.setLong(3, snid);
            this.update_post.executeUpdate();
        }
    }

    private static enum command {
        help,
        delete,
        update;

    }
}

