/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.security.KeyStore;
import java.security.cert.CertificateParsingException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import tigase.io.SSLContextContainerIfc;

public abstract class TLSUtil {
    private static final Logger log = Logger.getLogger(TLSUtil.class.getName());
    private static SSLContextContainerIfc sslContextContainer = null;

    public static void addCertificate(Map<String, String> params) throws CertificateParsingException {
        sslContextContainer.addCertificates(params);
    }

    public static void configureSSLContext(Map<String, Object> params) {
        String sslCC_class = (String)params.get("ssl-container-class");
        if (sslCC_class == null) {
            sslCC_class = SSLContextContainerIfc.SSL_CONTAINER_CLASS_VAL;
        }
        try {
            sslContextContainer = (SSLContextContainerIfc)Class.forName(sslCC_class).newInstance();
            sslContextContainer.init(params);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not initialize SSL Container: " + sslCC_class, e);
            sslContextContainer = null;
        }
    }

    public static SSLContext getSSLContext(String protocol, String hostname) {
        return sslContextContainer.getSSLContext(protocol, hostname);
    }

    public static KeyStore getTrustStore() {
        return sslContextContainer.getTrustStore();
    }
}

