/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.comp;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.comp.ComponentRepository;
import tigase.db.comp.RepositoryChangeListenerIfc;
import tigase.db.comp.RepositoryItem;

public abstract class ConfigRepository<Item extends RepositoryItem>
implements ComponentRepository<Item> {
    private static final Logger log = Logger.getLogger(ConfigRepository.class.getName());
    protected ConcurrentSkipListMap<String, Item> items = new ConcurrentSkipListMap();
    private RepositoryChangeListenerIfc<Item> repoChangeList = null;

    @Override
    public void addRepoChangeListener(RepositoryChangeListenerIfc<Item> repoChangeListener) {
        this.repoChangeList = repoChangeListener;
    }

    @Override
    public void removeRepoChangeListener(RepositoryChangeListenerIfc<Item> repoChangeListener) {
        this.repoChangeList = null;
    }

    public String toString() {
        return this.items.toString();
    }

    public abstract String getConfigKey();

    public abstract String[] getDefaultPropetyItems();

    public abstract String getPropertyKey();

    @Override
    public void addItem(Item item) {
        this.items.put(item.getKey(), item);
        this.store();
    }

    @Override
    public Collection<Item> allItems() {
        return this.items.values();
    }

    @Override
    public boolean contains(String key) {
        return this.items.keySet().contains(key);
    }

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        String[] items_arr = this.getDefaultPropetyItems();
        if (params.get(this.getPropertyKey()) != null) {
            items_arr = ((String)params.get(this.getPropertyKey())).split(",");
        }
        defs.put(this.getConfigKey(), items_arr);
    }

    @Override
    public Item getItem(String key) {
        return (Item)((RepositoryItem)this.items.get(key));
    }

    @Override
    public Iterator<Item> iterator() {
        return this.items.values().iterator();
    }

    @Override
    public void reload() {
    }

    @Override
    public void removeItem(String key) {
        this.items.remove(key);
        this.store();
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        String[] items_arr = (String[])properties.get(this.getConfigKey());
        if (items_arr != null && items_arr.length > 0) {
            this.items.clear();
            for (String it : items_arr) {
                log.log(Level.CONFIG, "Loading config item: {0}", it);
                Object item = this.getItemInstance();
                item.initFromPropertyString(it);
                this.items.put(item.getKey(), item);
            }
        } else {
            log.warning("Items list is not set in the configuration file!!");
        }
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public void store() {
    }

    @Override
    public String validateItem(Item item) {
        return null;
    }
}

