/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import tigase.db.AuthRepository;
import tigase.db.AuthRepositoryPool;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataRepositoryPool;
import tigase.db.UserRepository;
import tigase.db.UserRepositoryPool;

public abstract class RepositoryFactory {
    public static final String DATA_REPO_CLASS_PROP_KEY = "data-repo";
    public static final String DATA_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.DataRepositoryImpl";
    public static final String DATA_REPO_POOL_CLASS_PROP_KEY = "data-repo-pool";
    public static final String DATA_REPO_POOL_CLASS_PROP_VAL = "tigase.db.DataRepositoryPool";
    public static final String DATA_REPO_POOL_SIZE_PROP_KEY = "data-repo-pool-size";
    public static final int DATA_REPO_POOL_SIZE_PROP_VAL = 10;
    public static final String AUTH_REPO_CLASS_PROP_KEY = "auth-repo-class";
    public static final String AUTH_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.TigaseCustomAuth";
    public static final String AUTH_REPO_POOL_CLASS_PROP_KEY = "auth-repo-pool";
    public static final String AUTH_REPO_POOL_CLASS_PROP_DEF = "tigase.db.AuthRepositoryPool";
    public static final String AUTH_REPO_POOL_CLASS_PROP_VAL = null;
    public static final String AUTH_REPO_POOL_SIZE_PROP_KEY = "auth-repo-pool-size";
    public static final int AUTH_REPO_POOL_SIZE_PROP_VAL = 10;
    public static final String USER_REPO_CLASS_PROP_KEY = "user-repo-class";
    public static final String USER_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.JDBCRepository";
    public static final String USER_REPO_POOL_CLASS_PROP_KEY = "user-repo-pool";
    public static final String USER_REPO_POOL_CLASS_PROP_DEF = "tigase.db.UserRepositoryPool";
    public static final String USER_REPO_POOL_CLASS_PROP_VAL = null;
    public static final String USER_REPO_POOL_SIZE_PROP_KEY = "user-repo-pool-size";
    public static final int USER_REPO_POOL_SIZE_PROP_VAL = 10;
    private static ConcurrentMap<String, UserRepository> user_repos = new ConcurrentHashMap<String, UserRepository>(5);
    private static ConcurrentMap<String, AuthRepository> auth_repos = new ConcurrentHashMap<String, AuthRepository>(5);
    private static ConcurrentMap<String, DataRepository> data_repos = new ConcurrentHashMap<String, DataRepository>(10);

    public static AuthRepository getAuthRepository(String class_name, String resource, Map<String, String> params) throws ClassNotFoundException, InstantiationException, IllegalAccessException, DBInitException {
        AuthRepository repo;
        String cls = class_name;
        if (cls == null) {
            cls = System.getProperty(AUTH_REPO_CLASS_PROP_KEY, AUTH_REPO_CLASS_PROP_VAL);
        }
        if ((repo = (AuthRepository)auth_repos.get((cls = RepositoryFactory.getRepoClass(cls)) + resource)) == null) {
            if (System.getProperty(AUTH_REPO_POOL_CLASS_PROP_KEY, AUTH_REPO_POOL_CLASS_PROP_VAL) != null) {
                int repo_pool_size = Integer.getInteger(AUTH_REPO_POOL_SIZE_PROP_KEY, 10);
                AuthRepositoryPool repo_pool = (AuthRepositoryPool)Class.forName(System.getProperty(AUTH_REPO_POOL_CLASS_PROP_KEY, AUTH_REPO_POOL_CLASS_PROP_VAL)).newInstance();
                repo_pool.initRepository(resource, params);
                for (int i = 0; i < repo_pool_size; ++i) {
                    repo = (AuthRepository)Class.forName(cls).newInstance();
                    repo.initRepository(resource, params);
                    repo_pool.addRepo(repo);
                }
                repo = repo_pool;
            } else {
                repo = (AuthRepository)Class.forName(cls).newInstance();
                repo.initRepository(resource, params);
            }
            auth_repos.put(cls + resource, repo);
        }
        return repo;
    }

    public static DataRepository getDataRepository(String class_name, String resource, Map<String, String> params) throws ClassNotFoundException, InstantiationException, IllegalAccessException, DBInitException, SQLException {
        DataRepository repo;
        String cls = class_name;
        if (cls == null) {
            cls = System.getProperty(DATA_REPO_CLASS_PROP_KEY, DATA_REPO_CLASS_PROP_VAL);
        }
        if ((repo = (DataRepository)data_repos.get(cls + resource)) == null) {
            int repo_pool_size = Integer.getInteger(DATA_REPO_POOL_SIZE_PROP_KEY, 10);
            DataRepositoryPool repo_pool = (DataRepositoryPool)Class.forName(System.getProperty(DATA_REPO_POOL_CLASS_PROP_KEY, DATA_REPO_POOL_CLASS_PROP_VAL)).newInstance();
            repo_pool.initRepository(resource, params);
            for (int i = 0; i < repo_pool_size; ++i) {
                repo = (DataRepository)Class.forName(cls).newInstance();
                repo.initRepository(resource, params);
                repo_pool.addRepo(repo);
            }
            repo = repo_pool;
            data_repos.put(cls + resource, repo);
        }
        return repo;
    }

    public static String getRepoClass(String repo_name) {
        String result = repo_name;
        if (repo_name.equals("mysql")) {
            result = USER_REPO_CLASS_PROP_VAL;
        }
        if (repo_name.equals("pgsql")) {
            result = USER_REPO_CLASS_PROP_VAL;
        }
        if (repo_name.equals("derby")) {
            result = USER_REPO_CLASS_PROP_VAL;
        }
        if (repo_name.equals("tigase-custom-auth") || repo_name.equals("tigase-custom") || repo_name.equals("custom-auth")) {
            result = AUTH_REPO_CLASS_PROP_VAL;
        }
        if (repo_name.equals("tigase-auth")) {
            result = "tigase.db.jdbc.TigaseAuth";
        }
        if (repo_name.equals("drupal") || repo_name.equals("wp")) {
            result = "tigase.db.jdbc.DrupalWPAuth";
        }
        if (repo_name.equals("libresource")) {
            result = "tigase.db.jdbc.LibreSourceAuth";
        }
        return result;
    }

    public static UserRepository getUserRepository(String class_name, String resource, Map<String, String> params) throws ClassNotFoundException, InstantiationException, IllegalAccessException, DBInitException {
        UserRepository repo;
        String cls = class_name;
        if (cls == null) {
            cls = System.getProperty(USER_REPO_CLASS_PROP_KEY, USER_REPO_CLASS_PROP_VAL);
        }
        if ((repo = (UserRepository)user_repos.get((cls = RepositoryFactory.getRepoClass(cls)) + resource)) == null) {
            if (System.getProperty(USER_REPO_POOL_CLASS_PROP_KEY, USER_REPO_POOL_CLASS_PROP_VAL) != null) {
                int repo_pool_size = Integer.getInteger(USER_REPO_POOL_SIZE_PROP_KEY, 10);
                UserRepositoryPool repo_pool = (UserRepositoryPool)Class.forName(System.getProperty(USER_REPO_POOL_CLASS_PROP_KEY, USER_REPO_POOL_CLASS_PROP_VAL)).newInstance();
                repo_pool.initRepository(resource, params);
                for (int i = 0; i < repo_pool_size; ++i) {
                    repo = (UserRepository)Class.forName(cls).newInstance();
                    repo.initRepository(resource, params);
                    repo_pool.addRepo(repo);
                }
                repo = repo_pool;
            } else {
                repo = (UserRepository)Class.forName(cls).newInstance();
                repo.initRepository(resource, params);
            }
            user_repos.put(cls + resource, repo);
        }
        return repo;
    }
}

