/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.xep0136;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DataRepository;
import tigase.db.RepositoryFactory;
import tigase.server.Packet;
import tigase.util.SimpleCache;
import tigase.xmpp.BareJID;

public class MessageArchiveDB {
    private static final Logger log = Logger.getLogger(MessageArchiveDB.class.getName());
    private static final long LONG_NULL = 0L;
    private static final String ADD_JID_QUERY = "insert into tig_ma_jid (jid) values (?)";
    private static final String GET_JID_ID_QUERY = "select ma_j_id from tig_ma_jid where jid = ?";
    private static final String GET_JID_IDS_QUERY = "select * from tig_ma_jid where (jid = ?) or (jid = ?)";
    private static final String ADD_THREAD_QUERY = "insert into tig_ma_thread (thread) values (?)";
    private static final String GET_THREAD_ID_QUERY = "select ma_t_id from tig_ma_thread where (thread = ?)";
    private static final String ADD_SUBJECT_QUERY = "insert into tig_ma_subject (subject) values (?)";
    private static final String GET_SUBJECT_ID_QUERY = "select ma_s_id from tig_ma_subject where (subject = ?)";
    private Map<String, Object> cache = null;
    private int cacheSize = 10000;
    private long cacheTime = 3600000L;
    private DataRepository data_repo = null;

    public void getMessages(String jid, String with_jid, Date timestamp, int limit) {
    }

    public void initRepository(String conn_str, Map<String, String> params) throws SQLException {
        try {
            this.data_repo = RepositoryFactory.getDataRepository(null, conn_str, params);
            this.data_repo.initPreparedStatement(ADD_JID_QUERY, ADD_JID_QUERY);
            this.data_repo.initPreparedStatement(GET_JID_ID_QUERY, GET_JID_ID_QUERY);
            this.data_repo.initPreparedStatement(GET_JID_IDS_QUERY, GET_JID_IDS_QUERY);
            this.data_repo.initPreparedStatement(ADD_THREAD_QUERY, ADD_THREAD_QUERY);
            this.data_repo.initPreparedStatement(GET_THREAD_ID_QUERY, GET_THREAD_ID_QUERY);
            this.data_repo.initPreparedStatement(ADD_SUBJECT_QUERY, ADD_SUBJECT_QUERY);
            this.data_repo.initPreparedStatement(GET_SUBJECT_ID_QUERY, GET_SUBJECT_ID_QUERY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cache = Collections.synchronizedMap(new SimpleCache(10000, 60000L));
    }

    public void saveMessage(Packet message, boolean full_content, String defLang) throws SQLException {
        BareJID from_str = message.getStanzaFrom().getBareJID();
        BareJID to_str = message.getStanzaTo().getBareJID();
        long[] ids = this.getJidsIds(from_str.toString(), to_str.toString());
        long from_id = ids[0] != 0L ? ids[0] : this.addJidID(from_str.toString());
        long to_id = ids[1] != 0L ? ids[1] : this.addJidID(to_str.toString());
        String thread = message.getElemCData("/message/thread");
        long thread_id = 0L;
        String subject = message.getElemCData("/message/subject");
        long subject_id = 0L;
        if (thread != null && !thread.trim().isEmpty()) {
            thread_id = this.addThreadID(thread);
        }
        if (subject != null && !subject.trim().isEmpty()) {
            subject_id = this.addSubjectID(subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addJidID(String jid) throws SQLException {
        PreparedStatement add_jid_st;
        PreparedStatement preparedStatement = add_jid_st = this.data_repo.getPreparedStatement(null, ADD_JID_QUERY);
        synchronized (preparedStatement) {
            add_jid_st.setString(1, jid);
            add_jid_st.executeUpdate();
        }
        long[] jid_ids = this.getJidsIds(jid);
        if (jid_ids != null) {
            return jid_ids[0];
        }
        log.log(Level.WARNING, "I have just added new jid but it was not found.... {0}", jid);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addSubjectID(String subject) throws SQLException {
        PreparedStatement add_subject_st;
        long result = this.getSubjectID(subject);
        if (result != 0L) {
            return result;
        }
        PreparedStatement preparedStatement = add_subject_st = this.data_repo.getPreparedStatement(null, ADD_SUBJECT_QUERY);
        synchronized (preparedStatement) {
            add_subject_st.setString(1, subject);
            add_subject_st.executeUpdate();
        }
        result = this.getSubjectID(subject);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addThreadID(String thread) throws SQLException {
        PreparedStatement add_thread_st;
        long result = this.getThreadID(thread);
        if (result != 0L) {
            return result;
        }
        PreparedStatement preparedStatement = add_thread_st = this.data_repo.getPreparedStatement(null, ADD_THREAD_QUERY);
        synchronized (preparedStatement) {
            add_thread_st.setString(1, thread);
            add_thread_st.executeUpdate();
        }
        result = this.getThreadID(thread);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long[] getJidsIds(String ... jids) throws SQLException {
        long[] lArray;
        ResultSet rs = null;
        try {
            PreparedStatement get_jids_id_st;
            long[] results = new long[jids.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = 0L;
            }
            if (jids.length == 1) {
                PreparedStatement get_jid_id_st;
                PreparedStatement preparedStatement = get_jid_id_st = this.data_repo.getPreparedStatement(null, GET_JID_ID_QUERY);
                synchronized (preparedStatement) {
                    get_jid_id_st.setString(1, jids[0]);
                    rs = get_jid_id_st.executeQuery();
                    if (rs.next()) {
                        results[0] = rs.getLong("ma_j_id");
                        long[] lArray2 = results;
                        // MONITOREXIT @DISABLED, blocks:[0, 16, 17, 8] lbl15 : MonitorExitStatement: MONITOREXIT : var5_7
                        this.data_repo.release(null, rs);
                        return lArray2;
                    }
                }
                preparedStatement = null;
                this.data_repo.release(null, rs);
                return preparedStatement;
            }
            PreparedStatement preparedStatement = get_jids_id_st = this.data_repo.getPreparedStatement(null, GET_JID_IDS_QUERY);
            synchronized (preparedStatement) {
                for (int i = 0; i < jids.length; ++i) {
                    get_jids_id_st.setString(i + 1, jids[i]);
                }
                rs = get_jids_id_st.executeQuery();
                int cnt = 0;
                while (rs.next()) {
                    String db_jid = rs.getString("jid");
                    for (int i = 0; i < jids.length; ++i) {
                        if (!db_jid.equals(jids[i])) continue;
                        results[i] = rs.getLong("ma_j_id");
                        ++cnt;
                    }
                }
                if (cnt > 0) {
                    lArray = results;
                    // MONITOREXIT @DISABLED, blocks:[0, 9, 15] lbl39 : MonitorExitStatement: MONITOREXIT : var5_8
                    this.data_repo.release(null, rs);
                    return lArray;
                }
                lArray = null;
            }
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        this.data_repo.release(null, rs);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getSubjectID(String subject) throws SQLException {
        ResultSet rs = null;
        try {
            PreparedStatement get_subject_id_st;
            PreparedStatement preparedStatement = get_subject_id_st = this.data_repo.getPreparedStatement(null, GET_SUBJECT_ID_QUERY);
            synchronized (preparedStatement) {
                get_subject_id_st.setString(1, subject);
                rs = get_subject_id_st.executeQuery();
                if (rs.next()) {
                    long l = rs.getLong("ma_s_id");
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl9 : MonitorExitStatement: MONITOREXIT : var4_4
                    this.data_repo.release(null, rs);
                    return l;
                }
            }
            this.data_repo.release(null, rs);
            return 0L;
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getThreadID(String thread) throws SQLException {
        ResultSet rs = null;
        try {
            PreparedStatement get_thread_id_st;
            PreparedStatement preparedStatement = get_thread_id_st = this.data_repo.getPreparedStatement(null, GET_THREAD_ID_QUERY);
            synchronized (preparedStatement) {
                get_thread_id_st.setString(1, thread);
                rs = get_thread_id_st.executeQuery();
                if (rs.next()) {
                    long l = rs.getLong("ma_t_id");
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl9 : MonitorExitStatement: MONITOREXIT : var4_4
                    this.data_repo.release(null, rs);
                    return l;
                }
            }
            this.data_repo.release(null, rs);
            return 0L;
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
    }
}

