/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class SaslAuth
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final String XMLNS = "urn:ietf:params:xml:ns:xmpp-sasl";
    private static final Logger log = Logger.getLogger(SaslAuth.class.getName());
    private static final String ID = "urn:ietf:params:xml:ns:xmpp-sasl";
    private static final String[] ELEMENTS = new String[]{"auth", "response", "challenge", "failure", "success", "abort"};
    private static final String[] XMLNSS = new String[]{"urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"})};

    @Override
    public int concurrentQueuesNo() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public String id() {
        return "urn:ietf:params:xml:ns:xmpp-sasl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null) {
            return;
        }
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            if (session.getSessionData("authentication-timeout") != null) {
                return;
            }
            if (session.isAuthorized()) {
                Packet res = packet.swapFromTo(this.createReply(ElementType.failure, "<not-authorized/>"), null, null);
                res.setPriority(Priority.SYSTEM);
                results.offer(res);
                results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Discovered second authentication attempt: {0}, packet: {1}", new Object[]{session.toString(), packet.toString()});
                }
                try {
                    session.logout();
                }
                catch (NotAuthorizedException ex) {
                    log.log(Level.FINER, "Unsuccessful session logout: {0}", session.toString());
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Session after logout: {0}", session.toString());
                }
            }
            Element request = packet.getElement();
            HashMap<String, Object> authProps = (HashMap<String, Object>)session.getSessionData("urn:ietf:params:xml:ns:xmpp-sasl-authProps");
            if (authProps == null) {
                authProps = new HashMap<String, Object>(10, 0.75f);
                authProps.put("protocol", "sasl");
                authProps.put("mechanism", request.getAttribute("/auth", "mechanism"));
                authProps.put("realm", session.getDomain().getVhost().getDomain());
                authProps.put("server-name", session.getDomain().getVhost().getDomain());
                session.putSessionData("urn:ietf:params:xml:ns:xmpp-sasl-authProps", authProps);
            }
            authProps.put("data", request.getCData());
            try {
                Authorization result = session.loginOther(authProps);
                String challenge_data = (String)authProps.get("result");
                if (result == Authorization.AUTHORIZED) {
                    results.offer(packet.swapFromTo(this.createReply(ElementType.success, challenge_data), null, null));
                    authProps.clear();
                    session.removeSessionData("urn:ietf:params:xml:ns:xmpp-sasl-authProps");
                } else {
                    results.offer(packet.swapFromTo(this.createReply(ElementType.challenge, challenge_data), null, null));
                }
            }
            catch (UserNotFoundException e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "User not found: {0}", e.getMessage());
                }
                session.removeSessionData("urn:ietf:params:xml:ns:xmpp-sasl-authProps");
                Packet response = packet.swapFromTo(this.createReply(ElementType.failure, "<not-authorized/>"), null, null);
                response.setPriority(Priority.SYSTEM);
                results.offer(response);
                Integer retries = (Integer)session.getSessionData("auth-retries");
                if (retries == null) {
                    retries = new Integer(0);
                }
                if (retries < 3) {
                    session.putSessionData("auth-retries", new Integer(retries + 1));
                } else {
                    results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                }
            }
            catch (Exception e) {
                log.log(Level.INFO, "Authentication failed: ", e);
                session.removeSessionData("urn:ietf:params:xml:ns:xmpp-sasl-authProps");
                Packet response = packet.swapFromTo(this.createReply(ElementType.failure, "<not-authorized/>"), null, null);
                response.setPriority(Priority.SYSTEM);
                results.offer(response);
                Integer retries = (Integer)session.getSessionData("auth-retries");
                if (retries == null) {
                    retries = new Integer(0);
                }
                if (retries < 3) {
                    session.putSessionData("auth-retries", new Integer(retries + 1));
                }
                results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null || session.isAuthorized()) {
            return null;
        }
        try {
            HashMap<String, Object> query = new HashMap<String, Object>();
            query.put("protocol", "sasl");
            session.queryAuth(query);
            String[] auth_mechs = (String[])query.get("result");
            Element[] mechs = new Element[auth_mechs.length];
            int idx = 0;
            for (String mech : auth_mechs) {
                mechs[idx++] = new Element("mechanism", mech);
            }
            return new Element[]{new Element("mechanisms", mechs, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"})};
        }
        catch (TigaseDBException ex) {
            log.warning("Database problem: " + ex);
            return null;
        }
    }

    private Element createReply(ElementType type, String cdata) {
        Element reply = new Element(type.toString());
        reply.setXMLNS("urn:ietf:params:xml:ns:xmpp-sasl");
        if (cdata != null) {
            reply.setCData(cdata);
        }
        return reply;
    }

    public static enum ElementType {
        auth,
        abort,
        response,
        challenge,
        failure,
        success;

    }
}

