/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.server.amp.MsgRepository;
import tigase.util.DNSResolver;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.Message;
import tigase.xmpp.impl.OfflineMessages;

public class MessageAmp
extends XMPPProcessor
implements XMPPPostprocessorIfc,
XMPPProcessorIfc {
    private static Logger log = Logger.getLogger(MessageAmp.class.getName());
    private static final String FROM_CONN_ID = "from-conn-id";
    private static final String TO_CONN_ID = "to-conn-id";
    private static final String TO_RES = "to-res";
    private static final String OFFLINE = "offline";
    private static final String AMP_JID_PROP_KEY = "amp-jid";
    private static final String MSG_OFFLINE_PROP_KEY = "msg-offline";
    private static final String XMLNS = "http://jabber.org/protocol/amp";
    private static final String ID = "amp";
    private static final String[] ELEMENTS = new String[]{"message", "presence"};
    private static final String[] XMLNSS = new String[]{"jabber:client", "jabber:client"};
    private static Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/amp"}), new Element("feature", new String[]{"var"}, new String[]{"msgoffline"})};
    private JID ampJID = null;
    private MsgRepository msg_repo = null;
    private OfflineMessages offlineProcessor = new OfflineMessages();
    private Message messageProcessor = new Message();
    private static final String defHost = DNSResolver.getDefaultHostname();

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void init(Map<String, Object> settings) throws TigaseDBException {
        String msg_repo_uri;
        super.init(settings);
        String ampJIDstr = (String)settings.get(AMP_JID_PROP_KEY);
        this.ampJID = null != ampJIDstr ? JID.jidInstanceNS((String)ampJIDstr) : JID.jidInstanceNS((String)("amp@" + defHost));
        log.log(Level.CONFIG, "Loaded AMP_JID option: {0} = {1}", new Object[]{AMP_JID_PROP_KEY, this.ampJID});
        String off_val = (String)settings.get(MSG_OFFLINE_PROP_KEY);
        if (off_val == null) {
            off_val = System.getProperty(MSG_OFFLINE_PROP_KEY);
        }
        if (off_val != null && !Boolean.parseBoolean(off_val)) {
            log.log(Level.CONFIG, "Offline messages storage: {0}", new Object[]{off_val});
            this.offlineProcessor = null;
            DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{XMLNS})};
        }
        if ((msg_repo_uri = (String)settings.get("amp-repo-uri")) == null && (msg_repo_uri = System.getProperty("amp-repo-uri")) == null) {
            msg_repo_uri = System.getProperty("user-db-uri");
        }
        if (msg_repo_uri != null) {
            HashMap<String, String> db_props = new HashMap<String, String>(4);
            for (Map.Entry<String, Object> entry : settings.entrySet()) {
                db_props.put(entry.getKey(), entry.getValue().toString());
            }
            this.msg_repo = MsgRepository.getInstance(msg_repo_uri);
            try {
                this.msg_repo.initRepository(msg_repo_uri, db_props);
            }
            catch (SQLException ex) {
                this.msg_repo = null;
                log.log(Level.WARNING, "Problem initializing connection to DB: ", ex);
            }
        }
    }

    @Override
    public void postProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        block3: {
            Element amp;
            if (this.offlineProcessor != null && session == null && ((amp = packet.getElement().getChild(ID)) == null || amp.getXMLNS() != XMLNS || amp.getAttribute("status") != null)) {
                try {
                    this.offlineProcessor.savePacketForOffLineUser(packet, this.msg_repo);
                }
                catch (UserNotFoundException ex) {
                    if (!log.isLoggable(Level.FINEST)) break block3;
                    log.finest("UserNotFoundException at trying to save packet for off-line user." + packet);
                }
            }
        }
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (packet.getElemName() == "presence") {
            if (this.offlineProcessor != null && this.offlineProcessor.loadOfflineMessages(packet, session)) {
                try {
                    Queue<Packet> packets = this.offlineProcessor.restorePacketForOffLineUser(session, this.msg_repo);
                    if (packets != null) {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("Sending off-line messages: " + packets.size());
                        }
                        results.addAll(packets);
                    }
                }
                catch (UserNotFoundException e) {
                    log.info("Something wrong, DB problem, cannot load offline messages. " + e);
                }
            }
        } else {
            Element amp = packet.getElement().getChild(ID, XMLNS);
            if (amp == null || amp.getAttribute("status") != null) {
                this.messageProcessor.process(packet, session, repo, results, settings);
            } else {
                Packet result = packet.copyElementOnly();
                result.setPacketTo(this.ampJID);
                results.offer(result);
                if (session == null) {
                    result.getElement().addAttribute(OFFLINE, "1");
                    return;
                }
                if (session.isUserId(packet.getStanzaTo().getBareJID())) {
                    result.getElement().addAttribute(TO_CONN_ID, session.getConnectionId().toString());
                    result.getElement().addAttribute(TO_RES, session.getResource());
                } else {
                    JID connectionId = session.getConnectionId();
                    if (connectionId.equals((Object)packet.getPacketFrom())) {
                        result.getElement().addAttribute(FROM_CONN_ID, connectionId.toString());
                    }
                }
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }
}

