/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.Privacy;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;

public class JabberIqPrivacy
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPPreprocessorIfc,
XMPPPacketFilterIfc {
    private static Logger log = Logger.getLogger(JabberIqPrivacy.class.getName());
    private static final String XMLNS = "jabber:iq:privacy";
    private static final String ID = "jabber:iq:privacy";
    private static final String[] ELEMENTS = new String[]{"query"};
    private static final String[] XMLNSS = new String[]{"jabber:iq:privacy"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:privacy"})};
    private static final String PRIVACY_INIT_KEY = "privacy-init";
    private static final String LIST_EL_NAME = "list";
    private static final String DEFAULT_EL_NAME = "default";
    private static final String ACTIVE_EL_NAME = "active";
    private static final String PRESENCE_IN_EL_NAME = "presence-in";
    private static final String PRESENCE_OUT_EL_NAME = "presence-out";
    private static final String PRESENCE_EL_NAME = "presence";
    private static RosterAbstract roster_util = RosterFactory.getRosterImplementation(true);
    private static final Comparator<Element> compar = new Comparator<Element>(){

        @Override
        public int compare(Element el1, Element el2) {
            String or1 = el1.getAttribute("order");
            String or2 = el2.getAttribute("order");
            return or1.compareTo(or2);
        }
    };

    @Override
    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session == null || !session.isAuthorized() || results == null || results.size() == 0) {
            return;
        }
        Iterator it = results.iterator();
        while (it.hasNext()) {
            Packet res = (Packet)it.next();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Checking outbound packet: {0}", res);
            }
            if (res.getType() == StanzaType.unavailable || res.isXMLNS("/iq/query", "jabber:iq:privacy") || this.allowed(res, session)) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet not allowed to go, removing: {0}", res);
            }
            it.remove();
        }
    }

    @Override
    public String id() {
        return "jabber:iq:privacy";
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null || !session.isAuthorized() || packet.isXMLNS("/iq/query", "jabber:iq:privacy")) {
            return false;
        }
        return !this.allowed(packet, session);
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        try {
            StanzaType type = packet.getType();
            switch (type) {
                case get: {
                    this.processGetRequest(packet, session, results);
                    break;
                }
                case set: {
                    this.processSetRequest(packet, session, results);
                    break;
                }
                case result: 
                case error: {
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                    break;
                }
            }
        }
        catch (NotAuthorizedException e) {
            log.log(Level.WARNING, "Received privacy request but user session is not authorized yet: {0}", packet);
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
        catch (TigaseDBException e) {
            log.log(Level.WARNING, "Database proble, please contact admin: {0}", e);
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    private boolean allowed(Packet packet, XMPPResourceConnection session) {
        block34: {
            try {
                List items;
                if (session.getConnectionId().equals((Object)packet.getPacketFrom())) {
                    return true;
                }
                Element list = Privacy.getActiveList(session);
                if (list == null && session.getSessionData(PRIVACY_INIT_KEY) == null) {
                    session.putSessionData(PRIVACY_INIT_KEY, "");
                    String lName = Privacy.getDefaultList(session);
                    if (lName != null) {
                        Privacy.setActiveList(session, lName);
                        list = Privacy.getActiveList(session);
                    }
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Active privcy list: {0}", list);
                }
                if (list == null || (items = list.getChildren()) == null) break block34;
                Collections.sort(items, compar);
                for (Element item : items) {
                    boolean packetIn;
                    boolean elem_matched;
                    boolean type_matched;
                    block36: {
                        ITEM_TYPE type;
                        block35: {
                            type_matched = false;
                            elem_matched = false;
                            type = ITEM_TYPE.all;
                            if (item.getAttribute("type") != null) {
                                type = ITEM_TYPE.valueOf(item.getAttribute("type"));
                            }
                            String value = item.getAttribute("value");
                            BareJID sessionUserId = session.getBareJID();
                            JID jid = packet.getStanzaFrom();
                            packetIn = true;
                            if (jid == null || sessionUserId.equals((Object)jid.getBareJID())) {
                                jid = packet.getStanzaTo();
                                packetIn = false;
                            }
                            if (jid == null) break block35;
                            block1 : switch (type) {
                                case jid: {
                                    type_matched = jid.toString().contains(value);
                                    break;
                                }
                                case group: {
                                    String[] groups = roster_util.getBuddyGroups(session, jid);
                                    if (groups != null) {
                                        for (String group : groups) {
                                            type_matched = group.equals(value);
                                            if (type_matched) break block1;
                                        }
                                    }
                                    break block36;
                                }
                                case subscription: {
                                    ITEM_SUBSCRIPTIONS subscr = ITEM_SUBSCRIPTIONS.valueOf(value);
                                    switch (subscr) {
                                        case to: {
                                            type_matched = roster_util.isSubscribedTo(session, jid);
                                            break block1;
                                        }
                                        case from: {
                                            type_matched = roster_util.isSubscribedFrom(session, jid);
                                            break block1;
                                        }
                                        case none: {
                                            type_matched = !roster_util.isSubscribedFrom(session, jid) && !roster_util.isSubscribedTo(session, jid);
                                            break block1;
                                        }
                                        case both: {
                                            type_matched = roster_util.isSubscribedFrom(session, jid) && roster_util.isSubscribedTo(session, jid);
                                            break block1;
                                        }
                                    }
                                    break;
                                }
                                default: {
                                    type_matched = true;
                                }
                            }
                            break block36;
                        }
                        if (type == ITEM_TYPE.all) {
                            type_matched = true;
                        }
                    }
                    if (!type_matched) continue;
                    List elems = item.getChildren();
                    if (elems == null || elems.size() == 0) {
                        elem_matched = true;
                    } else {
                        for (Element elem : elems) {
                            if (packet.getElemName() == PRESENCE_EL_NAME && (packetIn && elem.getName() == PRESENCE_IN_EL_NAME || !packetIn && elem.getName() == PRESENCE_OUT_EL_NAME) && (packet.getType() == null || packet.getType() == StanzaType.unavailable)) {
                                elem_matched = true;
                                break;
                            }
                            if (!packetIn || elem.getName() != packet.getElemName()) continue;
                            elem_matched = true;
                            break;
                        }
                    }
                    if (elem_matched) {
                        ITEM_ACTION action = ITEM_ACTION.valueOf(item.getAttribute("action"));
                        switch (action) {
                            case allow: {
                                return true;
                            }
                            case deny: {
                                return false;
                            }
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (NoConnectionIdException e) {
            }
            catch (NotAuthorizedException e) {
            }
            catch (TigaseDBException e) {
                log.log(Level.WARNING, "Database problem, please notify the admin. {0}", e);
            }
        }
        return true;
    }

    private void processGetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, XMPPException, TigaseDBException {
        List<Element> children = packet.getElemChildren("/iq/query");
        if (children == null || children.size() == 0) {
            String[] lists = Privacy.getLists(session);
            if (lists != null) {
                StringBuilder sblists = new StringBuilder(100);
                for (String list : lists) {
                    sblists.append("<list name=\"").append(list).append("\"/>");
                }
                String list = Privacy.getDefaultList(session);
                if (list != null) {
                    sblists.append("<default name=\"").append(list).append("\"/>");
                }
                if ((list = Privacy.getActiveListName(session)) != null) {
                    sblists.append("<active name=\"").append(list).append("\"/>");
                }
                results.offer(packet.okResult(sblists.toString(), 1));
            } else {
                results.offer(packet.okResult((String)null, 1));
            }
        } else if (children.size() > 1) {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "You can retrieve only one list at a time.", true));
        } else {
            Element eList = Privacy.getList(session, children.get(0).getAttribute("name"));
            if (eList != null) {
                results.offer(packet.okResult(eList, 1));
            } else {
                results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Requested list not found.", true));
            }
        }
    }

    private void processSetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, XMPPException, TigaseDBException {
        List<Element> children = packet.getElemChildren("/iq/query");
        if (children != null && children.size() == 1) {
            Element child = children.get(0);
            if (child.getName() == LIST_EL_NAME) {
                List items;
                String name = child.getAttribute("name");
                if (name == null || name.length() == 0) {
                    child.setAttribute("name", DEFAULT_EL_NAME);
                }
                if ((items = child.getChildren()) == null || items.isEmpty()) {
                    boolean inUse = name.equals(Privacy.getDefaultList(session));
                    if (!inUse) {
                        for (XMPPResourceConnection activeSession : session.getActiveSessions()) {
                            inUse |= name.equals(Privacy.getActiveList(session));
                        }
                    }
                    if (inUse) {
                        results.offer(Authorization.CONFLICT.getResponseMessage(packet, null, true));
                    } else {
                        Privacy.removeList(session, child);
                        results.offer(packet.okResult((String)null, 0));
                    }
                } else {
                    Privacy.addList(session, child);
                    results.offer(packet.okResult((String)null, 0));
                }
            }
            if (child.getName() == DEFAULT_EL_NAME) {
                Privacy.setDefaultList(session, child);
                results.offer(packet.okResult((String)null, 0));
            }
            if (child.getName() == ACTIVE_EL_NAME) {
                String listName = child.getAttribute("name");
                Element list = Privacy.getList(session, listName);
                if (listName != null && list == null) {
                    results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Selected list not found on the server", true));
                } else {
                    Privacy.setActiveList(session, child.getAttribute("name"));
                    results.offer(packet.okResult((String)null, 0));
                }
            }
        } else {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Only 1 element is allowed in privacy set request.", true));
        }
    }

    private static enum ITEM_TYPE {
        jid,
        group,
        subscription,
        all;

    }

    private static enum ITEM_SUBSCRIPTIONS {
        both,
        to,
        from,
        none;

    }

    private static enum ITEM_ACTION {
        allow,
        deny;

    }
}

