/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class JabberIqAuth
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.JabberIqAuth");
    private static final String XMLNS = "jabber:iq:auth";
    private static final String ID = "jabber:iq:auth";
    private static final String[] ELEMENTS = new String[]{"query"};
    private static final String[] XMLNSS = new String[]{"jabber:iq:auth"};
    private static final Element[] FEATURES = new Element[]{new Element("auth", new String[]{"xmlns"}, new String[]{"http://jabber.org/features/iq-auth"})};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:auth"})};

    @Override
    public int concurrentQueuesNo() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public String id() {
        return "jabber:iq:auth";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            if (session.getSessionData("authentication-timeout") != null) {
                return;
            }
            if (session.isAuthorized()) {
                Packet res = Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "Cannot authenticate twice on the same stream.", false);
                res.setPriority(Priority.SYSTEM);
                results.offer(res);
                results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Discovered second authentication attempt: {0}, packet: {1}", new Object[]{session.toString(), packet.toString()});
                }
                try {
                    session.logout();
                }
                catch (NotAuthorizedException ex) {
                    log.log(Level.FINER, "Unsuccessful session logout: {0}", session.toString());
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Session after logout: {0}", session.toString());
                }
            }
            Element request = packet.getElement();
            StanzaType type = packet.getType();
            switch (type) {
                case get: {
                    HashMap<String, Object> query = new HashMap<String, Object>();
                    query.put("protocol", "nonsasl");
                    try {
                        session.queryAuth(query);
                        String[] auth_mechs = (String[])query.get("result");
                        StringBuilder response = new StringBuilder("<username/>");
                        for (String mech : auth_mechs) {
                            response.append("<").append(mech).append("/>");
                        }
                        response.append("<resource/>");
                        results.offer(packet.okResult(response.toString(), 1));
                    }
                    catch (NullPointerException ex) {
                        log.warning("Database problem, most likely misconfiguration error: " + ex);
                        results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
                    }
                    catch (TigaseDBException ex) {
                        log.warning("Database problem: " + ex);
                        results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
                    }
                    break;
                }
                case set: {
                    String user_name = request.getChildCData("/iq/query/username");
                    String resource = request.getChildCData("/iq/query/resource");
                    try {
                        List children = request.getChildren("/iq/query");
                        HashMap<String, Object> authProps = new HashMap<String, Object>(10, 0.75f);
                        authProps.put("protocol", "nonsasl");
                        authProps.put("realm", session.getDomain().getVhost().getDomain());
                        authProps.put("server-name", session.getDomain().getVhost().getDomain());
                        authProps.put("digest-id", session.getSessionId());
                        BareJID user_id = BareJID.bareJIDInstance((String)user_name, (String)session.getDomain().getVhost().getDomain());
                        authProps.put("user-id", user_id);
                        for (Element child : children) {
                            authProps.put(child.getName(), child.getCData());
                        }
                        Authorization result = session.loginOther(authProps);
                        if (result == Authorization.AUTHORIZED) {
                            if (resource != null && !resource.isEmpty()) {
                                session.setResource(resource);
                            }
                            results.offer(session.getAuthState().getResponseMessage(packet, "Authentication successful.", false));
                            break;
                        }
                        results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "Authentication failed", false));
                        results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                    }
                    catch (Exception e) {
                        log.info("Authentication failed: " + user_name);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Authorization exception: ", e);
                        }
                        Packet response = Authorization.NOT_AUTHORIZED.getResponseMessage(packet, e.getMessage(), false);
                        response.setPriority(Priority.SYSTEM);
                        results.offer(response);
                        Integer retries = (Integer)session.getSessionData("auth-retries");
                        if (retries == null) {
                            retries = new Integer(0);
                        }
                        if (retries < 3) {
                            session.putSessionData("auth-retries", new Integer(retries + 1));
                            break;
                        }
                        results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                    }
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", false));
                    results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, session.nextStanzaId()));
                }
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null || session.isAuthorized()) {
            return null;
        }
        return FEATURES;
    }
}

