/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.IOService;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.XMPPDomBuilderHandler;
import tigase.xmpp.XMPPIOServiceListener;

public class XMPPIOService<RefObject>
extends IOService<RefObject> {
    private static final Logger log = Logger.getLogger(XMPPIOService.class.getName());
    public static final String CROSS_DOMAIN_POLICY_FILE_PROP_KEY = "cross-domain-policy-file";
    public static final String CROSS_DOMAIN_POLICY_FILE_PROP_VAL = "etc/cross-domain-policy.xml";
    private XMPPDomBuilderHandler<RefObject> domHandler = null;
    protected SimpleParser parser = SingletonFactory.getParserInstance();
    private XMPPIOServiceListener serviceListener = null;
    private static String cross_domain_policy = null;
    private ConcurrentLinkedQueue<Packet> waitingPackets = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Packet> receivedPackets = new ConcurrentLinkedQueue();
    private String xmlns = null;
    private boolean firstPacket = true;
    public ReentrantLock writeInProgress = new ReentrantLock();

    public XMPPIOService() {
        this.domHandler = new XMPPDomBuilderHandler(this);
        if (cross_domain_policy == null) {
            String file_name = System.getProperty(CROSS_DOMAIN_POLICY_FILE_PROP_KEY, CROSS_DOMAIN_POLICY_FILE_PROP_VAL);
            try {
                BufferedReader br = new BufferedReader(new FileReader(file_name));
                String line = br.readLine();
                StringBuilder sb = new StringBuilder();
                while (line != null) {
                    sb.append(line);
                    line = br.readLine();
                }
                sb.append('\u0000');
                br.close();
                cross_domain_policy = sb.toString();
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Problem reading cross domain poicy file: " + file_name, ex);
            }
        }
    }

    public void addPacketToSend(Packet packet) {
        this.waitingPackets.offer(packet);
    }

    public Queue<Packet> getReceivedPackets() {
        return this.receivedPackets;
    }

    public String getXMLNS() {
        return this.xmlns;
    }

    @Override
    public void processWaitingPackets() throws IOException {
        Packet packet = null;
        while ((packet = this.waitingPackets.poll()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Sending packet: {1}", new Object[]{this.toString(), packet});
            }
            this.writeRawData(packet.getElement().toString());
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINEST, "{0}, SENT: {1}", new Object[]{this.toString(), packet.getElement().toString()});
        }
    }

    public void setIOServiceListener(XMPPIOServiceListener servList) {
        this.serviceListener = servList;
        super.setIOServiceListener(servList);
    }

    public void setXMLNS(String xmlns) {
        this.xmlns = xmlns;
    }

    @Override
    public void stop() {
        super.stop();
    }

    public void writeRawData(String data) throws IOException {
        this.writeData(data);
    }

    public void xmppStreamOpen(String data) {
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Sending data: {1}", new Object[]{this.toString(), data});
            }
            this.writeRawData(data);
            assert (this.debug(data, "--SENT:"));
        }
        catch (IOException e) {
            log.log(Level.WARNING, "{0}, Error sending stream open data: {1}", new Object[]{this.toString(), e});
            this.forceStop();
        }
    }

    protected void addReceivedPacket(Packet packet) {
        if (this.firstPacket && "policy-file-request".equals(packet.getElemName())) {
            log.fine("Got flash cross-domain request" + packet);
            if (cross_domain_policy != null) {
                try {
                    this.writeRawData(cross_domain_policy);
                }
                catch (Exception ex) {
                    log.log(Level.INFO, "Can't send cross-domain policy: ", ex);
                }
                log.log(Level.FINER, "Cross-domain policy sent: {1}", cross_domain_policy);
            } else {
                log.log(Level.FINER, "No cross-domain policy defined to sent.");
            }
        } else {
            this.receivedPackets.offer(packet);
        }
        this.firstPacket = false;
    }

    @Override
    protected void processSocketData() throws IOException {
        if (this.isConnected()) {
            char[] data = this.readData();
            while (this.isConnected() && data != null && data.length > 0) {
                boolean disconnect;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0}, READ:\n{1}", new Object[]{this.toString(), new String(data)});
                }
                if (disconnect = this.checkData(data)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "{0}, checkData says disconnect: {1}", new Object[]{this.toString(), new String(data)});
                    } else {
                        log.log(Level.WARNING, "{0}, checkData says disconnect", this.toString());
                    }
                    this.forceStop();
                    return;
                }
                assert (this.debug(new String(data), "--RECEIVED:"));
                Element elem = null;
                try {
                    this.parser.parse(this.domHandler, data, 0, data.length);
                    if (this.domHandler.parseError()) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "{0}, Data parsing error: {1}", new Object[]{this.toString(), new String(data)});
                        } else {
                            log.log(Level.WARNING, "{0}, data parsing error, stopping connection", this.toString());
                        }
                        this.forceStop();
                        return;
                    }
                    Queue<Element> elems = this.domHandler.getParsedElements();
                    if (elems.size() > 0) {
                        this.readCompleted();
                    }
                    while ((elem = elems.poll()) != null) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "{0}, Read packet: {1}", new Object[]{this.toString(), elem});
                        }
                        this.addReceivedPacket(Packet.packetInstance(elem));
                    }
                }
                catch (TigaseStringprepException ex) {
                    log.log(Level.INFO, this.toString() + ", Incorrect to/from JID format for stanza: " + elem.toString(), ex);
                }
                catch (Exception ex) {
                    log.log(Level.INFO, this.toString() + ", Incorrect XML data: " + new String(data) + ", stopping connection: " + this.getConnectionId() + ", exception: ", ex);
                    this.forceStop();
                }
                data = this.readData();
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}, function called when the service is not connected! forceStop()", this.toString());
            }
            this.forceStop();
        }
    }

    public boolean checkData(char[] data) throws IOException {
        return false;
    }

    @Override
    protected int receivedPackets() {
        return this.receivedPackets.size();
    }

    protected void xmppStreamClosed() {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0}, Received STREAM-CLOSE from the client", this.toString());
        }
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Sending data: </stream:stream>", this.toString());
            }
            this.writeRawData("</stream:stream>");
        }
        catch (IOException e) {
            log.log(Level.INFO, "{0}, Error sending stream closed data: {1}", new Object[]{this.toString(), e});
        }
        if (this.serviceListener != null) {
            this.serviceListener.xmppStreamClosed(this);
        }
    }

    protected void xmppStreamOpened(Map<String, String> attribs) {
        if (this.serviceListener != null) {
            String response = this.serviceListener.xmppStreamOpened(this, attribs);
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0}, Sending data: {1}", new Object[]{this.toString(), response});
                }
                this.writeRawData(response);
                this.processWaitingPackets();
                if (response != null && response.endsWith("</stream:stream>")) {
                    this.stop();
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, "{0}, Error sending stream open data: {1}", new Object[]{this.toString(), e});
                this.forceStop();
            }
        }
    }
}

