/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.net.UnknownHostException;
import java.util.Map;
import java.util.logging.Logger;
import tigase.db.comp.UserRepoRepository;
import tigase.util.DNSEntry;
import tigase.util.DNSResolver;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostRepoDefaults;
import tigase.xmpp.BareJID;

public class VHostJDBCRepository
extends UserRepoRepository<VHostItem> {
    private static final Logger log = Logger.getLogger(VHostJDBCRepository.class.getName());
    public static final String DOMAINS_PER_USER_LIMIT_PROP_KEY = "domains-per-user-limit";
    public static final int DOMAINS_PER_USER_LIMIT_PROP_VAL = 25;
    public static final String DNS_DEF_IP_PROP_KEY = "dns-def-ip";
    public static String DNS_DEF_IP_PROP_VAL = null;
    public static final String DNS_SRV_DEF_ADDR_PROP_KEY = "dns-srv-def-addr";
    public static String DNS_SRV_DEF_ADDR_PROP_VAL = null;
    private String def_ip_address = null;
    private String def_srv_address = null;
    private int max_domains_per_user = 25;

    @Override
    public String getConfigKey() {
        return VHostRepoDefaults.getConfigKey();
    }

    @Override
    public String[] getDefaultPropetyItems() {
        return VHostRepoDefaults.getDefaultPropetyItems();
    }

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        super.getDefaults(defs, params);
        DNS_SRV_DEF_ADDR_PROP_VAL = DNSResolver.getDefaultHostname();
        try {
            DNS_DEF_IP_PROP_VAL = DNSResolver.getHostIP((String)DNSResolver.getDefaultHostname());
        }
        catch (Exception e) {
            DNS_DEF_IP_PROP_VAL = DNSResolver.getDefaultHostname();
        }
        defs.put(DNS_SRV_DEF_ADDR_PROP_KEY, DNS_SRV_DEF_ADDR_PROP_VAL);
        defs.put(DNS_DEF_IP_PROP_KEY, DNS_DEF_IP_PROP_VAL);
        defs.put(DOMAINS_PER_USER_LIMIT_PROP_KEY, 25);
    }

    @Override
    public VHostItem getItemInstance() {
        return VHostRepoDefaults.getItemInstance();
    }

    @Override
    public String getItemsListPKey() {
        return VHostRepoDefaults.getItemsListPKey();
    }

    @Override
    public String getPropertyKey() {
        return VHostRepoDefaults.getPropertyKey();
    }

    @Override
    public BareJID getRepoUser() {
        return VHostRepoDefaults.getRepoUser();
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        super.setProperties(properties);
        this.def_srv_address = (String)properties.get(DNS_SRV_DEF_ADDR_PROP_KEY);
        this.def_ip_address = (String)properties.get(DNS_DEF_IP_PROP_KEY);
        this.max_domains_per_user = (Integer)properties.get(DOMAINS_PER_USER_LIMIT_PROP_KEY);
    }

    @Override
    public String validateItem(VHostItem item) {
        if (item.getVhost() == null || item.getVhost().getDomain() == null || item.getVhost().getDomain().isEmpty()) {
            return "Domain name not specified";
        }
        int vhost_count = 0;
        for (VHostItem it : this.allItems()) {
            if (!it.isOwner(item.getOwner())) continue;
            ++vhost_count;
        }
        if (vhost_count >= this.max_domains_per_user) {
            return "Maximum number of domains exceeded for the user! Current number is: " + vhost_count;
        }
        if (System.getProperty("vhost-disable-dns-check") != null) {
            return null;
        }
        try {
            DNSEntry dnsEntry = DNSResolver.getHostSRV_Entry((String)item.getKey());
            if (dnsEntry != null) {
                if (this.def_ip_address.equals(dnsEntry.getIp()) || this.def_srv_address.equals(dnsEntry.getDnsResultHost())) {
                    return null;
                }
                return "Incorrect DNS SRV settings ('" + dnsEntry.getDnsResultHost() + "', '" + dnsEntry.getIp() + "') for the given hostname: " + item.getKey();
            }
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        try {
            String ipAddress = DNSResolver.getHostIP((String)item.getKey());
            if (ipAddress != null) {
                if (ipAddress.equals(this.def_ip_address)) {
                    return null;
                }
                return "Incorrect IP address: '" + ipAddress + "' found in DNS for the given host: " + item.getKey();
            }
            return "No DNS settings found for given host: " + item.getKey();
        }
        catch (UnknownHostException ex1) {
            return "There is no DNS settings for given host: " + item.getKey();
        }
    }
}

