/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import tigase.util.DNSResolver;

public abstract class SessionManagerConfig {
    public static final String PLUGINS_PROP_KEY = "plugins";
    public static final String PLUGINS_CONF_PROP_KEY = "plugins-conf";
    public static final String PLUGINS_CONCURRENCY_PROP_KEY = "plugins-concurrency";
    public static final String sessionCloseProcId = "session-close";
    public static final String defaultHandlerProcId = "default-handler";
    public static final String sessionOpenProcId = "session-open";
    private static final String[] PLUGINS_NO_REG_PROP_VAL = new String[]{"session-close", "session-open", "default-handler", "jabber:iq:auth", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-session", "jabber:iq:roster", "jabber:iq:privacy", "jabber:iq:version", "http://jabber.org/protocol/stats", "starttls", "vcard-temp", "http://jabber.org/protocol/commands", "jabber:iq:private", "urn:xmpp:ping", "presence", "domain-filter", "disco", "pep", "amp"};
    private static final String[] PLUGINS_TEST_PROP_VAL = new String[]{"session-close", "session-open", "default-handler", "jabber:iq:register", "jabber:iq:auth", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-session", "jabber:iq:roster", "jabber:iq:privacy", "jabber:iq:version", "http://jabber.org/protocol/stats", "starttls", "vcard-temp", "http://jabber.org/protocol/commands", "jabber:iq:private", "urn:xmpp:ping", "presence", "domain-filter", "disco", "pep", "amp"};
    private static final String[] PLUGINS_FULL_PROP_VAL = new String[]{"session-close", "session-open", "default-handler", "jabber:iq:register", "jabber:iq:auth", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-session", "jabber:iq:roster", "jabber:iq:privacy", "jabber:iq:version", "http://jabber.org/protocol/stats", "starttls", "vcard-temp", "http://jabber.org/protocol/commands", "jabber:iq:private", "urn:xmpp:ping", "presence", "domain-filter", "disco", "pep", "amp"};
    private static String[] HOSTNAMES_PROP_VAL = new String[]{"localhost", "hostname"};
    private static String[] ANONYMOUS_DOMAINS_PROP_VAL = new String[]{"localhost", "hostname"};
    private static String[] ADMINS_PROP_VAL = new String[]{"admin@localhost", "admin@hostname"};
    private static String[] TRUSTED_PROP_VAL = new String[]{"admin@localhost", "admin@hostname"};
    private static String[] CLUSTER_NODES_PROP_VAL = new String[]{"sess-man@localhost"};
    protected static final String ADMIN_SCRIPTS_PROP_KEY = "admin-scripts-dir";
    protected static final String ADMIN_SCRIPTS_PROP_VAL = "scripts/admin/";
    protected static final String SKIP_PRIVACY_PROP_KEY = "skip-privacy";
    private static final boolean SKIP_PRIVACY_PROP_VAL = false;
    protected static final String AUTO_CREATE_OFFLINE_USER_PROP_KEY = "offline-user-autocreate";
    protected static final String AUTO_CREATE_OFFLINE_USER_PROP_VAL = "false";
    protected static final String SM_THREADS_POOL_PROP_KEY = "sm-threads-pool";
    protected static final String SM_THREADS_POOL_PROP_VAL = "default";
    protected static final String SM_THREADS_POOL_CUSTOM_PROP_VAL = "custom";

    public static void getDefaults(Map<String, Object> props, Map<String, Object> params) {
        props.put(ADMIN_SCRIPTS_PROP_KEY, ADMIN_SCRIPTS_PROP_VAL);
        boolean full_comps = params.get("--auth-db") == null || params.get("--auth-db").toString().equals("mysql") || params.get("--auth-db").toString().equals("pgsql") || params.get("--auth-db").toString().equals("derby") || params.get("--auth-db").toString().equals("tigase-auth");
        LinkedHashSet<String> plugins = new LinkedHashSet<String>(32);
        if (((Boolean)params.get("--test")).booleanValue()) {
            Collections.addAll(plugins, PLUGINS_TEST_PROP_VAL);
        } else if (full_comps) {
            Collections.addAll(plugins, PLUGINS_FULL_PROP_VAL);
        } else {
            Collections.addAll(plugins, PLUGINS_NO_REG_PROP_VAL);
        }
        String str_plugins = (String)params.get("--sm-plugins");
        String plugin_concurrency = "";
        if (str_plugins != null) {
            String[] conf_plugins;
            block4: for (String plugin : conf_plugins = str_plugins.split(",")) {
                switch (plugin.charAt(0)) {
                    case '+': {
                        if (!SessionManagerConfig.addPlugin(plugins, plugin.substring(1))) continue block4;
                        plugin_concurrency = plugin_concurrency + plugin.substring(1) + ",";
                        continue block4;
                    }
                    case '-': {
                        plugins.remove(plugin.substring(1));
                        continue block4;
                    }
                    default: {
                        if (!SessionManagerConfig.addPlugin(plugins, plugin)) continue block4;
                        plugin_concurrency = plugin_concurrency + plugin + ",";
                    }
                }
            }
        }
        props.put(PLUGINS_PROP_KEY, plugins.toArray(new String[plugins.size()]));
        props.put(PLUGINS_CONCURRENCY_PROP_KEY, plugin_concurrency);
        String skip_privacy = (String)params.get("--skip-privacy");
        props.put(SKIP_PRIVACY_PROP_KEY, skip_privacy != null && skip_privacy.equals("true"));
        if (params.get("--virt-hosts") != null) {
            HOSTNAMES_PROP_VAL = ((String)params.get("--virt-hosts")).split(",");
            ANONYMOUS_DOMAINS_PROP_VAL = ((String)params.get("--virt-hosts")).split(",");
        } else {
            HOSTNAMES_PROP_VAL = DNSResolver.getDefHostNames();
            ANONYMOUS_DOMAINS_PROP_VAL = DNSResolver.getDefHostNames();
        }
        if (params.get("--trusted") != null) {
            TRUSTED_PROP_VAL = ((String)params.get("--trusted")).split(",");
        } else {
            TRUSTED_PROP_VAL = new String[HOSTNAMES_PROP_VAL.length];
            for (int i = 0; i < TRUSTED_PROP_VAL.length; ++i) {
                SessionManagerConfig.TRUSTED_PROP_VAL[i] = "admin@" + HOSTNAMES_PROP_VAL[i];
            }
        }
        props.put("trusted", TRUSTED_PROP_VAL);
        props.put(AUTO_CREATE_OFFLINE_USER_PROP_KEY, AUTO_CREATE_OFFLINE_USER_PROP_VAL);
        String sm_threads_pool = SM_THREADS_POOL_PROP_VAL;
        if (params.get("--sm-threads-pool") != null) {
            sm_threads_pool = (String)params.get("--sm-threads-pool");
        }
        props.put(SM_THREADS_POOL_PROP_KEY, sm_threads_pool);
    }

    private static boolean addPlugin(LinkedHashSet<String> plugins, String plugin) {
        String[] pla = plugin.split("=");
        plugins.add(pla[0]);
        return pla.length > 1;
    }
}

