/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.xmppserver.S2SConnectionHandlerIfc;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.S2SProcessor;
import tigase.xml.Element;

public abstract class S2SAbstractProcessor
implements S2SProcessor {
    protected static final String XMLNS_SERVER_VAL = "jabber:server";
    protected static final String XMLNS_CLIENT_VAL = "jabber:client";
    protected static final String XMLNS_DB_VAL = "jabber:server:dialback";
    protected static final String RESULT_EL_NAME = "result";
    protected static final String VERIFY_EL_NAME = "verify";
    protected static final String DB_RESULT_EL_NAME = "db:result";
    protected static final String DB_VERIFY_EL_NAME = "db:verify";
    protected static final String XMLNS_DB_ATT = "xmlns:db";
    protected static final String STREAM_FEATURES_EL = "stream:features";
    protected static final String FEATURES_EL = "features";
    protected static final String FEATURES_NS = "http://etherx.jabber.org/streams";
    protected static final String START_TLS_EL = "starttls";
    protected static final String DIALBACK_TLS_EL = "dialback";
    protected static final String PROCEED_TLS_EL = "proceed";
    protected static final String START_TLS_NS = "urn:ietf:params:xml:ns:xmpp-tls";
    protected static final String DIALBACK_TLS_NS = "urn:xmpp:features:dialback";
    protected static final String VERSION_ATT_NAME = "version";
    private static final Logger log = Logger.getLogger(S2SAbstractProcessor.class.getName());
    public static boolean FORCE_VERSION = false;
    protected S2SConnectionHandlerIfc<S2SIOService> handler = null;

    public void generateStreamError(boolean initStream, String error_el, S2SIOService serv) {
        String strError = "";
        if (initStream) {
            strError = strError + "<?xml version='1.0'?><stream:stream xmlns='jabber:server' xmlns:stream='http://etherx.jabber.org/streams' id='tigase-server-error' from='" + this.handler.getDefHostName() + "'" + " xml:lang='en'>";
        }
        strError = strError + "<stream:error><" + error_el + " xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>" + "</stream:error>" + "</stream:stream>";
        try {
            if (log.isLoggable(Level.FINEST)) {
                Throwable thr = new Throwable();
                thr.fillInStackTrace();
                log.log(Level.FINEST, "Called from: ", thr);
                log.log(Level.FINEST, "{0}, Sending stream error: {1}", new Object[]{serv, strError});
            }
            this.handler.writeRawData(serv, strError);
            serv.stop();
        }
        catch (Exception e) {
            serv.forceStop();
        }
    }

    @Override
    public void init(S2SConnectionHandlerIfc<S2SIOService> handler) {
        this.handler = handler;
    }

    @Override
    public boolean process(Packet p, S2SIOService serv, Queue<Packet> results) {
        return false;
    }

    @Override
    public void serviceStarted(S2SIOService serv) {
    }

    @Override
    public void serviceStopped(S2SIOService serv) {
    }

    public boolean skipTLSForHost(String hostname) {
        String hostnames = System.getProperty("s2s-skip-tls-hostnames");
        if (hostnames != null) {
            String[] hosts;
            for (String host : hosts = hostnames.split(",")) {
                if (!hostname.equalsIgnoreCase(host)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void streamClosed(S2SIOService serv) {
    }

    @Override
    public void streamFeatures(S2SIOService serv, List<Element> results) {
    }

    @Override
    public String streamOpened(S2SIOService serv, Map<String, String> attribs) {
        return null;
    }
}

