/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext.handlers;

import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.ext.ComponentIOService;
import tigase.server.ext.ComponentProtocolHandler;
import tigase.server.ext.ExtProcessor;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;

public class BindProcessor
implements ExtProcessor {
    private static final Logger log = Logger.getLogger(BindProcessor.class.getName());
    private static final String EL_NAME = "bind";
    private static final String XMLNS = "urn:xmpp:component:0";
    private static final String ID = "bind";
    private static final Element FEATURES = new Element("bind", new String[]{"xmlns"}, new String[]{"urn:xmpp:component:0"});

    @Override
    public String getId() {
        return "bind";
    }

    @Override
    public List<Element> getStreamFeatures(ComponentIOService serv, ComponentProtocolHandler handler) {
        return Arrays.asList(FEATURES);
    }

    @Override
    public boolean process(Packet p, ComponentIOService serv, ComponentProtocolHandler handler, Queue<Packet> results) {
        if (p.isXMLNS("/iq/bind", XMLNS)) {
            if (p.getType() == StanzaType.set && serv.isAuthenticated()) {
                String hostname = p.getElemCData("/iq/bind/hostname");
                handler.bindHostname(hostname, serv);
                results.offer(Packet.packetInstance(this.okResult(p.getElement()), null, null));
            } else {
                log.fine("Ok result received: " + p.toString());
            }
            return true;
        }
        if (p.isXMLNS("/iq/unbind", XMLNS)) {
            if (p.getType() == StanzaType.set && serv.isAuthenticated()) {
                String hostname = p.getElemCData("/iq/unbind/hostname");
                handler.unbindHostname(hostname, serv);
                results.offer(Packet.packetInstance(this.okResult(p.getElement()), null, null));
            } else {
                log.fine("Ok result received: " + p.toString());
            }
            return true;
        }
        return false;
    }

    @Override
    public void startProcessing(Packet p, ComponentIOService serv, ComponentProtocolHandler handler, Queue<Packet> results) {
        String[] hostnames = (String[])serv.getSessionData().get("bind-ext-hostnames");
        if (hostnames != null) {
            for (String host : hostnames) {
                if (!host.isEmpty()) {
                    Packet bind_p = Packet.packetInstance(this.newBindElement(host, handler), null, null);
                    log.info("Generating hostname bind packet: " + bind_p.toString());
                    results.offer(bind_p);
                    continue;
                }
                log.warning("Empty hostname set for bind...");
            }
        }
    }

    private Element newBindElement(String host, ComponentProtocolHandler handler) {
        Element result = new Element("iq", new String[]{"type", "id"}, new String[]{"set", handler.newPacketId("bind")});
        Element bind = new Element("bind", new Element[]{new Element("hostname", host)}, new String[]{"xmlns"}, new String[]{XMLNS});
        result.addChild((XMLNodeIfc)bind);
        return result;
    }

    private Element okResult(Element elem) {
        Element result = elem.clone();
        result.setAttribute("type", "result");
        return result;
    }
}

