/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.XMPPServer;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPIOService;

public class BoshIOService
extends XMPPIOService<Object> {
    private static final Logger log = Logger.getLogger(BoshIOService.class.getName());
    public static final String BOSH_CLOSE_CONNECTION_PROP_KEY = "bosh-close-connection";
    public static final String BOSH_EXTRA_HEADERS_FILE_PROP_KEY = "bosh-extra-headers-file";
    public static final String BOSH_EXTRA_HEADERS_FILE_PROP_VAL = "etc/bosh-extra-headers.txt";
    private static final String EOL = "\r\n";
    private static final String HTTP_OK_RESPONSE = "HTTP/1.1 200 OK\r\n";
    private static final String CONTENT_TYPE_HEADER = "Content-Type: ";
    private static final String CONTENT_TYPE_LENGTH = "Content-Length: ";
    private static final String CONNECTION = "Connection: ";
    private static final String SERVER = "Server: Tigase Bosh/" + XMPPServer.getImplementationVersion();
    private String content_type = "text/xml; charset=utf-8";
    private static String extra_headers = null;
    private long rid = -1L;
    private UUID sid = null;
    private static Boolean closeConnections;

    public BoshIOService() {
        if (closeConnections == null) {
            closeConnections = Boolean.parseBoolean(System.getProperty(BOSH_CLOSE_CONNECTION_PROP_KEY, "false"));
        }
        if (extra_headers == null) {
            String file_name = System.getProperty(BOSH_EXTRA_HEADERS_FILE_PROP_KEY, BOSH_EXTRA_HEADERS_FILE_PROP_VAL);
            try {
                BufferedReader br = new BufferedReader(new FileReader(file_name));
                String line = br.readLine();
                StringBuilder sb = new StringBuilder();
                while (line != null) {
                    sb.append(line).append(EOL);
                    line = br.readLine();
                }
                br.close();
                extra_headers = sb.toString();
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Problem reading Bosh extra headers file: " + file_name, ex);
            }
        }
    }

    public long getRid() {
        return this.rid;
    }

    public UUID getSid() {
        return this.sid;
    }

    public void sendErrorAndStop(Authorization errorCode, Packet packet, String errorMsg) throws IOException {
        String code = "<body type='terminate' condition='item-not-found' xmlns='http://jabber.org/protocol/httpbind'/>";
        try {
            Packet error = errorCode.getResponseMessage(packet, errorMsg, false);
            code = error.getElement().toString();
        }
        catch (PacketErrorTypeException e) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append("HTTP/1.1 ").append(errorCode.getErrorCode()).append(" ");
        sb.append(errorMsg).append(EOL);
        sb.append(CONTENT_TYPE_HEADER).append(this.content_type).append(EOL);
        sb.append(CONTENT_TYPE_LENGTH).append(code.getBytes().length).append(EOL);
        if (extra_headers != null) {
            sb.append(extra_headers);
        }
        sb.append("Connection: close\r\n");
        sb.append(SERVER).append(EOL);
        sb.append(EOL);
        sb.append(code);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Writing to socket:\n{0}", sb.toString());
        }
        super.writeRawData(sb.toString());
        this.stop();
    }

    public void setContentType(String ct) {
        this.content_type = ct;
    }

    public void setRid(long rid) {
        this.rid = rid;
    }

    public void setSid(UUID sid) {
        this.sid = sid;
    }

    public StringBuilder prepareHeaders(String data) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(HTTP_OK_RESPONSE);
        sb.append(CONTENT_TYPE_HEADER).append(this.content_type).append(EOL);
        if (data != null) {
            sb.append(CONTENT_TYPE_LENGTH).append(data.getBytes().length).append(EOL);
        }
        if (extra_headers != null) {
            sb.append(extra_headers);
        }
        sb.append(SERVER).append(EOL);
        sb.append(EOL);
        return sb;
    }

    @Override
    public void writeRawData(String data) throws IOException {
        if (data != null && data.startsWith("<body")) {
            StringBuilder sb = this.prepareHeaders(data);
            sb.append(data);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Writing to socket:\n{0}", sb.toString());
            }
            super.writeRawData(sb.toString());
        } else {
            super.writeRawData(data);
        }
        if (closeConnections.booleanValue()) {
            this.stop();
        }
    }

    @Override
    public boolean checkData(char[] data) throws IOException {
        if (data != null && data.length > 7 && data[0] == 'O' && data[1] == 'P' && data[2] == 'T' && data[3] == 'I' && data[4] == 'O' && data[5] == 'N' && data[6] == 'S') {
            this.writeRawData(this.prepareHeaders(null).toString());
        }
        return false;
    }
}

