/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.net.ConnectionOpenListener;
import tigase.net.ConnectionOpenThread;
import tigase.net.ConnectionType;
import tigase.net.IOService;
import tigase.net.SocketThread;
import tigase.net.SocketType;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.server.ServiceChecker;
import tigase.stats.StatisticsList;
import tigase.util.DataTypes;
import tigase.xmpp.JID;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.XMPPIOServiceListener;

public abstract class ConnectionManager<IO extends XMPPIOService<?>>
extends AbstractMessageReceiver
implements XMPPIOServiceListener<IO> {
    private static final Logger log = Logger.getLogger(ConnectionManager.class.getName());
    public static final String NET_BUFFER_ST_PROP_KEY = "--net-buff-standard";
    public static final String NET_BUFFER_HT_PROP_KEY = "--net-buff-high-throughput";
    protected static final String PORT_KEY = "port-no";
    protected static final String PROP_KEY = "connections/";
    protected static final String PORTS_PROP_KEY = "connections/ports";
    protected static final String PORT_TYPE_PROP_KEY = "type";
    protected static final String PORT_SOCKET_PROP_KEY = "socket";
    protected static final String PORT_IFC_PROP_KEY = "ifc";
    protected static final String PORT_CLASS_PROP_KEY = "class";
    protected static final String PORT_REMOTE_HOST_PROP_KEY = "remote-host";
    protected static final String PORT_REMOTE_HOST_PROP_VAL = "localhost";
    protected static final String TLS_PROP_KEY = "connections/tls/";
    protected static final String TLS_USE_PROP_KEY = "connections/tls/use";
    protected static final boolean TLS_USE_PROP_VAL = true;
    protected static final String TLS_REQUIRED_PROP_KEY = "connections/tls/required";
    protected static final boolean TLS_REQUIRED_PROP_VAL = false;
    protected static final String MAX_RECONNECTS_PROP_KEY = "max-reconnects";
    protected static final String NET_BUFFER_PROP_KEY = "net-buffer";
    protected static final int NET_BUFFER_ST_PROP_VAL = 2048;
    protected static final int NET_BUFFER_HT_PROP_VAL = 65536;
    public static final String PORT_LOCAL_HOST_PROP_KEY = "local-host";
    private static ConnectionOpenThread connectThread = ConnectionOpenThread.getInstance();
    public String[] PORT_IFC_PROP_VAL = new String[]{"*"};
    private long bytesReceived = 0L;
    private long bytesSent = 0L;
    private int services_size = 0;
    private long socketOverflow = 0L;
    private Thread watchdog = null;
    private long watchdogRuns = 0L;
    private long watchdogStopped = 0L;
    private long watchdogTests = 0L;
    private LinkedList<Map<String, Object>> waitingTasks = new LinkedList();
    private ConcurrentHashMap<String, IO> services = new ConcurrentHashMap();
    private Set<ConnectionListenerImpl> pending_open = Collections.synchronizedSet(new HashSet());
    protected int net_buffer = 2048;
    private IOServiceStatisticsGetter ioStatsGetter = new IOServiceStatisticsGetter();
    private boolean initializationCompleted = false;
    protected long connectionDelay = 2000L;

    public abstract Queue<Packet> processSocketData(IO var1);

    public abstract void reconnectionFailed(Map<String, Object> var1);

    protected abstract long getMaxInactiveTime();

    protected abstract IO getXMPPIOServiceInstance();

    @Override
    public synchronized void everyMinute() {
        int tmp;
        super.everyMinute();
        this.services_size = tmp = this.services.size();
        this.doForAllServices(this.ioStatsGetter);
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        log.log(Level.CONFIG, "{0} defaults: {1}", new Object[]{this.getName(), params.toString()});
        Map<String, Object> props = super.getDefaults(params);
        props.put(TLS_USE_PROP_KEY, true);
        int buffSize = 2048;
        buffSize = this.isHighThroughput() ? DataTypes.parseSizeInt((String)params.get(NET_BUFFER_HT_PROP_KEY), 65536) : DataTypes.parseSizeInt((String)params.get(NET_BUFFER_ST_PROP_KEY), 2048);
        props.put(NET_BUFFER_PROP_KEY, buffSize);
        int[] ports = null;
        String ports_str = (String)params.get("--" + this.getName() + "-ports");
        if (ports_str != null) {
            String[] ports_stra = ports_str.split(",");
            ports = new int[ports_stra.length];
            int k = 0;
            for (String p : ports_stra) {
                try {
                    ports[k++] = Integer.parseInt(p);
                }
                catch (Exception e) {
                    log.warning("Incorrect ports default settings: " + p);
                }
            }
        }
        int ports_size = 0;
        if (ports != null) {
            log.config("Port settings preset: " + Arrays.toString(ports));
            for (int port : ports) {
                this.putDefPortParams(props, port, SocketType.plain);
            }
            props.put(PORTS_PROP_KEY, ports);
        } else {
            int[] ssls;
            int[] plains = this.getDefPlainPorts();
            if (plains != null) {
                ports_size += plains.length;
            }
            if ((ssls = this.getDefSSLPorts()) != null) {
                ports_size += ssls.length;
            }
            if (ports_size > 0) {
                ports = new int[ports_size];
            }
            if (ports != null) {
                int i;
                int idx = 0;
                if (plains != null) {
                    idx = plains.length;
                    for (i = 0; i < idx; ++i) {
                        ports[i] = plains[i];
                        this.putDefPortParams(props, ports[i], SocketType.plain);
                    }
                }
                if (ssls != null) {
                    for (i = idx; i < idx + ssls.length; ++i) {
                        ports[i] = ssls[i - idx];
                        this.putDefPortParams(props, ports[i], SocketType.ssl);
                    }
                }
                props.put(PORTS_PROP_KEY, ports);
            }
        }
        return props;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Open connections", this.services_size, Level.INFO);
        if (list.checkLevel(Level.FINEST) || this.services.size() < 1000) {
            int waitingToSendSize = 0;
            for (XMPPIOService serv : this.services.values()) {
                waitingToSendSize += serv.waitingToSendSize();
            }
            list.add(this.getName(), "Waiting to send", waitingToSendSize, Level.FINE);
        }
        list.add(this.getName(), "Bytes sent", this.bytesSent, Level.FINE);
        list.add(this.getName(), "Bytes received", this.bytesReceived, Level.FINE);
        list.add(this.getName(), "Socket overflow", this.socketOverflow, Level.FINE);
        list.add(this.getName(), "Watchdog runs", this.watchdogRuns, Level.FINER);
        list.add(this.getName(), "Watchdog tests", this.watchdogTests, Level.FINE);
        list.add(this.getName(), "Watchdog stopped", this.watchdogStopped, Level.FINE);
    }

    @Override
    public int hashCodeForPacket(Packet packet) {
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().hashCode();
        }
        if (packet.getTo() != null) {
            return packet.getTo().hashCode();
        }
        return super.hashCodeForPacket(packet);
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("servicesMap", (Object)this.services);
    }

    @Override
    public void initializationCompleted() {
        super.initializationCompleted();
        this.initializationCompleted = true;
        for (Map map : this.waitingTasks) {
            this.reconnectService(map, this.connectionDelay);
        }
        this.waitingTasks.clear();
    }

    @Override
    public void packetsReady(IO serv) throws IOException {
        this.writePacketsToSocket(serv, this.processSocketData(serv));
    }

    @Override
    public void processPacket(Packet packet) {
        this.writePacketToSocket(packet);
    }

    @Override
    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    @Override
    public int processingOutThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    @Override
    public void release() {
        this.releaseListeners();
        super.release();
    }

    public void serviceStarted(IO service) {
        XMPPIOService serv;
        String id = this.getUniqueId(service);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "[[{0}]] Connection started: {1}", new Object[]{this.getName(), service});
        }
        if ((serv = (XMPPIOService)this.services.get(id)) != null) {
            if (serv == service) {
                log.log(Level.WARNING, "{0}: That would explain a lot, adding the same service twice, ID: {1}", new Object[]{this.getName(), serv});
            } else {
                log.log(Level.WARNING, "{0}: Attempt to add different service with the same ID: {1}", new Object[]{this.getName(), service});
                serv.stop();
            }
        }
        this.services.put(id, service);
        ++this.services_size;
    }

    @Override
    public boolean serviceStopped(IO service) {
        try {
            this.ioStatsGetter.check(service);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Nothing serious to worry about but please notify the developer.", e);
        }
        String id = this.getUniqueId(service);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "[[{0}]] Connection stopped: {1}", new Object[]{this.getName(), service});
        }
        if (id != null) {
            boolean result = this.services.remove(id, service);
            if (result) {
                --this.services_size;
            } else if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "[[{0}]] Attempt to stop incorrect service: {1}", new Object[]{this.getName(), service});
            }
            return result;
        }
        return false;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.watchdog = new Thread((Runnable)new Watchdog(), "Watchdog - " + name);
        this.watchdog.setDaemon(true);
        this.watchdog.start();
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.get(NET_BUFFER_PROP_KEY) != null) {
            this.net_buffer = (Integer)props.get(NET_BUFFER_PROP_KEY);
        }
        if (props.size() == 1) {
            return;
        }
        this.releaseListeners();
        int[] ports = (int[])props.get(PORTS_PROP_KEY);
        if (ports != null) {
            for (int i = 0; i < ports.length; ++i) {
                LinkedHashMap<String, Object> port_props = new LinkedHashMap<String, Object>(20);
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (!entry.getKey().startsWith(PROP_KEY + ports[i])) continue;
                    int idx = entry.getKey().lastIndexOf(47);
                    String key = entry.getKey().substring(idx + 1);
                    log.log(Level.CONFIG, "Adding port property key: {0}={1}", new Object[]{key, entry.getValue()});
                    port_props.put(key, entry.getValue());
                }
                port_props.put(PORT_KEY, ports[i]);
                this.addWaitingTask(port_props);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writePacketToSocket(IO ios, Packet p) {
        if (ios != null) {
            if (log.isLoggable(Level.FINER) && !log.isLoggable(Level.FINEST)) {
                log.log(Level.FINER, "{0}, Processing packet: {1}, type: {2}", new Object[]{ios, p.getElemName(), p.getType()});
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Writing packet: {1}", new Object[]{ios, p});
            }
            ((XMPPIOService)ios).addPacketToSend(p);
            if (((XMPPIOService)ios).writeInProgress.tryLock()) {
                try {
                    ((XMPPIOService)ios).processWaitingPackets();
                    SocketThread.addSocketService(ios);
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, ios + "Exception during writing packets: ", e);
                    try {
                        ((XMPPIOService)ios).stop();
                    }
                    catch (Exception e1) {
                        log.log(Level.WARNING, ios + "Exception stopping XMPPIOService: ", e1);
                    }
                }
                finally {
                    ((XMPPIOService)ios).writeInProgress.unlock();
                }
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can''t find service for packet: <{0}> {1}, service id: {2}", new Object[]{p.getElemName(), p.getTo(), this.getServiceId(p)});
        }
        return false;
    }

    public void writePacketsToSocket(IO serv, Queue<Packet> packets) {
        if (serv != null) {
            if (packets != null && packets.size() > 0) {
                Packet p = null;
                while ((p = packets.poll()) != null) {
                    if (log.isLoggable(Level.FINER) && !log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINER, "{0}, Processing packet: {1}, type: {2}", new Object[]{serv, p.getElemName(), p.getType()});
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0}, Writing packet: {1}", new Object[]{serv, p});
                    }
                    ((XMPPIOService)serv).addPacketToSend(p);
                }
                try {
                    ((XMPPIOService)serv).processWaitingPackets();
                    SocketThread.addSocketService(serv);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, serv + "Exception during writing packets: ", e);
                    try {
                        ((XMPPIOService)serv).stop();
                    }
                    catch (Exception e1) {
                        log.log(Level.WARNING, serv + "Exception stopping XMPPIOService: ", e1);
                    }
                }
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can't find service for packets: [{0}] ", packets);
        }
    }

    protected void addWaitingTask(Map<String, Object> conn) {
        if (this.initializationCompleted) {
            this.reconnectService(conn, this.connectionDelay);
        } else {
            this.waitingTasks.add(conn);
        }
    }

    protected int countIOServices() {
        return this.services.size();
    }

    protected void doForAllServices(ServiceChecker<IO> checker) {
        for (XMPPIOService service : this.services.values()) {
            checker.check(service);
        }
    }

    protected int[] getDefPlainPorts() {
        return null;
    }

    protected int[] getDefSSLPorts() {
        return null;
    }

    protected Map<String, Object> getParamsForPort(int port) {
        return null;
    }

    protected String getServiceId(Packet packet) {
        return this.getServiceId(packet.getTo());
    }

    protected String getServiceId(JID jid) {
        return jid.getResource();
    }

    protected String getUniqueId(IO serv) {
        return ((IOService)serv).getUniqueId();
    }

    protected IO getXMPPIOService(String serviceId) {
        return (IO)((XMPPIOService)this.services.get(serviceId));
    }

    protected IO getXMPPIOService(Packet p) {
        return (IO)((XMPPIOService)this.services.get(this.getServiceId(p)));
    }

    protected boolean isHighThroughput() {
        return false;
    }

    protected boolean writePacketToSocket(Packet p) {
        IO ios = this.getXMPPIOService(p);
        if (ios != null) {
            return this.writePacketToSocket(ios, p);
        }
        return false;
    }

    protected boolean writePacketToSocket(Packet p, String serviceId) {
        IO ios = this.getXMPPIOService(serviceId);
        if (ios != null) {
            return this.writePacketToSocket(ios, p);
        }
        return false;
    }

    protected void writeRawData(IO ios, String data) {
        try {
            ((XMPPIOService)ios).writeRawData(data);
            SocketThread.addSocketService(ios);
        }
        catch (Exception e) {
            log.log(Level.WARNING, ios + "Exception during writing data: " + data, e);
            try {
                ((XMPPIOService)ios).stop();
            }
            catch (Exception e1) {
                log.log(Level.WARNING, ios + "Exception stopping XMPPIOService: ", e1);
            }
        }
    }

    private void putDefPortParams(Map<String, Object> props, int port, SocketType sock) {
        log.log(Level.CONFIG, "Generating defaults for port: {0}", port);
        props.put(PROP_KEY + port + "/" + PORT_TYPE_PROP_KEY, (Object)ConnectionType.accept);
        props.put(PROP_KEY + port + "/" + PORT_SOCKET_PROP_KEY, (Object)sock);
        props.put(PROP_KEY + port + "/" + PORT_IFC_PROP_KEY, this.PORT_IFC_PROP_VAL);
        props.put(PROP_KEY + port + "/" + PORT_REMOTE_HOST_PROP_KEY, PORT_REMOTE_HOST_PROP_VAL);
        props.put(PROP_KEY + port + "/" + TLS_REQUIRED_PROP_KEY, false);
        Map<String, Object> extra = this.getParamsForPort(port);
        if (extra != null) {
            for (Map.Entry<String, Object> entry : extra.entrySet()) {
                props.put(PROP_KEY + port + "/" + entry.getKey(), entry.getValue());
            }
        }
    }

    private void reconnectService(final Map<String, Object> port_props, long delay) {
        if (log.isLoggable(Level.FINER)) {
            String cid = "" + port_props.get("local-hostname") + "@" + port_props.get("remote-hostname");
            log.log(Level.FINER, "Reconnecting service for: {0}, scheduling next try in {1}secs, cid: {2}", new Object[]{this.getName(), delay / 1000L, cid});
        }
        this.addTimerTask(new TimerTask(){

            @Override
            public void run() {
                String host = (String)port_props.get(ConnectionManager.PORT_REMOTE_HOST_PROP_KEY);
                if (host == null) {
                    host = (String)port_props.get("remote-hostname");
                }
                int port = (Integer)port_props.get(ConnectionManager.PORT_KEY);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Reconnecting service for component: {0}, to remote host: {1} on port: {2}", new Object[]{ConnectionManager.this.getName(), host, port});
                }
                ConnectionManager.this.startService(port_props);
            }
        }, delay);
    }

    private void releaseListeners() {
        for (ConnectionListenerImpl cli : this.pending_open) {
            connectThread.removeConnectionOpenListener(cli);
        }
        this.pending_open.clear();
    }

    private void startService(Map<String, Object> port_props) {
        if (port_props == null) {
            throw new NullPointerException("port_props cannot be null.");
        }
        ConnectionListenerImpl cli = new ConnectionListenerImpl(port_props);
        if (cli.getConnectionType() == ConnectionType.accept) {
            this.pending_open.add(cli);
        }
        connectThread.addConnectionOpenListener(cli);
    }

    private class Watchdog
    implements Runnable {
        private Watchdog() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(600000L);
                        ++ConnectionManager.this.watchdogRuns;
                        ConnectionManager.this.doForAllServices(new ServiceChecker<IO>(){

                            @Override
                            public void check(XMPPIOService service) {
                                try {
                                    if (null != service) {
                                        long lastTransfer;
                                        long curr_time = System.currentTimeMillis();
                                        if (curr_time - (lastTransfer = service.getLastTransferTime()) >= ConnectionManager.this.getMaxInactiveTime()) {
                                            if (log.isLoggable(Level.INFO)) {
                                                log.log(Level.INFO, "{0}: Max inactive time exceeded, stopping: {1}", new Object[]{ConnectionManager.this.getName(), service});
                                            }
                                            ++ConnectionManager.this.watchdogStopped;
                                            service.stop();
                                        } else if (curr_time - lastTransfer >= 1740000L) {
                                            service.writeRawData(" ");
                                            ++ConnectionManager.this.watchdogTests;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    try {
                                        if (service != null) {
                                            log.info(ConnectionManager.this.getName() + "Found dead connection, stopping: " + service);
                                            ++ConnectionManager.this.watchdogStopped;
                                            service.forceStop();
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private class IOServiceStatisticsGetter
    implements ServiceChecker<IO> {
        private StatisticsList list = new StatisticsList(Level.ALL);

        private IOServiceStatisticsGetter() {
        }

        @Override
        public synchronized void check(IO service) {
            ((IOService)service).getStatistics(this.list, true);
            ConnectionManager.this.bytesReceived += this.list.getValue("socketio", "Bytes received", -1L);
            ConnectionManager.this.bytesSent += this.list.getValue("socketio", "Bytes sent", -1L);
            ConnectionManager.this.socketOverflow += this.list.getValue("socketio", "Buffers overflow", -1L);
        }
    }

    private class ConnectionListenerImpl
    implements ConnectionOpenListener {
        private Map<String, Object> port_props = null;

        private ConnectionListenerImpl(Map<String, Object> port_props) {
            this.port_props = port_props;
        }

        @Override
        public void accept(SocketChannel sc) {
            String cid = "" + this.port_props.get("local-hostname") + "@" + this.port_props.get("remote-hostname");
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Accept called for service: {0}", cid);
            }
            Object serv = ConnectionManager.this.getXMPPIOServiceInstance();
            ((XMPPIOService)serv).setIOServiceListener(ConnectionManager.this);
            ((IOService)serv).setSessionData(this.port_props);
            try {
                ((IOService)serv).accept(sc);
                if (this.getSocketType() == SocketType.ssl) {
                    ((IOService)serv).startSSL(false);
                }
                ConnectionManager.this.serviceStarted(serv);
                SocketThread.addSocketService(serv);
            }
            catch (SocketException e) {
                if (this.getConnectionType() == ConnectionType.connect) {
                    int recon;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Problem reconnecting the service: {0}, cid: {1}", new Object[]{serv, cid});
                    }
                    boolean reconnect = false;
                    Integer reconnects = (Integer)this.port_props.get(ConnectionManager.MAX_RECONNECTS_PROP_KEY);
                    if (reconnects != null && (recon = reconnects.intValue()) != 0) {
                        this.port_props.put(ConnectionManager.MAX_RECONNECTS_PROP_KEY, --recon);
                        reconnect = true;
                    }
                    if (reconnect) {
                        ConnectionManager.this.reconnectService(this.port_props, ConnectionManager.this.connectionDelay);
                    } else {
                        ConnectionManager.this.reconnectionFailed(this.port_props);
                    }
                }
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Can not accept connection cid: " + cid, e);
                }
                log.log(Level.WARNING, "Can not accept connection.", e);
                ((XMPPIOService)serv).stop();
            }
        }

        @Override
        public ConnectionType getConnectionType() {
            String type = null;
            if (this.port_props.get(ConnectionManager.PORT_TYPE_PROP_KEY) == null) {
                log.warning(ConnectionManager.this.getName() + ": connection type is null: " + this.port_props.get(ConnectionManager.PORT_KEY).toString());
            } else {
                type = this.port_props.get(ConnectionManager.PORT_TYPE_PROP_KEY).toString();
            }
            return ConnectionType.valueOf(type);
        }

        @Override
        public String[] getIfcs() {
            return (String[])this.port_props.get(ConnectionManager.PORT_IFC_PROP_KEY);
        }

        @Override
        public int getPort() {
            return (Integer)this.port_props.get(ConnectionManager.PORT_KEY);
        }

        @Override
        public int getReceiveBufferSize() {
            return ConnectionManager.this.net_buffer;
        }

        public SocketType getSocketType() {
            return SocketType.valueOf(this.port_props.get(ConnectionManager.PORT_SOCKET_PROP_KEY).toString());
        }

        @Override
        public int getTrafficClass() {
            if (ConnectionManager.this.isHighThroughput()) {
                return 8;
            }
            return 2;
        }

        public String toString() {
            return this.port_props.toString();
        }
    }
}

