/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.io.IOInterface;
import tigase.stats.StatisticsList;
import tigase.util.ZLibWrapper;

public class ZLibIO
implements IOInterface {
    public static final String ZLIB_CAPS = "zlib-caps";
    private static Logger log = Logger.getLogger(ZLibIO.class.getName());
    private IOInterface io = null;
    private ZLibWrapper zlib = null;

    public ZLibIO(IOInterface ioi, int level) {
        this.io = ioi;
        this.zlib = new ZLibWrapper();
    }

    @Override
    public int bytesRead() {
        return this.io.bytesRead();
    }

    @Override
    public boolean checkCapabilities(String caps) {
        return caps.contains(ZLIB_CAPS) || this.io.checkCapabilities(caps);
    }

    @Override
    public int getInputPacketSize() throws IOException {
        return this.io.getInputPacketSize();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.io.getSocketChannel();
    }

    @Override
    public void getStatistics(StatisticsList list, boolean reset) {
        if (this.io != null) {
            this.io.getStatistics(list, reset);
        }
        if (this.zlib != null) {
            list.add("zlibio", "Average compression rate", this.zlib.averageCompressionRate(), Level.FINE);
            list.add("zlibio", "Average decompression rate", this.zlib.averageDecompressionRate(), Level.FINE);
        }
    }

    @Override
    public boolean isConnected() {
        return this.io.isConnected();
    }

    @Override
    public boolean isRemoteAddress(String addr) {
        return this.io.isRemoteAddress(addr);
    }

    @Override
    public ByteBuffer read(ByteBuffer buff) throws IOException {
        ByteBuffer tmpBuffer = this.io.read(buff);
        if (this.io.bytesRead() > 0) {
            ByteBuffer decompressed_buff = this.zlib.decompress(tmpBuffer);
            tmpBuffer.clear();
            return decompressed_buff;
        }
        return null;
    }

    @Override
    public void stop() throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Stop called..." + this.toString());
        }
        this.io.stop();
        this.zlib.end();
    }

    public String toString() {
        return "ZLIB: " + this.io.toString();
    }

    @Override
    public boolean waitingToSend() {
        return this.io.waitingToSend();
    }

    @Override
    public int waitingToSendSize() {
        return this.io.waitingToSendSize();
    }

    @Override
    public int write(ByteBuffer buff) throws IOException {
        if (buff == null) {
            return this.io.write(null);
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "ZLIB - Writing data, remaining: {0}", buff.remaining());
        }
        ByteBuffer compressed_buff = this.zlib.compress(buff);
        return this.io.write(compressed_buff);
    }

    @Override
    public void setLogId(String logId) {
        this.io.setLogId(logId);
    }
}

