/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import tigase.cert.CertCheckResult;
import tigase.cert.CertificateUtil;
import tigase.io.TLSEventHandler;
import tigase.io.TLSStatus;
import tigase.io.TLSUtil;

public class TLSWrapper {
    private static final Logger log = Logger.getLogger(TLSWrapper.class.getName());
    private int appBuffSize = 0;
    private String debugId = null;
    private TLSEventHandler eventHandler = null;
    private int netBuffSize = 0;
    private SSLEngine tlsEngine = null;
    private SSLEngineResult tlsEngineResult = null;

    public TLSWrapper(SSLContext sslc, TLSEventHandler eventHandler, boolean clientMode) {
        this.tlsEngine = sslc.createSSLEngine();
        if (!clientMode) {
            this.tlsEngine.getSSLParameters().setWantClientAuth(true);
        }
        this.tlsEngine.setUseClientMode(clientMode);
        this.netBuffSize = this.tlsEngine.getSession().getPacketBufferSize();
        this.appBuffSize = this.tlsEngine.getSession().getApplicationBufferSize();
        this.eventHandler = eventHandler;
    }

    public int bytesConsumed() {
        return this.tlsEngineResult.bytesConsumed();
    }

    public void close() throws SSLException {
        this.tlsEngine.closeOutbound();
    }

    public int getAppBuffSize() {
        return this.appBuffSize;
    }

    public CertCheckResult getCertificateStatus(boolean revocationEnabled) {
        Certificate[] peerChain = null;
        try {
            peerChain = this.tlsEngine.getSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException ex) {
            return CertCheckResult.none;
        }
        try {
            return CertificateUtil.validateCertificate((Certificate[])peerChain, (KeyStore)TLSUtil.getTrustStore(), (boolean)revocationEnabled);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem validating certificate", ex);
            return CertCheckResult.invalid;
        }
    }

    public int getNetBuffSize() {
        return this.netBuffSize;
    }

    public int getPacketBuffSize() {
        return this.tlsEngine.getSession().getPacketBufferSize();
    }

    public TLSStatus getStatus() {
        TLSStatus status = null;
        if (this.tlsEngineResult != null && this.tlsEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            status = TLSStatus.UNDERFLOW;
        } else if (this.tlsEngineResult != null && this.tlsEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
            status = TLSStatus.CLOSED;
        } else {
            switch (this.tlsEngine.getHandshakeStatus()) {
                case NEED_WRAP: {
                    status = TLSStatus.NEED_WRITE;
                    break;
                }
                case NEED_UNWRAP: {
                    status = TLSStatus.NEED_READ;
                    break;
                }
                default: {
                    status = TLSStatus.OK;
                }
            }
        }
        return status;
    }

    public boolean isClientMode() {
        return this.tlsEngine.getUseClientMode();
    }

    public void setDebugId(String id) {
        this.debugId = id;
    }

    public ByteBuffer unwrap(ByteBuffer net, ByteBuffer app) throws SSLException {
        ByteBuffer out = app;
        this.tlsEngineResult = this.tlsEngine.unwrap(net, out);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0}, unwrap() tlsEngineRsult.getStatus() = {1}, tlsEngineRsult.getHandshakeStatus() = {2}", new Object[]{this.debugId, this.tlsEngineResult.getStatus(), this.tlsEngineResult.getHandshakeStatus()});
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED && this.eventHandler != null) {
            this.eventHandler.handshakeCompleted(this);
        }
        if (this.tlsEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
            out = this.resizeApplicationBuffer(net, out);
            this.tlsEngineResult = this.tlsEngine.unwrap(net, out);
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.doTasks();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "unwrap() doTasks(), handshake: {0}, {1}", new Object[]{this.tlsEngine.getHandshakeStatus(), this.debugId});
            }
        }
        return out;
    }

    public void wrap(ByteBuffer app, ByteBuffer net) throws SSLException {
        this.tlsEngineResult = this.tlsEngine.wrap(app, net);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0}, tlsEngineRsult.getStatus() = {1}, tlsEngineRsult.getHandshakeStatus() = {2}", new Object[]{this.debugId, this.tlsEngineResult.getStatus(), this.tlsEngineResult.getHandshakeStatus()});
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED && this.eventHandler != null) {
            this.eventHandler.handshakeCompleted(this);
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.doTasks();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "doTasks(): {0}, {1}", new Object[]{this.tlsEngine.getHandshakeStatus(), this.debugId});
            }
        }
    }

    private void doTasks() {
        Runnable runnable = null;
        while ((runnable = this.tlsEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
    }

    private ByteBuffer resizeApplicationBuffer(ByteBuffer net, ByteBuffer app) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Resizing tlsInput to {0} bytes, {1}", new Object[]{2048 + app.capacity(), this.debugId});
        }
        ByteBuffer bb = ByteBuffer.allocate(app.capacity() + 2048);
        app.flip();
        bb.put(app);
        return bb;
    }
}

