/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.util.Algorithms;
import tigase.util.Base64;
import tigase.util.TigaseStringprepException;
import tigase.xmpp.BareJID;

public class TigaseCustomAuth
implements AuthRepository {
    private static final Logger log = Logger.getLogger(TigaseCustomAuth.class.getName());
    public static final String DEF_CONNVALID_KEY = "conn-valid-query";
    public static final String DEF_INITDB_KEY = "init-db-query";
    public static final String DEF_ADDUSER_KEY = "add-user-query";
    public static final String DEF_DELUSER_KEY = "del-user-query";
    public static final String DEF_GETPASSWORD_KEY = "get-password-query";
    public static final String DEF_UPDATEPASSWORD_KEY = "update-password-query";
    public static final String DEF_USERLOGIN_KEY = "user-login-query";
    public static final String DEF_USERLOGOUT_KEY = "user-logout-query";
    public static final String DEF_USERS_COUNT_KEY = "users-count-query";
    public static final String DEF_USERS_DOMAIN_COUNT_KEY = "users-domain-count-query";
    public static final String DEF_NONSASL_MECHS_KEY = "non-sasl-mechs";
    public static final String DEF_SASL_MECHS_KEY = "sasl-mechs";
    public static final String NO_QUERY = "none";
    public static final String DEF_INITDB_QUERY = "{ call TigInitdb() }";
    public static final String DEF_ADDUSER_QUERY = "{ call TigAddUserPlainPw(?, ?) }";
    public static final String DEF_DELUSER_QUERY = "{ call TigRemoveUser(?) }";
    public static final String DEF_GETPASSWORD_QUERY = "{ call TigGetPassword(?) }";
    public static final String DEF_UPDATEPASSWORD_QUERY = "{ call TigUpdatePasswordPlainPwRev(?, ?) }";
    public static final String DEF_USERLOGIN_QUERY = "{ call TigUserLoginPlainPw(?, ?) }";
    public static final String DEF_USERLOGOUT_QUERY = "{ call TigUserLogout(?) }";
    public static final String DEF_USERS_COUNT_QUERY = "{ call TigAllUsersCount() }";
    public static final String DEF_USERS_DOMAIN_COUNT_QUERY = "select count(*) from tig_users where user_id like ?";
    public static final String DEF_NONSASL_MECHS = "password";
    public static final String DEF_SASL_MECHS = "PLAIN";
    public static final String SP_STARTS_WITH = "{ call";
    private DataRepository data_repo = null;
    private String initdb_query = "{ call TigInitdb() }";
    private String getpassword_query = "{ call TigGetPassword(?) }";
    private String deluser_query = "{ call TigRemoveUser(?) }";
    private String adduser_query = "{ call TigAddUserPlainPw(?, ?) }";
    private String updatepassword_query = "{ call TigUpdatePasswordPlainPwRev(?, ?) }";
    private String userlogin_query = "{ call TigUserLoginPlainPw(?, ?) }";
    private String userdomaincount_query = "select count(*) from tig_users where user_id like ?";
    private String userlogout_query = null;
    private String userscount_query = "{ call TigAllUsersCount() }";
    private boolean userlogin_active = false;
    private String[] sasl_mechs = "PLAIN".split(",");
    private String[] nonsasl_mechs = "password".split(",");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addUser(BareJID user, String password) throws UserExistsException, TigaseDBException {
        if (this.adduser_query == null) {
            return;
        }
        ResultSet rs = null;
        try {
            PreparedStatement add_user;
            PreparedStatement preparedStatement = add_user = this.data_repo.getPreparedStatement(user, this.adduser_query);
            synchronized (preparedStatement) {
                add_user.setString(1, user.toString());
                add_user.setString(2, password);
                boolean is_result = add_user.execute();
                if (is_result) {
                    rs = add_user.getResultSet();
                }
            }
            this.data_repo.release(null, rs);
            return;
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new UserExistsException("Error while adding user to repository, user exists?", e);
                catch (SQLException e2) {
                    throw new TigaseDBException("Problem accessing repository.", e2);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
    }

    @Override
    @Deprecated
    public boolean digestAuth(BareJID user, String digest, String id, String alg) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        if (this.userlogin_active) {
            throw new AuthorizationException("Not supported.");
        }
        String db_password = this.getPassword(user);
        try {
            String digest_db_pass = Algorithms.hexDigest((String)id, (String)db_password, (String)alg);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Comparing passwords, given: {0}, db: {1}", new Object[]{digest, digest_db_pass});
            }
            return digest.equals(digest_db_pass);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthorizationException("No such algorithm.", e);
        }
    }

    @Override
    public String getResourceUri() {
        return this.data_repo.getResourceUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount() {
        if (this.userscount_query == null) {
            return -1L;
        }
        ResultSet rs = null;
        try {
            PreparedStatement users_count;
            long users = -1L;
            PreparedStatement preparedStatement = users_count = this.data_repo.getPreparedStatement(null, this.userscount_query);
            synchronized (preparedStatement) {
                rs = users_count.executeQuery();
                if (rs.next()) {
                    users = rs.getLong(1);
                }
            }
            long l = users;
            this.data_repo.release(null, rs);
            rs = null;
            return l;
        }
        catch (SQLException e) {
            long l = -1L;
            return l;
        }
        finally {
            this.data_repo.release(null, rs);
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount(String domain) {
        if (this.userdomaincount_query == null) {
            return -1L;
        }
        ResultSet rs = null;
        try {
            PreparedStatement users_domain_count;
            long users = -1L;
            PreparedStatement preparedStatement = users_domain_count = this.data_repo.getPreparedStatement(null, this.userdomaincount_query);
            synchronized (preparedStatement) {
                users_domain_count.setString(1, "%@" + domain);
                rs = users_domain_count.executeQuery();
                if (rs.next()) {
                    users = rs.getLong(1);
                }
            }
            long l = users;
            this.data_repo.release(null, rs);
            rs = null;
            return l;
        }
        catch (SQLException e) {
            long l = -1L;
            return l;
        }
        finally {
            this.data_repo.release(null, rs);
            rs = null;
        }
    }

    @Override
    public void initRepository(String connection_str, Map<String, String> params) throws DBInitException {
        try {
            this.data_repo = RepositoryFactory.getDataRepository(null, connection_str, params);
            this.initdb_query = this.getParamWithDef(params, DEF_INITDB_KEY, DEF_INITDB_QUERY);
            if (this.initdb_query != null) {
                this.data_repo.initPreparedStatement(this.initdb_query, this.initdb_query);
            }
            this.adduser_query = this.getParamWithDef(params, DEF_ADDUSER_KEY, DEF_ADDUSER_QUERY);
            if (this.adduser_query != null) {
                this.data_repo.initPreparedStatement(this.adduser_query, this.adduser_query);
            }
            this.deluser_query = this.getParamWithDef(params, DEF_DELUSER_KEY, DEF_DELUSER_QUERY);
            if (this.deluser_query != null) {
                this.data_repo.initPreparedStatement(this.deluser_query, this.deluser_query);
            }
            this.getpassword_query = this.getParamWithDef(params, DEF_GETPASSWORD_KEY, null);
            if (this.getpassword_query != null) {
                this.data_repo.initPreparedStatement(this.getpassword_query, this.getpassword_query);
            }
            this.updatepassword_query = this.getParamWithDef(params, DEF_UPDATEPASSWORD_KEY, DEF_UPDATEPASSWORD_QUERY);
            if (this.updatepassword_query != null) {
                this.data_repo.initPreparedStatement(this.updatepassword_query, this.updatepassword_query);
            }
            this.userlogin_query = this.getParamWithDef(params, DEF_USERLOGIN_KEY, DEF_USERLOGIN_QUERY);
            if (this.userlogin_query != null) {
                this.data_repo.initPreparedStatement(this.userlogin_query, this.userlogin_query);
                this.userlogin_active = true;
            }
            this.userlogout_query = this.getParamWithDef(params, DEF_USERLOGOUT_KEY, DEF_USERLOGOUT_QUERY);
            if (this.userlogout_query != null) {
                this.data_repo.initPreparedStatement(this.userlogout_query, this.userlogout_query);
            }
            this.userscount_query = this.getParamWithDef(params, DEF_USERS_COUNT_KEY, DEF_USERS_COUNT_QUERY);
            if (this.userscount_query != null) {
                this.data_repo.initPreparedStatement(this.userscount_query, this.userscount_query);
            }
            this.userdomaincount_query = this.getParamWithDef(params, DEF_USERS_DOMAIN_COUNT_KEY, DEF_USERS_DOMAIN_COUNT_QUERY);
            if (this.userdomaincount_query != null) {
                this.data_repo.initPreparedStatement(this.userdomaincount_query, this.userdomaincount_query);
            }
            this.nonsasl_mechs = this.getParamWithDef(params, DEF_NONSASL_MECHS_KEY, DEF_NONSASL_MECHS).split(",");
            this.sasl_mechs = this.getParamWithDef(params, DEF_SASL_MECHS_KEY, DEF_SASL_MECHS).split(",");
            if (params != null && params.get("init-db") != null) {
                this.initDb();
            }
        }
        catch (Exception e) {
            this.data_repo = null;
            throw new DBInitException("Problem initializing jdbc connection: " + connection_str, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout(BareJID user) throws UserNotFoundException, TigaseDBException {
        block6: {
            if (this.userlogout_query == null) {
                return;
            }
            try {
                PreparedStatement user_logout = this.data_repo.getPreparedStatement(user, this.userlogout_query);
                if (user_logout == null) break block6;
                PreparedStatement preparedStatement = user_logout;
                synchronized (preparedStatement) {
                    user_logout.setString(1, user.toString());
                    user_logout.execute();
                }
            }
            catch (SQLException e) {
                throw new TigaseDBException("Problem accessing repository.", e);
            }
        }
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        String proto = (String)props.get("protocol");
        if (proto.equals("sasl")) {
            String mech = (String)props.get("mechanism");
            if (mech.equals(DEF_SASL_MECHS)) {
                try {
                    if (this.saslPlainAuth(props)) {
                        return true;
                    }
                    throw new AuthorizationException("Authentication failed.");
                }
                catch (TigaseStringprepException ex) {
                    throw new AuthorizationException("Stringprep failed for: " + props, ex);
                }
            }
            return this.saslAuth(props);
        }
        if (proto.equals("nonsasl")) {
            String password = (String)props.get(DEF_NONSASL_MECHS);
            BareJID user_id = (BareJID)props.get("user-id");
            if (password != null) {
                return this.plainAuth(user_id, password);
            }
            String digest = (String)props.get("digest");
            if (digest != null) {
                String digest_id = (String)props.get("digest-id");
                return this.digestAuth(user_id, digest, digest_id, "SHA");
            }
        }
        throw new AuthorizationException("Protocol is not supported.");
    }

    @Override
    @Deprecated
    public boolean plainAuth(BareJID user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        if (this.userlogin_active) {
            return this.userLoginAuth(user, password);
        }
        String db_password = this.getPassword(user);
        return password != null && db_password != null && db_password.equals(password);
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        String protocol = (String)authProps.get("protocol");
        if (protocol.equals("nonsasl")) {
            authProps.put("result", this.nonsasl_mechs);
        }
        if (protocol.equals("sasl")) {
            authProps.put("result", this.sasl_mechs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(BareJID user) throws UserNotFoundException, TigaseDBException {
        if (this.deluser_query == null) {
            return;
        }
        try {
            PreparedStatement remove_user;
            PreparedStatement preparedStatement = remove_user = this.data_repo.getPreparedStatement(user, this.deluser_query);
            synchronized (preparedStatement) {
                remove_user.setString(1, user.toString());
                remove_user.execute();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePassword(BareJID user, String password) throws UserNotFoundException, TigaseDBException {
        if (this.updatepassword_query == null) {
            return;
        }
        try {
            PreparedStatement update_pass;
            PreparedStatement preparedStatement = update_pass = this.data_repo.getPreparedStatement(user, this.updatepassword_query);
            synchronized (preparedStatement) {
                update_pass.setString(1, password);
                update_pass.setString(2, user.toString());
                update_pass.execute();
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
    }

    protected String getParamWithDef(Map<String, String> params, String key, String def) {
        if (params == null) {
            return def;
        }
        String result = params.get(key);
        if (result != null) {
            log.log(Level.CONFIG, "Custom query loaded for ''{0}'': ''{1}''", new Object[]{key, result});
        } else {
            result = def;
            log.log(Level.CONFIG, "Default query loaded for ''{0}'': ''{1}''", new Object[]{key, def});
        }
        if (result != null && ((result = result.trim()).isEmpty() || result.equals(NO_QUERY))) {
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPassword(BareJID user) throws TigaseDBException, UserNotFoundException {
        if (this.getpassword_query == null) {
            return null;
        }
        ResultSet rs = null;
        try {
            String string;
            PreparedStatement get_pass;
            PreparedStatement preparedStatement = get_pass = this.data_repo.getPreparedStatement(user, this.getpassword_query);
            synchronized (preparedStatement) {
                get_pass.setString(1, user.toString());
                rs = get_pass.executeQuery();
                if (!rs.next()) throw new UserNotFoundException("User does not exist: " + user);
                string = rs.getString(1);
            }
            this.data_repo.release(null, rs);
            return string;
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem with retrieving user password.", e);
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDb() throws SQLException {
        PreparedStatement init_db;
        if (this.initdb_query == null) {
            return;
        }
        PreparedStatement preparedStatement = init_db = this.data_repo.getPreparedStatement(null, this.initdb_query);
        synchronized (preparedStatement) {
            init_db.executeUpdate();
        }
    }

    private boolean saslAuth(Map<String, Object> props) throws AuthorizationException {
        try {
            String data_str;
            byte[] in_data;
            SaslServer ss = (SaslServer)props.get("SaslServer");
            if (ss == null) {
                TreeMap<String, String> sasl_props = new TreeMap<String, String>();
                sasl_props.put("javax.security.sasl.qop", "auth");
                ss = Sasl.createSaslServer((String)props.get("mechanism"), "xmpp", (String)props.get("server-name"), sasl_props, new SaslCallbackHandler(props));
                props.put("SaslServer", ss);
            }
            byte[] byArray = in_data = (data_str = (String)props.get("data")) != null ? Base64.decode((String)data_str) : new byte[]{};
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "response: {0}", new String(in_data));
            }
            byte[] challenge = ss.evaluateResponse(in_data);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "challenge: {0}", challenge != null ? new String(challenge) : "null");
            }
            String challenge_str = challenge != null && challenge.length > 0 ? Base64.encode((byte[])challenge) : null;
            props.put("result", challenge_str);
            return ss.isComplete();
        }
        catch (SaslException e) {
            throw new AuthorizationException("Sasl exception.", e);
        }
    }

    private boolean saslPlainAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException, TigaseStringprepException {
        int user_idx;
        int auth_idx;
        String data_str = (String)props.get("data");
        String domain = (String)props.get("realm");
        props.put("result", null);
        byte[] in_data = data_str != null ? Base64.decode((String)data_str) : new byte[]{};
        for (auth_idx = 0; in_data[auth_idx] != 0 && auth_idx < in_data.length; ++auth_idx) {
        }
        String authoriz = new String(in_data, 0, auth_idx);
        for (user_idx = ++auth_idx; in_data[user_idx] != 0 && user_idx < in_data.length; ++user_idx) {
        }
        String user_name = new String(in_data, auth_idx, user_idx - auth_idx);
        BareJID jid = null;
        jid = BareJID.parseJID((String)user_name)[0] == null ? BareJID.bareJIDInstance((String)user_name, (String)domain) : BareJID.bareJIDInstance((String)user_name);
        props.put("user-id", jid);
        String passwd = new String(in_data, ++user_idx, in_data.length - user_idx);
        return this.plainAuth(jid, passwd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean userLoginAuth(BareJID user, String password) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        if (this.userlogin_query == null) {
            return false;
        }
        ResultSet rs = null;
        String res_string = null;
        try {
            PreparedStatement user_login;
            PreparedStatement preparedStatement = user_login = this.data_repo.getPreparedStatement(user, this.userlogin_query);
            // MONITORENTER : preparedStatement
            user_login.setString(1, user.toString());
            user_login.setString(2, password);
            rs = user_login.executeQuery();
            boolean auth_result_ok = false;
            if (!rs.next()) throw new UserNotFoundException("User does not exist: " + user + ", in database: " + this.getResourceUri());
            res_string = rs.getString(1);
            if (res_string != null) {
                BareJID result = BareJID.bareJIDInstance((String)res_string);
                auth_result_ok = user.equals((Object)result);
            }
            if (auth_result_ok) {
                boolean bl = true;
                // MONITOREXIT : preparedStatement
                this.data_repo.release(null, rs);
                return bl;
            }
            if (!log.isLoggable(Level.FINE)) throw new UserNotFoundException("User does not exist: " + user + ", in database: " + this.getResourceUri());
            log.log(Level.FINE, "Login failed, for user: ''{0}'', password: ''{1}'', from DB got: {2}", new Object[]{user, password, res_string});
            throw new UserNotFoundException("User does not exist: " + user + ", in database: " + this.getResourceUri());
        }
        catch (TigaseStringprepException ex) {
            throw new AuthorizationException("Stringprep failed for: " + res_string, ex);
        }
        catch (SQLException e) {
            throw new TigaseDBException("Problem accessing repository.", e);
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
    }

    private class SaslCallbackHandler
    implements CallbackHandler {
        private Map<String, Object> options = null;

        private SaslCallbackHandler(Map<String, Object> options) {
            this.options = options;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            BareJID jid = null;
            for (int i = 0; i < callbacks.length; ++i) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Callback: {0}", callbacks[i].getClass().getSimpleName());
                }
                if (callbacks[i] instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callbacks[i];
                    String realm = (String)this.options.get("realm");
                    if (realm != null) {
                        rc.setText(realm);
                    }
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "RealmCallback: {0}", realm);
                    continue;
                }
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    String user_name = nc.getName();
                    if (user_name == null) {
                        user_name = nc.getDefaultName();
                    }
                    jid = BareJID.bareJIDInstanceNS((String)user_name, (String)((String)this.options.get("realm")));
                    this.options.put("user-id", jid);
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "NameCallback: {0}", user_name);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    try {
                        String passwd = TigaseCustomAuth.this.getPassword(jid);
                        pc.setPassword(passwd.toCharArray());
                        if (!log.isLoggable(Level.FINEST)) continue;
                        log.log(Level.FINEST, "PasswordCallback: {0}", passwd);
                        continue;
                    }
                    catch (Exception e) {
                        throw new IOException("Password retrieving problem.", e);
                    }
                }
                if (callbacks[i] instanceof AuthorizeCallback) {
                    AuthorizeCallback authCallback = (AuthorizeCallback)callbacks[i];
                    String authenId = authCallback.getAuthenticationID();
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "AuthorizeCallback: authenId: {0}", authenId);
                    }
                    String authorId = authCallback.getAuthorizationID();
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "AuthorizeCallback: authorId: {0}", authorId);
                    }
                    if (!authenId.equals(authorId)) continue;
                    authCallback.setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }
}

