/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.util.logging.Logger;
import tigase.db.comp.RepositoryItemAbstract;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.util.DataTypes;
import tigase.xml.Element;

public class ConfigItem
extends RepositoryItemAbstract {
    private static final Logger log = Logger.getLogger(ConfigItem.class.getName());
    public static final String REPO_ITEM_ELEM_NAME = "prop";
    public static final String CLUSTER_NODE_ATTR = "cluster-node";
    public static final String COMPONENT_NAME_ATTR = "comp-name";
    public static final String NODE_NAME_ATTR = "node-name";
    public static final String KEY_NAME_ATTR = "key-name";
    public static final String VALUE_ATTR = "value";
    public static final String FLAG_ATTR = "flag";
    public static final String VALUE_TYPE_ATTR = "value-type";
    public static final String COMPONENT_NAME_LABEL = "Component name";
    public static final String NODE_NAME_LABEL = "Property node name";
    public static final String KEY_NAME_LABEL = "Property key name";
    public static final String VALUE_LABEL = "Propety value";
    private String clusterNode = null;
    private String compName = null;
    private String keyName = null;
    private long lastModificationTime = -1L;
    private String nodeName = null;
    private Object value = null;
    private FLAGS flag = FLAGS.DEFAULT;

    @Override
    public void addCommandFields(Packet packet) {
        if (this.compName != null) {
            Command.addTextField(packet, COMPONENT_NAME_LABEL, this.compName);
        }
        if (this.nodeName != null) {
            Command.addTextField(packet, NODE_NAME_LABEL, this.nodeName);
        }
        Command.addTextField(packet, KEY_NAME_LABEL, this.keyName != null ? this.keyName : "");
        Command.addTextField(packet, "    ", "    ");
        String value_label = VALUE_LABEL;
        String value_str = "";
        if (this.value != null) {
            value_str = DataTypes.valueToString(this.value);
            value_label = value_label + " [" + DataTypes.getTypeId(this.value) + "]";
        }
        Command.addFieldValue(packet, value_label, value_str);
        super.addCommandFields(packet);
    }

    public String getClusterNode() {
        return this.clusterNode;
    }

    public String getCompName() {
        return this.compName;
    }

    public String getConfigKey() {
        return (this.nodeName != null ? this.nodeName + "/" : "") + this.keyName;
    }

    public Object getConfigVal() {
        return this.value;
    }

    public String getConfigValToString() {
        return this.value == null ? null : DataTypes.valueToString(this.value);
    }

    @Override
    public String getElemName() {
        return REPO_ITEM_ELEM_NAME;
    }

    public FLAGS getFlag() {
        return this.flag;
    }

    @Override
    public String getKey() {
        return (this.compName != null ? this.compName + "/" : "") + (this.nodeName != null ? this.nodeName + "/" : "") + this.keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public void initFromCommand(Packet packet) {
        super.initFromCommand(packet);
        String tmp = Command.getFieldValue(packet, COMPONENT_NAME_LABEL);
        if (tmp != null && !tmp.isEmpty()) {
            this.compName = tmp;
        }
        if ((tmp = Command.getFieldValue(packet, NODE_NAME_LABEL)) != null && !tmp.isEmpty()) {
            this.nodeName = tmp;
        }
        if ((tmp = Command.getFieldValue(packet, KEY_NAME_LABEL)) != null && !tmp.isEmpty()) {
            this.keyName = tmp;
        }
        String value_label = Command.getFieldKeyStartingWith(packet, VALUE_LABEL);
        char t = DataTypes.decodeTypeIdFromName(value_label);
        tmp = Command.getFieldValue(packet, value_label);
        if (tmp != null && !tmp.isEmpty()) {
            this.value = DataTypes.decodeValueType(t, tmp);
        }
    }

    @Override
    public void initFromElement(Element elem) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initFromPropertyString(String propString) {
        String keyNameMeth;
        String nodeNameMeth;
        String compNameMeth;
        int idx1;
        int idx_eq = propString.indexOf(61);
        String[] prop = propString.split("=");
        String key = propString.substring(0, idx_eq);
        Object val = propString.substring(idx_eq + 1);
        if (key.matches(".*\\[[LISBlisb]\\]$")) {
            char c = key.charAt(key.length() - 2);
            key = key.substring(0, key.length() - 3);
            val = DataTypes.decodeValueType(c, prop[1]);
        }
        if ((idx1 = key.indexOf("/")) > 0) {
            compNameMeth = key.substring(0, idx1);
            int idx2 = key.lastIndexOf("/");
            nodeNameMeth = null;
            keyNameMeth = key.substring(idx2 + 1);
            if (idx1 != idx2) {
                nodeNameMeth = key.substring(idx1 + 1, idx2);
            }
        } else {
            throw new IllegalArgumentException("You have to provide a key with at least 'component_name/key_name': " + key);
        }
        this.set(compNameMeth, nodeNameMeth, keyNameMeth, val);
    }

    public boolean isCompNodeKey(String comp, String node, String key) {
        return this.isComponent(comp) && this.isNode(node) && this.isKey(key);
    }

    public boolean equals(Object o) {
        if (o instanceof ConfigItem) {
            return this.getKey().equals(((ConfigItem)o).getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean isComponent(String comp) {
        if (this.compName != comp) {
            return this.compName != null ? this.compName.equals(comp) : false;
        }
        return true;
    }

    public boolean isKey(String key) {
        if (this.keyName != key) {
            return this.keyName != null ? this.keyName.equals(key) : false;
        }
        return true;
    }

    public boolean isNode(String node) {
        if (this.nodeName != node) {
            return this.nodeName != null ? this.nodeName.equals(node) : false;
        }
        return true;
    }

    public boolean isNodeKey(String node, String key) {
        return this.isNode(node) && this.isKey(key);
    }

    public void set(String clusterNode_m, String compName_m, String nodeName_m, String key_m, String value_str_m, char val_type_m, String flag_str_m) {
        Object value_m = DataTypes.decodeValueType(val_type_m, value_str_m);
        FLAGS flag_m = FLAGS.DEFAULT;
        try {
            flag_m = FLAGS.valueOf(flag_str_m);
        }
        catch (Exception e) {
            log.warning("Incorrect config item flag: " + flag_str_m + ", setting DEFAULT.");
            flag_m = FLAGS.DEFAULT;
        }
        this.set(clusterNode_m, compName_m, nodeName_m, key_m, value_m, flag_m);
    }

    public void set(String clusterNode_m, String compName_m, String nodeName_m, String key_m, Object value_m, FLAGS flag_m) {
        if (clusterNode_m != null) {
            this.clusterNode = clusterNode_m;
        }
        if (compName_m != null) {
            this.compName = compName_m;
        }
        if (nodeName_m != null) {
            this.nodeName = nodeName_m;
        }
        if (key_m != null) {
            this.keyName = key_m;
        }
        if (value_m != null) {
            this.value = value_m;
        }
        if (flag_m != null) {
            this.flag = flag_m;
        }
        this.lastModificationTime = System.currentTimeMillis();
    }

    public void set(String compName_m, String nodeName_m, String key_m, String value_str_m, char val_type_m, String flag_str_m) {
        this.set(null, compName_m, nodeName_m, key_m, value_str_m, val_type_m, flag_str_m);
    }

    public void set(String compName, String nodeName, String key, Object value) {
        this.set(null, compName, nodeName, key, value, null);
    }

    public void set(String clusterNode, String compName, String nodeName, String key, Object value) {
        this.set(clusterNode, compName, nodeName, key, value, null);
    }

    public void setNodeKey(String clusterNode, String compName, String nodeKey, Object value) {
        int key_idx = nodeKey.lastIndexOf("/");
        String method_key = nodeKey;
        String method_node = null;
        if (key_idx >= 0) {
            method_key = nodeKey.substring(key_idx + 1);
            method_node = nodeKey.substring(0, key_idx);
        }
        this.set(clusterNode, compName, method_node, method_key, value);
    }

    @Override
    public Element toElement() {
        Element elem = super.toElement();
        if (this.clusterNode != null) {
            elem.addAttribute(CLUSTER_NODE_ATTR, this.clusterNode);
        }
        elem.addAttribute(COMPONENT_NAME_ATTR, this.compName);
        if (this.nodeName != null) {
            elem.addAttribute(NODE_NAME_ATTR, this.nodeName);
        }
        elem.addAttribute(KEY_NAME_ATTR, this.keyName);
        elem.addAttribute(VALUE_ATTR, DataTypes.valueToString(this.value));
        elem.addAttribute(VALUE_TYPE_ATTR, "" + DataTypes.getTypeId(this.value));
        elem.addAttribute(FLAG_ATTR, this.flag.name());
        return elem;
    }

    @Override
    public String toPropertyString() {
        char t = DataTypes.getTypeId(this.value);
        String result = this.getKey() + "[" + t + "]=";
        String varr = DataTypes.valueToString(this.value);
        result = result + varr;
        return result;
    }

    public String toString() {
        return this.getKey() + "=" + this.value;
    }

    public static enum FLAGS {
        INITIAL,
        DEFAULT,
        UPDATED;

    }
}

