/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.util.HashSet;
import java.util.logging.Logger;
import tigase.util.TigaseStringprepException;
import tigase.util.XMPPStringPrepFactory;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.JID;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.roster.RosterAbstract;

public class RosterElement {
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.roster.RosterElement");
    private static final String ELEM_NAME = "contact";
    private static final String JID_ATT = "jid";
    private static final String NAME_ATT = "name";
    private static final String SUBS_ATT = "subs";
    private static final String GRP_ATT = "groups";
    private static final String OTHER_ATT = "other";
    private static final String STRINGPREP_ATT = "preped";
    private String[] groups = null;
    private JID jid = null;
    private String name = null;
    private String otherData = null;
    private XMPPResourceConnection session = null;
    private String stringpreped = null;
    private RosterAbstract.SubscriptionType subscription = null;
    private boolean presence_sent = false;
    private boolean modified = false;

    public RosterElement(Element roster_el, XMPPResourceConnection session) throws TigaseStringprepException {
        this.session = session;
        if (roster_el.getName() == ELEM_NAME) {
            String other_data;
            this.stringpreped = roster_el.getAttribute(STRINGPREP_ATT);
            this.setJid(roster_el.getAttribute(JID_ATT));
            this.setName(roster_el.getAttribute(NAME_ATT));
            this.subscription = roster_el.getAttribute(SUBS_ATT) == null ? RosterAbstract.SubscriptionType.none : RosterAbstract.SubscriptionType.valueOf(roster_el.getAttribute(SUBS_ATT));
            String grps = roster_el.getAttribute(GRP_ATT);
            if (grps != null && !grps.trim().isEmpty()) {
                this.groups = grps.split(",");
            }
            if ((other_data = roster_el.getAttribute(OTHER_ATT)) != null && !other_data.trim().isEmpty()) {
                this.otherData = other_data;
            }
        } else {
            log.warning("Incorrect roster data: " + roster_el.toString());
        }
    }

    public RosterElement(JID jid, String name, String[] groups, XMPPResourceConnection session) {
        this.stringpreped = XMPPStringPrepFactory.STRINGPREP_PROCESSOR;
        this.session = session;
        this.setJid(jid);
        this.setName(name);
        this.groups = groups;
        this.subscription = RosterAbstract.SubscriptionType.none;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public JID getJid() {
        return this.jid;
    }

    public String getName() {
        return this.name;
    }

    public String getOtherData() {
        return this.otherData;
    }

    public Element getRosterElement() {
        Element elem = new Element(ELEM_NAME, new String[]{JID_ATT, SUBS_ATT, NAME_ATT, STRINGPREP_ATT}, new String[]{this.jid.toString(), this.subscription.toString(), this.name, "" + this.stringpreped});
        if (this.groups != null && this.groups.length > 0) {
            String grps = "";
            for (String group : this.groups) {
                grps = grps + group + ",";
            }
            grps = grps.substring(0, grps.length() - 1);
            elem.setAttribute(GRP_ATT, grps);
        }
        if (this.otherData != null) {
            elem.setAttribute(OTHER_ATT, this.otherData);
        }
        this.modified = false;
        return elem;
    }

    public Element getRosterItem() {
        Element item = new Element("item");
        item.setAttribute(JID_ATT, this.jid.toString());
        item.addAttributes(this.subscription.getSubscriptionAttr());
        if (this.name != null) {
            item.setAttribute(NAME_ATT, XMLUtils.escape((String)this.name));
        }
        if (this.groups != null) {
            for (String gr : this.groups) {
                Element group = new Element("group");
                group.setCData(XMLUtils.escape((String)gr));
                item.addChild((XMLNodeIfc)group);
            }
        }
        return item;
    }

    public RosterAbstract.SubscriptionType getSubscription() {
        return this.subscription;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isPresence_sent() {
        return this.presence_sent;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
        this.modified = true;
    }

    public void setName(String name) {
        if (name == null) {
            this.name = this.jid.getLocalpart();
            if (this.name == null || this.name.trim().isEmpty()) {
                this.name = this.jid.getBareJID().toString();
            }
        } else {
            this.name = name;
        }
        this.modified = true;
    }

    public void setOtherData(String other_data) {
        this.otherData = other_data;
    }

    public void setPresence_sent(boolean presence_sent) {
        this.presence_sent = presence_sent;
    }

    public void setSubscription(RosterAbstract.SubscriptionType subscription) {
        this.subscription = subscription == null ? RosterAbstract.SubscriptionType.none : subscription;
        this.modified = true;
    }

    void addGroups(String[] groups) {
        if (groups != null) {
            if (this.groups == null) {
                this.groups = groups;
            } else {
                HashSet<String> groupsSet = new HashSet<String>();
                for (String group : this.groups) {
                    groupsSet.add(group);
                }
                for (String group : groups) {
                    groupsSet.add(group);
                }
                this.groups = groupsSet.toArray(new String[groupsSet.size()]);
            }
        }
    }

    private void setJid(JID jid) {
        this.jid = jid;
        this.modified = true;
    }

    private void setJid(String jid) throws TigaseStringprepException {
        if (XMPPStringPrepFactory.STRINGPREP_PROCESSOR.equals(this.stringpreped)) {
            this.jid = JID.jidInstanceNS((String)jid);
        } else {
            this.jid = JID.jidInstance((String)jid);
            this.modified = true;
        }
        this.stringpreped = XMPPStringPrepFactory.STRINGPREP_PROCESSOR;
    }
}

