/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.server.Packet;
import tigase.util.Algorithms;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;

public abstract class RosterAbstract {
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.RosterAbstract");
    public static final String ROSTER_XMLNS = "jabber:iq:roster";
    public static final String ROSTER = "roster";
    public static final String GROUPS = "groups";
    public static final String GROUP = "group";
    public static final String NAME = "name";
    public static final String SUBSCRIPTION = "subscription";
    public static final String ROSTERHASH = "rosterhash";
    public static final String XMLNS = "jabber:iq:roster";
    public static final String XMLNS_DYNAMIC = "jabber:iq:roster-dynamic";
    public static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:roster"}), new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:roster-dynamic"})};
    public static final Element[] FEATURES = new Element[]{new Element("ver", new String[]{"xmlns"}, new String[]{"urn:xmpp:features:rosterver"})};
    public static final EnumSet<SubscriptionType> SUB_NONE = EnumSet.of(SubscriptionType.none, SubscriptionType.none_pending_out, SubscriptionType.none_pending_in, SubscriptionType.none_pending_out_in);
    public static final EnumSet<SubscriptionType> SUB_TO = EnumSet.of(SubscriptionType.to, SubscriptionType.to_pending_in);
    public static final EnumSet<SubscriptionType> SUB_FROM = EnumSet.of(SubscriptionType.from, SubscriptionType.from_pending_out);
    public static final EnumSet<SubscriptionType> SUB_BOTH = EnumSet.of(SubscriptionType.both);
    public static final EnumSet<SubscriptionType> TO_SUBSCRIBED = EnumSet.of(SubscriptionType.to, SubscriptionType.to_pending_in, SubscriptionType.both);
    public static final EnumSet<SubscriptionType> FROM_SUBSCRIBED = EnumSet.of(SubscriptionType.from, SubscriptionType.from_pending_out, SubscriptionType.both);
    public static final EnumSet<StanzaType> INITIAL_PRESENCES = EnumSet.of(StanzaType.available, StanzaType.unavailable);
    public static final EnumSet<SubscriptionType> PENDING_IN = EnumSet.of(SubscriptionType.none_pending_in, SubscriptionType.none_pending_out_in, SubscriptionType.to_pending_in);
    public static final EnumSet<SubscriptionType> PENDING_OUT = EnumSet.of(SubscriptionType.none_pending_out, SubscriptionType.none_pending_out_in, SubscriptionType.from_pending_out);
    private static EnumMap<SubscriptionType, StateTransition> subsToStateMap = new EnumMap(SubscriptionType.class);

    public abstract void addBuddy(XMPPResourceConnection var1, JID var2, String var3, String[] var4, String var5) throws NotAuthorizedException, TigaseDBException;

    public abstract boolean addBuddyGroup(XMPPResourceConnection var1, JID var2, String[] var3) throws NotAuthorizedException, TigaseDBException;

    public abstract boolean containsBuddy(XMPPResourceConnection var1, JID var2) throws NotAuthorizedException, TigaseDBException;

    public abstract JID[] getBuddies(XMPPResourceConnection var1) throws NotAuthorizedException, TigaseDBException;

    public abstract String[] getBuddyGroups(XMPPResourceConnection var1, JID var2) throws NotAuthorizedException, TigaseDBException;

    public abstract String getBuddyName(XMPPResourceConnection var1, JID var2) throws NotAuthorizedException, TigaseDBException;

    public abstract SubscriptionType getBuddySubscription(XMPPResourceConnection var1, JID var2) throws NotAuthorizedException, TigaseDBException;

    public abstract boolean removeBuddy(XMPPResourceConnection var1, JID var2) throws NotAuthorizedException, TigaseDBException;

    public abstract void setBuddyName(XMPPResourceConnection var1, JID var2, String var3) throws NotAuthorizedException, TigaseDBException;

    public abstract void setBuddySubscription(XMPPResourceConnection var1, SubscriptionType var2, JID var3) throws NotAuthorizedException, TigaseDBException;

    public JID[] getBuddies(XMPPResourceConnection session, EnumSet<SubscriptionType> subscrs) throws NotAuthorizedException, TigaseDBException {
        JID[] allBuddies = this.getBuddies(session);
        if (allBuddies == null) {
            return null;
        }
        ArrayList<JID> list = new ArrayList<JID>();
        for (JID buddy : allBuddies) {
            SubscriptionType subs = this.getBuddySubscription(session, buddy);
            if (!subscrs.contains((Object)subs)) continue;
            list.add(buddy);
        }
        return list.toArray(new JID[list.size()]);
    }

    public String getBuddiesHash(XMPPResourceConnection session) {
        return (String)session.getCommonSessionData(ROSTERHASH);
    }

    public Element getBuddyItem(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        String[] groups;
        SubscriptionType subscr = this.getBuddySubscription(session, buddy);
        if (subscr == null) {
            subscr = SubscriptionType.none;
            this.setBuddySubscription(session, subscr, buddy);
        }
        Element item = new Element("item");
        item.setAttribute("jid", buddy.toString());
        item.addAttributes(subscr.getSubscriptionAttr());
        String name = this.getBuddyName(session, buddy);
        if (name != null) {
            item.setAttribute(NAME, XMLUtils.escape((String)name));
        }
        if ((groups = this.getBuddyGroups(session, buddy)) != null) {
            for (String gr : groups) {
                Element group = new Element(GROUP);
                group.setCData(XMLUtils.escape((String)gr));
                item.addChild((XMLNodeIfc)group);
            }
        }
        return item;
    }

    public PresenceType getPresenceType(XMPPResourceConnection session, Packet packet) throws NotAuthorizedException {
        BareJID to = packet.getStanzaTo() != null ? packet.getStanzaTo().getBareJID() : null;
        StanzaType type = packet.getType();
        if (type == null) {
            type = StanzaType.available;
        } else if (type == StanzaType.error) {
            return PresenceType.error;
        }
        if (to == null || !session.isUserId(to)) {
            if (INITIAL_PRESENCES.contains((Object)type)) {
                return PresenceType.out_initial;
            }
            if (type == StanzaType.subscribe) {
                return PresenceType.out_subscribe;
            }
            if (type == StanzaType.unsubscribe) {
                return PresenceType.out_unsubscribe;
            }
            if (type == StanzaType.subscribed) {
                return PresenceType.out_subscribed;
            }
            if (type == StanzaType.unsubscribed) {
                return PresenceType.out_unsubscribed;
            }
        }
        if (to != null && session.isUserId(to)) {
            if (INITIAL_PRESENCES.contains((Object)type)) {
                return PresenceType.in_initial;
            }
            if (type == StanzaType.subscribe) {
                return PresenceType.in_subscribe;
            }
            if (type == StanzaType.unsubscribe) {
                return PresenceType.in_unsubscribe;
            }
            if (type == StanzaType.subscribed) {
                return PresenceType.in_subscribed;
            }
            if (type == StanzaType.unsubscribed) {
                return PresenceType.in_unsubscribed;
            }
            if (type == StanzaType.probe) {
                return PresenceType.in_probe;
            }
        }
        return null;
    }

    public List<Element> getRosterItems(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        LinkedList<Element> items = new LinkedList<Element>();
        JID[] buddies = this.getBuddies(session);
        if (buddies != null) {
            for (JID buddy : buddies) {
                Element buddy_item = this.getBuddyItem(session, buddy);
                items.add(buddy_item);
            }
        }
        return items;
    }

    public SubscriptionType getStateTransition(SubscriptionType subscription, PresenceType presence) {
        return subsToStateMap.get((Object)subscription).getStateTransition(presence);
    }

    public String groupNode(JID buddy) {
        return "roster/" + buddy.getBareJID();
    }

    public void init(UserRepository repo) throws TigaseDBException, TigaseDBException {
    }

    public boolean isPendingIn(XMPPResourceConnection session, JID jid) throws NotAuthorizedException, TigaseDBException {
        SubscriptionType subscr = this.getBuddySubscription(session, jid);
        return PENDING_IN.contains((Object)subscr);
    }

    public boolean isSubscribedFrom(XMPPResourceConnection session, JID jid) throws NotAuthorizedException, TigaseDBException {
        SubscriptionType subscr = this.getBuddySubscription(session, jid);
        return FROM_SUBSCRIBED.contains((Object)subscr);
    }

    public boolean isSubscribedFrom(SubscriptionType subscr) {
        return FROM_SUBSCRIBED.contains((Object)subscr);
    }

    public boolean isSubscribedTo(XMPPResourceConnection session, JID jid) throws NotAuthorizedException, TigaseDBException {
        SubscriptionType subscr = this.getBuddySubscription(session, jid);
        return TO_SUBSCRIBED.contains((Object)subscr);
    }

    public void updateBuddyChange(XMPPResourceConnection session, Queue<Packet> results, Element item) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException {
        Element update = new Element("iq");
        update.setAttribute("type", StanzaType.set.toString());
        Element query = new Element("query");
        query.setXMLNS("jabber:iq:roster");
        query.addChild((XMLNodeIfc)item);
        update.addChild((XMLNodeIfc)query);
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            Element conn_update = update.clone();
            conn_update.setAttribute("to", conn.getBareJID().toString());
            conn_update.setAttribute("id", "rst" + session.nextStanzaId());
            Packet pack_update = Packet.packetInstance(conn_update, null, conn.getJID());
            pack_update.setPacketTo(conn.getConnectionId());
            pack_update.setPacketFrom(session.getJID());
            results.offer(pack_update);
        }
    }

    public boolean updateBuddySubscription(XMPPResourceConnection session, PresenceType presence, JID jid) throws NotAuthorizedException, TigaseDBException {
        SubscriptionType current_subscription = this.getBuddySubscription(session, jid);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("current_subscription=" + (Object)((Object)current_subscription) + " for jid=" + jid);
        }
        if (current_subscription == null) {
            this.addBuddy(session, jid, null, null, null);
            current_subscription = SubscriptionType.none;
        }
        SubscriptionType new_subscription = this.getStateTransition(current_subscription, presence);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("new_subscription=" + (Object)((Object)new_subscription) + " for presence=" + (Object)((Object)presence));
        }
        if (current_subscription == SubscriptionType.none_pending_in && presence == PresenceType.out_unsubscribed) {
            this.removeBuddy(session, jid);
            return false;
        }
        if (current_subscription != new_subscription) {
            this.setBuddySubscription(session, new_subscription, jid);
            return true;
        }
        return false;
    }

    public void updateRosterHash(String roster_str, XMPPResourceConnection session) {
        String roster_hash = null;
        try {
            roster_hash = Algorithms.hexDigest((String)"", (String)roster_str, (String)"MD5");
        }
        catch (Exception e) {
            roster_hash = null;
        }
        session.putCommonSessionData(ROSTERHASH, roster_hash);
    }

    static {
        subsToStateMap.put(SubscriptionType.none, StateTransition.none);
        subsToStateMap.put(SubscriptionType.none_pending_out, StateTransition.none_pending_out);
        subsToStateMap.put(SubscriptionType.none_pending_in, StateTransition.none_pending_in);
        subsToStateMap.put(SubscriptionType.none_pending_out_in, StateTransition.none_pending_out_in);
        subsToStateMap.put(SubscriptionType.to, StateTransition.to);
        subsToStateMap.put(SubscriptionType.to_pending_in, StateTransition.to_pending_in);
        subsToStateMap.put(SubscriptionType.from, StateTransition.from);
        subsToStateMap.put(SubscriptionType.from_pending_out, StateTransition.from_pending_out);
        subsToStateMap.put(SubscriptionType.both, StateTransition.both);
    }

    public static enum PresenceType {
        out_initial,
        out_subscribe,
        out_unsubscribe,
        out_subscribed,
        out_unsubscribed,
        in_initial,
        in_subscribe,
        in_unsubscribe,
        in_subscribed,
        in_unsubscribed,
        in_probe,
        error;

    }

    public static enum SubscriptionType {
        none("none", null),
        none_pending_out("none", "subscribe"),
        none_pending_in("none", null),
        none_pending_out_in("none", "subscribe"),
        to("to", null),
        to_pending_in("to", null),
        from("from", null),
        from_pending_out("from", "subscribe"),
        both("both", null),
        remove("remove", null);

        private Map<String, String> attrs = new LinkedHashMap<String, String>(2, 1.0f);

        private SubscriptionType(String subscr, String ask) {
            this.attrs.put(RosterAbstract.SUBSCRIPTION, subscr);
            if (ask != null) {
                this.attrs.put("ask", ask);
            }
        }

        public Map<String, String> getSubscriptionAttr() {
            return this.attrs;
        }
    }

    public static enum StateTransition {
        none(SubscriptionType.none, SubscriptionType.none, SubscriptionType.none_pending_in, SubscriptionType.none, SubscriptionType.none, SubscriptionType.none, SubscriptionType.none_pending_out, SubscriptionType.none),
        none_pending_out(SubscriptionType.none_pending_out, SubscriptionType.none_pending_out, SubscriptionType.none_pending_out_in, SubscriptionType.none_pending_out, SubscriptionType.to, SubscriptionType.none, SubscriptionType.none_pending_out, SubscriptionType.none),
        none_pending_in(SubscriptionType.from, SubscriptionType.none, SubscriptionType.none_pending_in, SubscriptionType.none, SubscriptionType.none_pending_in, SubscriptionType.none_pending_in, SubscriptionType.none_pending_out_in, SubscriptionType.none_pending_in),
        none_pending_out_in(SubscriptionType.from_pending_out, SubscriptionType.none_pending_out, SubscriptionType.none_pending_out_in, SubscriptionType.none_pending_out, SubscriptionType.to_pending_in, SubscriptionType.none_pending_in, SubscriptionType.none_pending_out_in, SubscriptionType.none_pending_in),
        to(SubscriptionType.to, SubscriptionType.to, SubscriptionType.to_pending_in, SubscriptionType.to, SubscriptionType.to, SubscriptionType.none, SubscriptionType.to, SubscriptionType.none),
        to_pending_in(SubscriptionType.both, SubscriptionType.to, SubscriptionType.to_pending_in, SubscriptionType.to, SubscriptionType.to_pending_in, SubscriptionType.none_pending_in, SubscriptionType.to_pending_in, SubscriptionType.none_pending_in),
        from(SubscriptionType.from, SubscriptionType.none, SubscriptionType.from, SubscriptionType.none, SubscriptionType.from, SubscriptionType.from, SubscriptionType.from_pending_out, SubscriptionType.from),
        from_pending_out(SubscriptionType.from_pending_out, SubscriptionType.none_pending_out, SubscriptionType.from_pending_out, SubscriptionType.none_pending_out, SubscriptionType.both, SubscriptionType.from, SubscriptionType.from_pending_out, SubscriptionType.from),
        both(SubscriptionType.both, SubscriptionType.to, SubscriptionType.both, SubscriptionType.to, SubscriptionType.both, SubscriptionType.from, SubscriptionType.both, SubscriptionType.from);

        private EnumMap<PresenceType, SubscriptionType> stateTransition = new EnumMap(PresenceType.class);

        private StateTransition(SubscriptionType out_subscribed, SubscriptionType out_unsubscribed, SubscriptionType in_subscribe, SubscriptionType in_unsubscribe, SubscriptionType in_subscribed, SubscriptionType in_unsubscribed, SubscriptionType out_subscribe, SubscriptionType out_unsubscribe) {
            this.stateTransition.put(PresenceType.out_subscribed, out_subscribed);
            this.stateTransition.put(PresenceType.out_unsubscribed, out_unsubscribed);
            this.stateTransition.put(PresenceType.in_subscribe, in_subscribe);
            this.stateTransition.put(PresenceType.in_unsubscribe, in_unsubscribe);
            this.stateTransition.put(PresenceType.in_subscribed, in_subscribed);
            this.stateTransition.put(PresenceType.in_unsubscribed, in_unsubscribed);
            this.stateTransition.put(PresenceType.out_subscribe, out_subscribe);
            this.stateTransition.put(PresenceType.out_unsubscribe, out_unsubscribe);
        }

        public SubscriptionType getStateTransition(PresenceType pres_type) {
            SubscriptionType res = this.stateTransition.get((Object)pres_type);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("this=" + this.toString() + ", pres_type=" + (Object)((Object)pres_type) + ", res=" + (Object)((Object)res));
            }
            return res;
        }
    }
}

