/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.util.TigaseStringprepException;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.roster.RosterAbstract;

public class Roster
extends RosterAbstract {
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.Roster");

    @Override
    public void addBuddy(XMPPResourceConnection session, JID jid, String name, String[] groups, String otherData) throws NotAuthorizedException, TigaseDBException {
        String nick = name;
        if ((nick == null || nick.trim().isEmpty()) && ((nick = jid.getLocalpart()) == null || nick.trim().isEmpty())) {
            nick = jid.toString();
        }
        session.setData(this.groupNode(jid), "name", nick);
        session.setData(this.groupNode(jid), "subscription", RosterAbstract.SubscriptionType.none.toString());
        session.setDataList(this.groupNode(jid), "groups", groups);
    }

    @Override
    public boolean addBuddyGroup(XMPPResourceConnection session, JID buddy, String[] groups) throws NotAuthorizedException, TigaseDBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsBuddy(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JID[] getBuddies(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        String[] jids = session.getDataGroups("roster");
        if (jids != null && jids.length > 0) {
            JID[] result = new JID[jids.length];
            int idx = 0;
            for (String jid : jids) {
                try {
                    result[idx++] = JID.jidInstance((String)jid);
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Can't load user jid from database, stringprep problem: " + jid);
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public String[] getBuddyGroups(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        return session.getDataList(this.groupNode(buddy), "groups");
    }

    @Override
    public String getBuddyName(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        return session.getData(this.groupNode(buddy), "name", null);
    }

    @Override
    public RosterAbstract.SubscriptionType getBuddySubscription(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        String subscr = session.getData(this.groupNode(buddy), "subscription", null);
        if (subscr != null) {
            return RosterAbstract.SubscriptionType.valueOf(subscr);
        }
        return null;
    }

    @Override
    public boolean removeBuddy(XMPPResourceConnection session, JID jid) throws NotAuthorizedException, TigaseDBException {
        session.removeDataGroup(this.groupNode(jid));
        return true;
    }

    @Override
    public void setBuddyName(XMPPResourceConnection session, JID buddy, String name) throws NotAuthorizedException, TigaseDBException {
        session.setData(this.groupNode(buddy), "name", name);
    }

    @Override
    public void setBuddySubscription(XMPPResourceConnection session, RosterAbstract.SubscriptionType subscription, JID buddy) throws NotAuthorizedException, TigaseDBException {
        session.setData(this.groupNode(buddy), "subscription", subscription.toString());
    }
}

