/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.JabberIqRoster;
import tigase.xmpp.impl.Presence;
import tigase.xmpp.impl.roster.RosterAbstract;

public class RosterPresence
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPStopListenerIfc {
    private static Logger log = Logger.getLogger(RosterPresence.class.getName());
    private static final String ID = "roster-presence";
    private static final String PRESENCE = "presence";
    private static final String[] ELEMENTS = new String[]{"presence", "query", "query"};
    private static final String[] XMLNSS = new String[]{"jabber:client", "jabber:iq:roster", "jabber:iq:roster-dynamic"};
    private static final Element[] DISCO_FEATURES = RosterAbstract.DISCO_FEATURES;
    private static final Element[] FEATURES = RosterAbstract.FEATURES;

    @Override
    public int concurrentQueuesNo() {
        return Runtime.getRuntime().availableProcessors() * 2;
    }

    @Override
    public int concurrentThreadsPerQueue() {
        return 1;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Session is null, ignoring packet: " + packet.toString());
            }
            return;
        }
        if (!session.isAuthorized()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Session is not authorized, ignoring packet: " + packet.toString());
            }
            return;
        }
        if (packet.getElemName().equals(PRESENCE)) {
            Presence.process(packet, session, repo, results, settings);
        } else {
            JabberIqRoster.process(packet, session, repo, results, settings);
        }
    }

    @Override
    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        Presence.stopped(session, results, settings);
        JabberIqRoster.stopped(session, results, settings);
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        return FEATURES;
    }
}

