/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.AuthorizationException;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserRepository;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.ConnectionStatus;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.RepositoryAccess;
import tigase.xmpp.XMPPSession;

public class XMPPResourceConnection
extends RepositoryAccess {
    private static final Logger log = Logger.getLogger("tigase.xmpp.XMPPResourceConnection");
    public static final String PRESENCE_KEY = "user-presence";
    private long authenticationTime = 0L;
    private JID connectionId = null;
    private long creationTime = 0L;
    private String defLang = "en";
    private long id_counter = 0L;
    private long lastAccessed = 0L;
    private SessionManagerHandler loginHandler = null;
    private XMPPSession parentSession = null;
    private int priority = 0;
    private String resource = null;
    private Map<String, Object> sessionData = null;
    private String sessionId = null;
    private JID userJid = null;
    private ConnectionStatus connectionStatus = ConnectionStatus.INIT;

    public XMPPResourceConnection(JID connectionId, UserRepository rep, UserAuthRepository authRepo, SessionManagerHandler loginHandler) {
        super(rep, authRepo);
        long currTime = System.currentTimeMillis();
        this.connectionId = connectionId;
        this.loginHandler = loginHandler;
        this.creationTime = currTime;
        this.lastAccessed = currTime;
        this.sessionData = new ConcurrentHashMap<String, Object>(4, 0.9f);
    }

    public List<XMPPResourceConnection> getActiveSessions() throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.parentSession.getActiveResources();
    }

    public JID[] getAllResourcesJIDs() {
        return this.parentSession == null ? null : this.parentSession.getJIDs();
    }

    public long getAuthTime() {
        return this.authenticationTime - this.creationTime;
    }

    @Override
    public final BareJID getBareJID() throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.userJid.getBareJID();
    }

    public Object getCommonSessionData(String key) {
        return this.parentSession == null ? null : this.parentSession.getCommonSessionData(key);
    }

    public JID getConnectionId() throws NoConnectionIdException {
        this.lastAccessed = System.currentTimeMillis();
        if (this.connectionId == null) {
            throw new NoConnectionIdException("Connection ID not set for this session. This is probably the SM session to handle traffic addressed to the server itself. Or maybe it's a bug.");
        }
        return this.connectionId;
    }

    public JID getConnectionId(JID jid) throws NoConnectionIdException {
        return this.parentSession == null || jid == null ? this.connectionId : this.parentSession.getResourceConnection(jid).getConnectionId();
    }

    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getDefLang() {
        return this.defLang;
    }

    public final JID getJID() throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.userJid;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public XMPPSession getParentSession() {
        return this.parentSession;
    }

    public Element getPresence() {
        return (Element)this.getSessionData(PRESENCE_KEY);
    }

    public int getPriority() {
        return this.priority;
    }

    public String getResource() {
        return this.resource;
    }

    public JID getSMComponentId() {
        return this.loginHandler.getComponentId();
    }

    public final Object getSessionData(String key) {
        this.lastAccessed = System.currentTimeMillis();
        return this.sessionData.get(key);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Deprecated
    public BareJID getUserId() throws NotAuthorizedException {
        return this.getBareJID();
    }

    @Override
    public final String getUserName() throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.parentSession.getUserName();
    }

    public final JID getjid() {
        return this.userJid;
    }

    @Override
    public boolean isAuthorized() {
        return super.isAuthorized() && this.parentSession != null;
    }

    public boolean isLocalDomain(String outDomain, boolean includeComponents) {
        return this.loginHandler.isLocalDomain(outDomain, includeComponents);
    }

    public boolean isResourceSet() {
        return this.resource != null;
    }

    public boolean isServerSession() {
        return false;
    }

    public boolean isUserId(BareJID bareJID) throws NotAuthorizedException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        return this.userJid.getBareJID().equals((Object)bareJID);
    }

    @Override
    public final Authorization loginDigest(String user, String digest, String id, String alg) throws NotAuthorizedException, AuthorizationException, TigaseDBException {
        Authorization result = super.loginDigest(user, digest, id, alg);
        if (result == Authorization.AUTHORIZED) {
            this.loginHandler.handleLogin(user, this);
        }
        return result;
    }

    @Override
    public final Authorization loginOther(Map<String, Object> props) throws NotAuthorizedException, AuthorizationException, TigaseDBException {
        Authorization result = super.loginOther(props);
        if (result == Authorization.AUTHORIZED) {
            String nick;
            String user = (String)props.get("user-id");
            if (log.isLoggable(Level.FINEST)) {
                log.finest("UserAuthRepository.USER_ID_KEY: " + user);
            }
            if ((nick = BareJID.parseJID((String)user)[0]) == null) {
                nick = user;
            }
            this.loginHandler.handleLogin(nick, this);
        }
        return result;
    }

    @Override
    public final Authorization loginPlain(String user, String password) throws NotAuthorizedException, AuthorizationException, TigaseDBException {
        Authorization result = super.loginPlain(user, password);
        if (result == Authorization.AUTHORIZED) {
            this.loginHandler.handleLogin(user, this);
        }
        return result;
    }

    @Override
    public final void logout() throws NotAuthorizedException {
        this.loginHandler.handleLogout(this.getUserName(), this);
        this.streamClosed();
        super.logout();
    }

    public String nextStanzaId() {
        return "tig" + ++this.id_counter;
    }

    public void putCommonSessionData(String key, Object value) {
        if (this.parentSession != null) {
            this.parentSession.putCommonSessionData(key, value);
        }
    }

    public final void putSessionData(String key, Object value) {
        this.lastAccessed = System.currentTimeMillis();
        this.sessionData.put(key, value);
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        super.queryAuth(authProps);
    }

    public Object removeCommonSessionData(String key) {
        return this.parentSession == null ? null : this.parentSession.removeCommonSessionData(key);
    }

    public void removeParentSession(XMPPSession parent) {
        this.parentSession = null;
    }

    public final void removeSessionData(String key) {
        this.lastAccessed = System.currentTimeMillis();
        this.sessionData.remove(key);
    }

    public synchronized void setConnectionStatus(ConnectionStatus status) {
        this.connectionStatus = status;
    }

    public void setDefLang(String lang) {
        this.defLang = lang;
    }

    public void setLastAccessed(long argLastAccessed) {
        this.lastAccessed = argLastAccessed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentSession(XMPPSession parent) throws TigaseStringprepException {
        if (parent != null) {
            XMPPResourceConnection xMPPResourceConnection = this;
            synchronized (xMPPResourceConnection) {
                this.userJid = JID.jidInstance((String)parent.getUserName(), (String)this.domain.getVhost(), (String)(this.resource != null ? this.resource : this.sessionId));
            }
        }
        this.parentSession = parent;
    }

    public void setPresence(Element packet) {
        this.putSessionData(PRESENCE_KEY, packet);
        String pr_str = packet.getCData("/presence/priority");
        if (pr_str != null) {
            int pr = 1;
            try {
                pr = Integer.decode(pr_str);
            }
            catch (NumberFormatException e) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Incorrect priority value: " + pr_str + ", setting 1 as default.");
                }
                pr = 1;
            }
            this.setPriority(pr);
        }
        this.loginHandler.handlePresenceSet(this);
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setResource(String argResource) throws NotAuthorizedException, TigaseStringprepException {
        if (!this.isAuthorized()) {
            throw new NotAuthorizedException("Session has not been yet authorised.");
        }
        this.resource = argResource;
        if (this.parentSession != null) {
            this.parentSession.addResourceConnection(this);
        }
        this.userJid = this.userJid.copyWithResource(this.resource == null ? this.sessionId : this.resource);
        this.loginHandler.handleResourceBind(this);
    }

    public void setSessionId(String argSessionId) {
        this.sessionId = argSessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamClosed() {
        if (this.parentSession != null) {
            XMPPResourceConnection xMPPResourceConnection = this;
            synchronized (xMPPResourceConnection) {
                this.parentSession.streamClosed(this);
            }
        }
        this.parentSession = null;
        this.resource = null;
        this.sessionId = null;
    }

    public String toString() {
        return "user_jid=" + this.userJid + ", connectioId=" + this.connectionId;
    }

    @Override
    public Authorization unregister(String name_param) throws NotAuthorizedException, TigaseDBException {
        Authorization auth_res = super.unregister(name_param);
        return auth_res;
    }

    @Override
    protected void login() {
        this.authenticationTime = System.currentTimeMillis();
    }
}

