/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.util.ClassUtil;
import tigase.xmpp.XMPPImplIfc;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPStopListenerIfc;

public class ProcessorFactory {
    private static Logger log = Logger.getLogger("tigase.xmpp.ProcessorFactory");
    private static Map<String, XMPPImplIfc> processors = null;

    public static XMPPPacketFilterIfc getPacketFilter(String id) {
        XMPPImplIfc imp = processors.get(id);
        if (imp instanceof XMPPPacketFilterIfc) {
            return (XMPPPacketFilterIfc)((Object)imp);
        }
        return null;
    }

    private ProcessorFactory() {
    }

    public static XMPPProcessorIfc getProcessor(String id) {
        XMPPImplIfc imp = processors.get(id);
        if (imp instanceof XMPPProcessorIfc) {
            return (XMPPProcessorIfc)imp;
        }
        return null;
    }

    public static XMPPPreprocessorIfc getPreprocessor(String id) {
        XMPPImplIfc imp = processors.get(id);
        if (imp instanceof XMPPPreprocessorIfc) {
            return (XMPPPreprocessorIfc)imp;
        }
        return null;
    }

    public static XMPPPostprocessorIfc getPostprocessor(String id) {
        XMPPImplIfc imp = processors.get(id);
        if (imp instanceof XMPPPostprocessorIfc) {
            return (XMPPPostprocessorIfc)imp;
        }
        return null;
    }

    public static XMPPStopListenerIfc getStopListener(String id) {
        XMPPImplIfc imp = processors.get(id);
        if (imp instanceof XMPPStopListenerIfc) {
            return (XMPPStopListenerIfc)imp;
        }
        return null;
    }

    static {
        try {
            Set procs = ClassUtil.getClassesImplementing(XMPPImplIfc.class);
            processors = new TreeMap<String, XMPPImplIfc>();
            ArrayList<String> elems = new ArrayList<String>();
            for (Class cproc : procs) {
                XMPPImplIfc xproc = (XMPPImplIfc)cproc.newInstance();
                processors.put(xproc.id(), xproc);
                String[] els = xproc.supElements();
                String[] nss = xproc.supNamespaces();
                if (els == null || nss == null) continue;
                for (int i = 0; i < els.length; ++i) {
                    elems.add("  <" + els[i] + " xmlns='" + nss[i] + "'/>\n");
                }
            }
            Collections.sort(elems);
            StringBuilder sb = new StringBuilder();
            for (String elm : elems) {
                sb.append(elm);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Loaded XMPPProcessors:\n" + sb.toString());
            }
        }
        catch (Exception e) {
            System.out.println("Can not load XMPPProcessor implementations");
            e.printStackTrace();
            log.log(Level.SEVERE, "Can not load XMPPProcessor implementations", e);
            System.exit(1);
        }
    }
}

